/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.property;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.property.CdProperty;
import java.lang.reflect.InvocationTargetException;
import org.jetbrains.annotations.Nullable;

public class CdEmbeddedProperty
extends CdProperty {
    private final String name;
    private final CdProperty[] properties;

    public CdEmbeddedProperty(CdProperty ... properties) {
        this.name = CdEmbeddedProperty.setupName(properties);
        this.properties = properties;
    }

    private static String setupName(CdProperty[] properties) {
        StringBuffer sb = new StringBuffer();
        for (int idx = 0; idx < properties.length; ++idx) {
            CdProperty property = properties[idx];
            if (idx > 0) {
                sb.append(".");
            }
            sb.append(property.getName());
        }
        return sb.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return this.getLastProperty().getType();
    }

    @Override
    public boolean isReadOnly() {
        return this.getLastProperty().isReadOnly();
    }

    @Override
    @Nullable
    public Object get(Object bean) throws InvocationTargetException, IllegalAccessException, IllegalArgumentException {
        Object embedded = bean;
        for (int idx = 0; idx < this.properties.length; ++idx) {
            CdProperty property = this.properties[idx];
            if ((embedded = property.get(embedded)) != null) continue;
            return null;
        }
        return embedded;
    }

    @Override
    public void set(Object bean, Object value) throws InvocationTargetException, IllegalAccessException, IllegalArgumentException {
        Object embedded = bean;
        for (int idx = 0; idx < this.properties.length - 1; ++idx) {
            CdProperty property = this.properties[idx];
            if ((embedded = property.get(embedded)) != null) continue;
            throw new CdProgrammingException("embedded bean [" + property.getName() + "] is null - [" + this.name + "]!");
        }
        this.getLastProperty().set(embedded, value);
    }

    private CdProperty getLastProperty() {
        return this.properties[this.properties.length - 1];
    }
}

