/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.olap;

public enum OlapEntityType {
    SCHEMA("SA"),
    CUBE("CE"),
    DIMENSION("DN"),
    HIERARCHY("HY"),
    LEVEL("LL"),
    MEMBER("MR"),
    TUPLE("TE"),
    MEASURE_GROUP("MP"),
    MEASURE("ME"),
    REPORT_CALC_MEASURE("RCME"),
    REPORT_FOLDER("RPF"),
    REPORT("RP"),
    REPORT_SNAPSHOT("RPS"),
    OTHER("OT");

    private final String shortName;

    private OlapEntityType(String shortName) {
        this.shortName = shortName;
    }

    public boolean isMember() {
        return this == MEMBER || this == MEASURE;
    }

    public String getShortName() {
        return this.shortName;
    }

    public static OlapEntityType valueOfShortName(String shortNAme) {
        for (OlapEntityType entityType : OlapEntityType.values()) {
            if (!entityType.getShortName().equals(shortNAme)) continue;
            return entityType;
        }
        throw new IllegalArgumentException("No OlapEntityType for [" + shortNAme + "]");
    }
}

