/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.mdx.scanner.token;

import crazydev.common.mdx.scanner.CdMdxToken;
import crazydev.common.mdx.scanner.CdMdxTokenKind;
import crazydev.common.mdx.scanner.CdMdxTokenLocation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class CdMdxKeywordToken
extends CdMdxToken {
    private static final Map<String, CdMdxTokenKind> keywords = new HashMap<String, CdMdxTokenKind>();

    public CdMdxKeywordToken(CdMdxTokenLocation where, CdMdxTokenKind kind, String lexeme) {
        super(where, kind, lexeme);
    }

    private static void register(CdMdxTokenKind kind) {
        keywords.put(kind.name().toLowerCase(), kind);
    }

    public static Collection<CdMdxTokenKind> getKeywords() {
        return keywords.values();
    }

    @Nullable
    public static CdMdxKeywordToken createKeyword(CdMdxTokenLocation where, String identifier) {
        CdMdxTokenKind kind = keywords.get(identifier.toLowerCase());
        if (kind != null) {
            return new CdMdxKeywordToken(where, kind, identifier);
        }
        return null;
    }

    static {
        CdMdxKeywordToken.register(CdMdxTokenKind.AGGR_SUM);
        CdMdxKeywordToken.register(CdMdxTokenKind.AGGR_SUM_HIGH_PRECISION);
        CdMdxKeywordToken.register(CdMdxTokenKind.AGGR_SUM_SQUARE);
        CdMdxKeywordToken.register(CdMdxTokenKind.AGGR_MIN);
        CdMdxKeywordToken.register(CdMdxTokenKind.AGGR_MAX);
        CdMdxKeywordToken.register(CdMdxTokenKind.AGGR_AVG_LEAVES);
        CdMdxKeywordToken.register(CdMdxTokenKind.AGGR_COUNT);
        CdMdxKeywordToken.register(CdMdxTokenKind.AGGR_DISTINCT_COUNT);
        CdMdxKeywordToken.register(CdMdxTokenKind.AGGR_NONE);
        CdMdxKeywordToken.register(CdMdxTokenKind.AGGR_NO_EMPTY);
        CdMdxKeywordToken.register(CdMdxTokenKind.AGGR_VECTOR);
        CdMdxKeywordToken.register(CdMdxTokenKind.AGGR_VECTOR_ROW_NUMBER);
        CdMdxKeywordToken.register(CdMdxTokenKind.AGGR_VECTOR_SORTED);
        CdMdxKeywordToken.register(CdMdxTokenKind.AGGR_VECTOR_UNIQUE);
        CdMdxKeywordToken.register(CdMdxTokenKind.AGGR_NO_EMPTY_ROWS);
        CdMdxKeywordToken.register(CdMdxTokenKind.ACTION);
        CdMdxKeywordToken.register(CdMdxTokenKind.ALERT);
        CdMdxKeywordToken.register(CdMdxTokenKind.AND);
        CdMdxKeywordToken.register(CdMdxTokenKind.AS);
        CdMdxKeywordToken.register(CdMdxTokenKind.AXES);
        CdMdxKeywordToken.register(CdMdxTokenKind.AXIS);
        CdMdxKeywordToken.register(CdMdxTokenKind.BEGIN);
        CdMdxKeywordToken.register(CdMdxTokenKind.BY);
        CdMdxKeywordToken.register(CdMdxTokenKind.CALCULATED);
        CdMdxKeywordToken.register(CdMdxTokenKind.CASE);
        CdMdxKeywordToken.register(CdMdxTokenKind.CATEGORY);
        CdMdxKeywordToken.register(CdMdxTokenKind.CELL);
        CdMdxKeywordToken.register(CdMdxTokenKind.CHAPTERS);
        CdMdxKeywordToken.register(CdMdxTokenKind.COLUMNS);
        CdMdxKeywordToken.register(CdMdxTokenKind.COMMIT);
        CdMdxKeywordToken.register(CdMdxTokenKind.CONST);
        CdMdxKeywordToken.register(CdMdxTokenKind.CREATE);
        CdMdxKeywordToken.register(CdMdxTokenKind.CUBE);
        CdMdxKeywordToken.register(CdMdxTokenKind.DEFINE_DEFAULT_MEMBER);
        CdMdxKeywordToken.register(CdMdxTokenKind.DRILLTHROUGH);
        CdMdxKeywordToken.register(CdMdxTokenKind.DROP);
        CdMdxKeywordToken.register(CdMdxTokenKind.DYNAMIC);
        CdMdxKeywordToken.register(CdMdxTokenKind.ELSE);
        CdMdxKeywordToken.register(CdMdxTokenKind.EMPTY);
        CdMdxKeywordToken.register(CdMdxTokenKind.END);
        CdMdxKeywordToken.register(CdMdxTokenKind.EXISTING);
        CdMdxKeywordToken.register(CdMdxTokenKind.FILTERBY);
        CdMdxKeywordToken.register(CdMdxTokenKind.FROM);
        CdMdxKeywordToken.register(CdMdxTokenKind.FUNCTION);
        CdMdxKeywordToken.register(CdMdxTokenKind.IC3RUN);
        CdMdxKeywordToken.register(CdMdxTokenKind.IS);
        CdMdxKeywordToken.register(CdMdxTokenKind.MAXROWS);
        CdMdxKeywordToken.register(CdMdxTokenKind.MEASURE);
        CdMdxKeywordToken.register(CdMdxTokenKind.MEMBER);
        CdMdxKeywordToken.register(CdMdxTokenKind.NATIVE);
        CdMdxKeywordToken.register(CdMdxTokenKind.NON);
        CdMdxKeywordToken.register(CdMdxTokenKind.NOT);
        CdMdxKeywordToken.register(CdMdxTokenKind.ON);
        CdMdxKeywordToken.register(CdMdxTokenKind.OR);
        CdMdxKeywordToken.register(CdMdxTokenKind.PAGES);
        CdMdxKeywordToken.register(CdMdxTokenKind.RETURN);
        CdMdxKeywordToken.register(CdMdxTokenKind.ROLLBACK);
        CdMdxKeywordToken.register(CdMdxTokenKind.ROWS);
        CdMdxKeywordToken.register(CdMdxTokenKind.SECTIONS);
        CdMdxKeywordToken.register(CdMdxTokenKind.SELECT);
        CdMdxKeywordToken.register(CdMdxTokenKind.SESSION);
        CdMdxKeywordToken.register(CdMdxTokenKind.SET);
        CdMdxKeywordToken.register(CdMdxTokenKind.STATIC);
        CdMdxKeywordToken.register(CdMdxTokenKind.SET_TABLE_AGGREGATOR);
        CdMdxKeywordToken.register(CdMdxTokenKind.THEN);
        CdMdxKeywordToken.register(CdMdxTokenKind.TIDYPOSTPROCESSOR);
        CdMdxKeywordToken.register(CdMdxTokenKind.TRANSACTION);
        CdMdxKeywordToken.register(CdMdxTokenKind.UPDATE);
        CdMdxKeywordToken.register(CdMdxTokenKind.VISUAL);
        CdMdxKeywordToken.register(CdMdxTokenKind.WHEN);
        CdMdxKeywordToken.register(CdMdxTokenKind.WHERE);
        CdMdxKeywordToken.register(CdMdxTokenKind.WITH);
        CdMdxKeywordToken.register(CdMdxTokenKind.XOR);
        CdMdxKeywordToken.register(CdMdxTokenKind.ADD_TO_RESULT);
        CdMdxKeywordToken.register(CdMdxTokenKind.AFTER);
        CdMdxKeywordToken.register(CdMdxTokenKind.ALL);
        CdMdxKeywordToken.register(CdMdxTokenKind.ASC);
        CdMdxKeywordToken.register(CdMdxTokenKind.BASC);
        CdMdxKeywordToken.register(CdMdxTokenKind.BDESC);
        CdMdxKeywordToken.register(CdMdxTokenKind.BEFORE);
        CdMdxKeywordToken.register(CdMdxTokenKind.BEFORE_AND_AFTER);
        CdMdxKeywordToken.register(CdMdxTokenKind.CASE_SENSITIVE);
        CdMdxKeywordToken.register(CdMdxTokenKind.CASE_INSENSITIVE);
        CdMdxKeywordToken.register(CdMdxTokenKind.CONSTRAINED);
        CdMdxKeywordToken.register(CdMdxTokenKind.DESC);
        CdMdxKeywordToken.register(CdMdxTokenKind.EXCLUDEEMPTY);
        CdMdxKeywordToken.register(CdMdxTokenKind.INCLUDEEMPTY);
        CdMdxKeywordToken.register(CdMdxTokenKind.LEAVES);
        CdMdxKeywordToken.register(CdMdxTokenKind.POST);
        CdMdxKeywordToken.register(CdMdxTokenKind.RECURSIVE);
        CdMdxKeywordToken.register(CdMdxTokenKind.SELF);
        CdMdxKeywordToken.register(CdMdxTokenKind.SELF_AND_AFTER);
        CdMdxKeywordToken.register(CdMdxTokenKind.SELF_AND_BEFORE);
        CdMdxKeywordToken.register(CdMdxTokenKind.SELF_BEFORE_AFTER);
        CdMdxKeywordToken.register(CdMdxTokenKind.STR_NUMBERS);
        CdMdxKeywordToken.register(CdMdxTokenKind.TYPED);
        CdMdxKeywordToken.register(CdMdxTokenKind.EAGER);
        CdMdxKeywordToken.register(CdMdxTokenKind.HINT);
        CdMdxKeywordToken.register(CdMdxTokenKind.LAZY);
        CdMdxKeywordToken.register(CdMdxTokenKind.STRICT);
        CdMdxKeywordToken.register(CdMdxTokenKind.USE_EQUAL_ALLOCATION);
        CdMdxKeywordToken.register(CdMdxTokenKind.USE_EQUAL_INCREMENT);
        CdMdxKeywordToken.register(CdMdxTokenKind.USE_WEIGHTED_ALLOCATION);
        CdMdxKeywordToken.register(CdMdxTokenKind.USE_WEIGHTED_INCREMENT);
    }
}

