/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.mdx.scanner;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.mdx.error.CdMdxErrorLocation;
import java.io.Serializable;

public class CdMdxTokenLocationRange
extends CdMdxErrorLocation
implements Comparable<CdMdxTokenLocationRange>,
Serializable {
    private static final long serialVersionUID = -5006906967373531293L;
    private final String mdx;
    private final String mdxHash;
    private int from;
    private int to;
    private int lineNumber;

    public CdMdxTokenLocationRange(String mdx, String mdxHash, int from, int to, int lineNumber) {
        this.mdx = mdx;
        this.mdxHash = mdxHash;
        this.from = from;
        this.to = to;
        this.lineNumber = lineNumber;
    }

    public String mdx() {
        return this.mdx;
    }

    public String mdxHash() {
        return this.mdxHash;
    }

    @Override
    public int from() {
        return this.from;
    }

    public int to() {
        return this.to;
    }

    @Override
    public int lineNumber() {
        return this.lineNumber;
    }

    @Override
    public int compareTo(CdMdxTokenLocationRange other) {
        int thisOffset = this.from;
        int otherOffset = other.from;
        return thisOffset < otherOffset ? -1 : (thisOffset == otherOffset ? 0 : 1);
    }

    @Override
    public void updateLocationRange(int from, int to) {
        this.from = from;
        this.to = to;
    }

    public boolean equals(Object o) {
        throw new CdProgrammingException();
    }

    public int hashCode() {
        throw new CdProgrammingException();
    }

    @Override
    public String asString(CdBabylonService babylon) {
        return "line:" + this.lineNumber;
    }
}

