/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.mdx.scanner;

import crazydev.common.mdx.scanner.token.CdMdxKeywordToken;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public enum CdMdxTokenKind {
    ACTION("action"),
    ANNOTATION("annotation"),
    PARAMETER("parameter"),
    PREPROCESSOR("preprocessor"),
    REGULAR_IDENTIFIER(2, "identifier"),
    DELIMITED_IDENTIFIER(2, "delimited identifier"),
    AMP_DELIMITED_IDENTIFIER(2, "key identifier"),
    STRING("string"),
    LONG("long"),
    DOUBLE("double"),
    NULL("NULL"),
    TRUE("TRUE"),
    FALSE("FALSE"),
    COMMA(","),
    DOT("."),
    OPEN_CURLY_BRACE("{"),
    CLOSE_CURLY_BRACE("}"),
    OPEN_PAREN("("),
    CLOSE_PAREN(")"),
    SEMI_COLON(";"),
    OBJ_MC("->"),
    EQEQ(4, "=="),
    NEQEQ(4, "!="),
    EQ(4, "="),
    NE(4, "<>"),
    GGT(4, ">>"),
    GGE(4, ">>="),
    LLT(4, "<<"),
    LLE(4, "<<="),
    GT(4, ">"),
    GE(4, ">="),
    LT(4, "<"),
    LE(4, "<="),
    PLUS("+"),
    MINUS("-"),
    DIVIDE("/"),
    MULTIPLY("*"),
    POWER("^"),
    RANGE(":"),
    AND("AND"),
    IS("IS"),
    IS_NOT("IS NOT"),
    NOT("NOT"),
    OR("OR"),
    XOR("XOR"),
    ALERT("ALERT"),
    AS("AS"),
    AXES("AXES"),
    AXIS("AXIS"),
    BEGIN("BEGIN"),
    BY("BY"),
    CALCULATED("CALCULATED"),
    CASE("CASE"),
    CATEGORY("CATEGORY"),
    CELL("CELL"),
    CHAPTERS("CHAPTERS"),
    COLUMNS("COLUMNS"),
    COMMIT("COMMIT"),
    CONST("CONST"),
    CREATE("CREATE"),
    CUBE("CUBE"),
    DEFINE_DEFAULT_MEMBER("DEFINE_DEFAULT_MEMBER"),
    DRILLTHROUGH("DRILLTHROUGH"),
    DROP("DROP"),
    DYNAMIC("DYNAMIC"),
    ELSE("ELSE"),
    EMPTY("EMPTY"),
    END("END"),
    EXISTING("EXISTING"),
    FILTERBY("FILTERBY"),
    FROM("FROM"),
    FUNCTION("FUNCTION"),
    IC3RUN("IC3RUN"),
    MAXROWS("MAXROWS"),
    MEMBER("MEMBER"),
    NATIVE("NATIVE"),
    NON("NON"),
    ON("ON"),
    PAGES("PAGES"),
    RETURN("RETURN"),
    ROLLBACK("ROLLBACK"),
    ROWS("ROWS"),
    SECTIONS("SECTIONS"),
    SELECT("SELECT"),
    SESSION("SESSION"),
    SET("SET"),
    STATIC("STATIC"),
    SET_TABLE_AGGREGATOR("SET_TABLE_AGGREGATOR"),
    THEN("THEN"),
    TIDYPOSTPROCESSOR("TIDYPOSTPROCESSOR"),
    TRANSACTION("TRANSACTION"),
    UPDATE("UPDATE"),
    VISUAL("VISUAL"),
    WHEN("WHEN"),
    WHERE("WHERE"),
    WITH("WITH"),
    USE_EQUAL_ALLOCATION("USE_EQUAL_ALLOCATION"),
    USE_EQUAL_INCREMENT("USE_EQUAL_INCREMENT"),
    USE_WEIGHTED_ALLOCATION("USE_WEIGHTED_ALLOCATION"),
    USE_WEIGHTED_INCREMENT("USE_WEIGHTED_INCREMENT"),
    ADD_TO_RESULT(8, "ADD_TO_RESULT"),
    AFTER(8, "AFTER"),
    ALL(8, "ALL"),
    ASC(8, "ASC"),
    BASC(8, "BASC"),
    BDESC(8, "BDESC"),
    BEFORE(8, "BEFORE"),
    BEFORE_AND_AFTER(8, "BEFORE_AND_AFTER"),
    CASE_SENSITIVE(8, "CASE_SENSITIVE"),
    CASE_INSENSITIVE(8, "CASE_INSENSITIVE"),
    CONSTRAINED(8, "CONSTRAINED"),
    DESC(8, "DESC"),
    EXCLUDEEMPTY(8, "EXCLUDEEMPTY"),
    INCLUDEEMPTY(8, "INCLUDEEMPTY"),
    LEAVES(8, "LEAVES"),
    POST(8, "POST"),
    RECURSIVE(8, "RECURSIVE"),
    SELF(8, "SELF"),
    SELF_AND_AFTER(8, "SELF_AND_AFTER"),
    SELF_AND_BEFORE(8, "SELF_AND_BEFORE"),
    SELF_BEFORE_AFTER(8, "SELF_BEFORE_AFTER"),
    STR_NUMBERS(8, "STR_NUMBERS"),
    TYPED(8, "TYPED"),
    EAGER(1, "EAGER"),
    HINT(1, "HINT"),
    LAZY(1, "LAZY"),
    STRICT(1, "STRICT"),
    DIMENSION("DIMENSION"),
    PROPERTIES("PROPERTIES"),
    COMMENT(16, "comment"),
    WHITE_SPACES(16, "white spaces"),
    EOL(16, "end of line"),
    MEASURE("MEASURE"),
    AGGR_SUM(32, "AGGR_SUM"),
    AGGR_SUM_HIGH_PRECISION(32, "AGGR_SUM_HIGH_PRECISION"),
    AGGR_SUM_SQUARE(32, "AGGR_SUM_SQUARE"),
    AGGR_MIN(32, "AGGR_MIN"),
    AGGR_MAX(32, "AGGR_MAX"),
    AGGR_AVG_LEAVES(32, "AVG_LEAVES"),
    AGGR_COUNT(32, "AGGR_COUNT"),
    AGGR_DISTINCT_COUNT(32, "AGGR_DISTINCT_COUNT"),
    AGGR_NONE(32, "AGGR_NONE"),
    AGGR_NO_EMPTY(32, "AGGR_NO_EMPTY"),
    AGGR_VECTOR(32, "AGGR_VECTOR"),
    AGGR_VECTOR_SORTED(32, "AGGR_VECTOR_SORTED"),
    AGGR_VECTOR_UNIQUE(32, "AGGR_VECTOR_UNIQUE"),
    AGGR_VECTOR_ROW_NUMBER(32, "AGGR_VECTOR_ROW_NUMBER"),
    AGGR_NO_EMPTY_ROWS(32, "AGGR_NO_EMPTY_ROWS"),
    _LAST("_LAST");

    private final int kind;
    private final String lexemeForError;

    private CdMdxTokenKind(String lexemeForError) {
        this(0, lexemeForError);
    }

    private CdMdxTokenKind(int kind, String lexemeForError) {
        this.kind = kind;
        this.lexemeForError = lexemeForError;
    }

    public static boolean isIIfHint(@Nullable CdMdxTokenKind kind) {
        return kind != null && (kind.kind & 1) == 1;
    }

    public static boolean isIdentifier(@Nullable CdMdxTokenKind kind) {
        return kind != null && (kind.kind & 2) == 2;
    }

    public static boolean isCompOperator(@Nullable CdMdxTokenKind kind) {
        return kind != null && (kind.kind & 4) == 4;
    }

    public static boolean isOption(@Nullable CdMdxTokenKind kind) {
        return kind != null && (kind.kind & 8) == 8;
    }

    public static boolean isInvisible(@Nullable CdMdxTokenKind kind) {
        return kind != null && (kind.kind & 0x10) == 16;
    }

    public static boolean isAggrType(@Nullable CdMdxTokenKind kind) {
        return kind != null && (kind.kind & 0x20) == 32;
    }

    public static boolean isKeyword(@Nullable CdMdxTokenKind kind) {
        return kind != null && CdMdxKeywordToken.getKeywords().contains((Object)kind);
    }

    public static List<CdMdxTokenKind> allOptions() {
        ArrayList<CdMdxTokenKind> options = new ArrayList<CdMdxTokenKind>();
        for (CdMdxTokenKind kind : CdMdxTokenKind.values()) {
            if (!CdMdxTokenKind.isOption(kind)) continue;
            options.add(kind);
        }
        return options;
    }

    public static List<CdMdxTokenKind> allKeywords() {
        ArrayList<CdMdxTokenKind> options = new ArrayList<CdMdxTokenKind>();
        for (CdMdxTokenKind kind : CdMdxTokenKind.values()) {
            if (!CdMdxTokenKind.isKeyword(kind)) continue;
            options.add(kind);
        }
        return options;
    }

    public String getLexemeForError() {
        return this.lexemeForError;
    }
}

