/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.mdx.scanner;

import crazydev.common.mdx.error.CdMdxError;
import crazydev.common.mdx.error.CdMdxErrorCode;
import crazydev.common.mdx.scanner.CdMdxReader;
import crazydev.common.mdx.scanner.CdMdxToken;
import crazydev.common.mdx.scanner.CdMdxTokenKind;
import crazydev.common.mdx.scanner.CdMdxTokenLocation;
import crazydev.common.mdx.scanner.CdMdxTokenLocationRange;
import crazydev.common.mdx.scanner.exception.CdMdxScannerException;
import crazydev.common.mdx.scanner.token.CdMdxAmpDelimitedCompositeIdentifierToken;
import crazydev.common.mdx.scanner.token.CdMdxAmpDelimitedSingleIdentifierToken;
import crazydev.common.mdx.scanner.token.CdMdxAnnotationToken;
import crazydev.common.mdx.scanner.token.CdMdxDelimitedIdentifierToken;
import crazydev.common.mdx.scanner.token.CdMdxDoubleToken;
import crazydev.common.mdx.scanner.token.CdMdxKeywordToken;
import crazydev.common.mdx.scanner.token.CdMdxLongToken;
import crazydev.common.mdx.scanner.token.CdMdxParameterToken;
import crazydev.common.mdx.scanner.token.CdMdxPreProcessorToken;
import crazydev.common.mdx.scanner.token.CdMdxRegularIdentifierToken;
import crazydev.common.mdx.scanner.token.CdMdxStringToken;
import crazydev.common.utils.CdStringUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class CdMdxScanner {
    public static final int CR = 13;
    public static final int LF = 10;
    public static final int NBSP = 160;
    public static final int ZWS = 8203;
    private static final int NEUTRAL = 8709;
    public static boolean isMdxScannerAssertTokenLocation;
    private final boolean acceptSCAN_EMPTY_DELIMITED_ID;
    @Nullable
    private final String mdx;
    private final String mdxHash;
    private final int offsetOffset;
    private final int offsetLineNumber;
    private CdMdxReader in;
    private int offset;
    private int lineNumber;
    private String scannedMdx;
    private String scannedMdxHash;

    public CdMdxScanner() {
        this(null, null, 0, 1);
    }

    public CdMdxScanner(boolean acceptSCAN_EMPTY_DELIMITED_ID) {
        this(acceptSCAN_EMPTY_DELIMITED_ID, null, null, 0, 1);
    }

    public CdMdxScanner(String mdx, String mdxHash, int offsetOffset, int offsetLineNumber) {
        this(false, mdx, mdxHash, offsetOffset, offsetLineNumber);
    }

    public CdMdxScanner(boolean acceptSCAN_EMPTY_DELIMITED_ID, String mdx, String mdxHash, int offsetOffset, int offsetLineNumber) {
        this.acceptSCAN_EMPTY_DELIMITED_ID = acceptSCAN_EMPTY_DELIMITED_ID;
        this.mdx = mdx;
        this.mdxHash = mdxHash;
        this.offsetOffset = offsetOffset;
        this.offsetLineNumber = offsetLineNumber;
        this.lineNumber = 1;
    }

    public List<CdMdxToken> scan(String mdx, String mdxHash) throws CdMdxScannerException {
        try {
            return this.doScan(false, mdx, mdxHash);
        }
        catch (IOException ex) {
            throw new RuntimeException("MDX scanner unexpected IO error", ex);
        }
    }

    public List<CdMdxToken> scan(boolean acceptDashboardEvents, String mdx, String mdxHash) throws CdMdxScannerException {
        try {
            return this.doScan(acceptDashboardEvents, mdx, mdxHash);
        }
        catch (IOException ex) {
            throw new RuntimeException("MDX scanner unexpected IO error", ex);
        }
    }

    private List<CdMdxToken> doScan(boolean acceptDashboardEvents, String mdx, String mdxHash) throws IOException, CdMdxScannerException {
        ArrayList<CdMdxToken> tokens = new ArrayList<CdMdxToken>();
        try {
            int cc;
            mdx = CdStringUtils.isNotNullAndNotBlank(mdx) ? mdx.replace("\u00a0", " ") : mdx;
            this.scannedMdx = mdx = CdStringUtils.isNotNullAndNotBlank(mdx) ? mdx.replace("\u200b", " ") : mdx;
            this.scannedMdxHash = mdxHash;
            this.in = new CdMdxReader(mdx);
            this.offset = this.offsetOffset - 1;
            while ((cc = this.read()) != -1) {
                CdMdxToken token;
                if (cc == 64) {
                    token = acceptDashboardEvents ? this.scanEvent(cc) : this.scanParameter(cc);
                    CdMdxScanner.addToken(tokens, token);
                    continue;
                }
                if (CdMdxScanner.isNumberStart(cc)) {
                    token = this.scanNumber(cc);
                    CdMdxScanner.addToken(tokens, token);
                    continue;
                }
                if (CdMdxScanner.isSingleQuoteStringStart(cc)) {
                    token = this.scanSingleQuotedString(cc);
                    CdMdxScanner.addToken(tokens, token);
                    continue;
                }
                if (CdMdxScanner.isDoubleQuoteStringStart(cc)) {
                    token = this.scanDoubleQuotedString(cc);
                    CdMdxScanner.addToken(tokens, token);
                    continue;
                }
                if (cc == 38) {
                    token = this.scanAmpDelimitedIdentifier(cc);
                    CdMdxScanner.addToken(tokens, token);
                    continue;
                }
                if (cc == 91) {
                    token = this.scanDelimitedIdentifier(cc);
                    CdMdxScanner.addToken(tokens, token);
                    continue;
                }
                if (CdMdxScanner.isRegularIdentifierOrKeywordStart(cc)) {
                    token = this.scanRegularIdentifierOrKeyword(cc);
                    if (CdMdxTokenKind.isIIfHint(token.getKind())) break;
                    CdMdxScanner.addToken(tokens, token);
                    continue;
                }
                token = this.scanOperatorOrSeparator(cc);
                if (token != null) {
                    CdMdxScanner.addToken(tokens, token);
                    continue;
                }
                if (cc == 45 || cc == 47) {
                    token = this.scanComments(cc);
                    CdMdxScanner.addToken(tokens, token);
                    continue;
                }
                if (CdMdxScanner.isEndOfLineStart(cc)) {
                    token = this.scanEndOfLine(cc);
                    CdMdxScanner.addToken(tokens, token);
                    continue;
                }
                if (CdMdxScanner.isWhiteSpace(cc)) {
                    token = this.scanWhiteSpace(cc);
                    CdMdxScanner.addToken(tokens, token);
                    continue;
                }
                if (cc == 35) {
                    token = this.scanPreProcessorDirective(cc);
                    CdMdxScanner.addToken(tokens, token);
                    continue;
                }
                this.onScannerError(this.range(this.where()), null, CdMdxErrorCode.SCAN_UNSUPPORTED_CHAR, Character.valueOf((char)cc), Integer.valueOf(cc), Integer.valueOf(this.offset));
            }
            if (isMdxScannerAssertTokenLocation) {
                this.assertLocationConsistency(mdx, mdxHash, tokens);
            }
            ArrayList<CdMdxToken> arrayList = tokens;
            return arrayList;
        }
        catch (CdMdxScannerException ex) {
            ex.attachTokens(tokens);
            throw ex;
        }
        finally {
            if (this.in != null) {
                this.in.close();
            }
        }
    }

    private static CdMdxToken addToken(List<CdMdxToken> tokens, CdMdxToken token) {
        tokens.add(token);
        return token;
    }

    private CdMdxTokenLocation where() {
        if (this.mdx == null) {
            return new CdMdxTokenLocation(this.scannedMdx, this.scannedMdxHash, this.offset, this.lineNumber);
        }
        return new CdMdxTokenLocation(this.mdx, this.mdxHash, this.offset, this.lineNumber);
    }

    private CdMdxTokenLocationRange range(CdMdxTokenLocation from) {
        if (this.mdx == null) {
            return new CdMdxTokenLocationRange(this.scannedMdx, this.scannedMdxHash, from.offset(), this.offset, from.lineNumber());
        }
        return new CdMdxTokenLocationRange(this.mdx, this.mdxHash, from.offset(), this.offset, from.lineNumber());
    }

    private int read() throws IOException {
        int cc = this.in.read();
        if (cc != -1) {
            ++this.offset;
        }
        return cc;
    }

    private void unread(int cc) throws IOException {
        if (cc != -1) {
            this.in.unread(cc);
            --this.offset;
        }
    }

    private CdMdxToken scanParameter(int cc) throws IOException, CdMdxScannerException {
        CdMdxTokenLocation begin = this.where();
        StringBuilder sb = new StringBuilder();
        sb.append((char)cc);
        cc = this.read();
        if (cc != -1) {
            if (Character.isJavaIdentifierStart(cc)) {
                sb.append((char)cc);
                while ((cc = this.read()) != -1) {
                    if (Character.isJavaIdentifierStart(cc)) {
                        sb.append((char)cc);
                        continue;
                    }
                    this.unread(cc);
                    break;
                }
            } else {
                this.unread(cc);
            }
        }
        if (sb.length() <= 1) {
            this.onScannerError(this.range(begin), CdMdxTokenKind.PARAMETER, CdMdxErrorCode.SCAN_INVALID_PARAM, new Serializable[]{sb.toString()});
        }
        return new CdMdxParameterToken(begin, sb.toString());
    }

    private CdMdxToken scanEvent(int cc) throws IOException, CdMdxScannerException {
        CdMdxTokenLocation begin = this.where();
        StringBuilder sb = new StringBuilder();
        sb.append((char)cc);
        cc = this.read();
        if (cc != -1) {
            if (cc == 123 || Character.isJavaIdentifierStart(cc)) {
                sb.append((char)cc);
                while ((cc = this.read()) != -1) {
                    if (cc == 125) {
                        sb.append((char)cc);
                    } else {
                        if (Character.isJavaIdentifierStart(cc)) {
                            sb.append((char)cc);
                            continue;
                        }
                        this.unread(cc);
                    }
                    break;
                }
            } else {
                this.unread(cc);
            }
        }
        if (sb.length() <= 1) {
            this.onScannerError(this.range(begin), CdMdxTokenKind.PARAMETER, CdMdxErrorCode.SCAN_INVALID_PARAM, new Serializable[]{sb.toString()});
        }
        return new CdMdxParameterToken(begin, sb.toString());
    }

    private CdMdxToken scanAnnotation(CdMdxTokenLocation begin, int cc) throws IOException, CdMdxScannerException {
        StringBuilder sb = new StringBuilder();
        sb.append("//");
        sb.append((char)cc);
        cc = this.read();
        if (cc != -1) {
            if (Character.isJavaIdentifierStart(cc)) {
                sb.append((char)cc);
                while ((cc = this.read()) != -1) {
                    if (Character.isJavaIdentifierStart(cc)) {
                        sb.append((char)cc);
                        continue;
                    }
                    this.unread(cc);
                    break;
                }
            } else {
                this.unread(cc);
            }
        }
        if (sb.length() <= 1) {
            this.onScannerError(this.range(begin), CdMdxTokenKind.ANNOTATION, CdMdxErrorCode.SCAN_INVALID_ANNOTATION, new Serializable[]{sb.toString()});
        }
        return new CdMdxAnnotationToken(begin, sb.toString());
    }

    private CdMdxToken scanPreProcessorDirective(int cc) throws IOException, CdMdxScannerException {
        CdMdxTokenLocation begin = this.where();
        StringBuilder sb = new StringBuilder();
        sb.append((char)cc);
        cc = this.read();
        if (cc != -1) {
            if (Character.isJavaIdentifierStart(cc)) {
                sb.append((char)cc);
                while ((cc = this.read()) != -1) {
                    if (Character.isJavaIdentifierStart(cc)) {
                        sb.append((char)cc);
                        continue;
                    }
                    this.unread(cc);
                    break;
                }
            } else {
                this.unread(cc);
            }
        }
        if (sb.length() <= 1) {
            this.onScannerError(this.range(begin), CdMdxTokenKind.PREPROCESSOR, CdMdxErrorCode.SCAN_INVALID_PREPROCESSOR, new Serializable[]{sb.toString()});
        }
        return new CdMdxPreProcessorToken(begin, sb.toString());
    }

    private static boolean isWhiteSpace(int cc) {
        if (cc == 160) {
            return true;
        }
        return Character.isWhitespace(cc) || 160 == cc || 8203 == cc;
    }

    public static boolean isEndOfLineStart(int cc) {
        return cc == 13 || cc == 10;
    }

    public static boolean isSeparator(int cc) {
        return CdMdxScanner.isWhiteSpace(cc) || CdMdxScanner.isEndOfLineStart(cc) || 46 == cc || 44 == cc || 59 == cc || 43 == cc || 45 == cc || 47 == cc || 42 == cc || 94 == cc || 123 == cc || 125 == cc || 40 == cc || 41 == cc || 61 == cc || 62 == cc || 60 == cc;
    }

    private static boolean isNumberStart(int cc) {
        return cc >= 48 && cc <= 57;
    }

    private static boolean isDigit(int cc) {
        return cc >= 48 && cc <= 57;
    }

    private CdMdxToken scanNumber(int cc) throws IOException, CdMdxScannerException {
        CdMdxTokenLocation begin = this.where();
        StringBuilder sb = new StringBuilder();
        this.scanInt(sb, cc);
        boolean isFloat = false;
        cc = this.read();
        if (cc == 46) {
            this.scanFrac(sb, cc);
            isFloat = true;
        } else {
            this.unread(cc);
        }
        cc = this.read();
        if (CdMdxScanner.isExpStart(cc)) {
            this.scanExp(sb, cc);
            isFloat = true;
        } else {
            this.unread(cc);
        }
        String lexeme = sb.toString();
        try {
            if (isFloat) {
                double number = Double.parseDouble(lexeme);
                return new CdMdxDoubleToken(begin, lexeme, number);
            }
        }
        catch (NumberFormatException ex) {
            return this.onScannerError(this.range(begin), CdMdxTokenKind.DOUBLE, CdMdxErrorCode.SCAN_INVALID_NUMBER, new Serializable[]{lexeme});
        }
        try {
            long number = Long.parseLong(lexeme);
            return new CdMdxLongToken(begin, lexeme, number);
        }
        catch (NumberFormatException ex) {
            return this.onScannerError(this.range(begin), CdMdxTokenKind.LONG, CdMdxErrorCode.SCAN_INVALID_NUMBER, new Serializable[]{lexeme});
        }
    }

    private void scanInt(StringBuilder sb, int cc) throws IOException {
        sb.append((char)cc);
        while ((cc = this.read()) != -1) {
            if (CdMdxScanner.isDigit(cc)) {
                sb.append((char)cc);
                continue;
            }
            this.unread(cc);
            break;
        }
    }

    private void scanFrac(StringBuilder sb, int cc) throws IOException {
        sb.append((char)cc);
        while ((cc = this.read()) != -1) {
            if (CdMdxScanner.isDigit(cc)) {
                sb.append((char)cc);
                continue;
            }
            this.unread(cc);
            break;
        }
    }

    private static boolean isExpStart(int cc) {
        return cc == 101 || cc == 69;
    }

    private void scanExp(StringBuilder sb, int cc) throws IOException {
        sb.append((char)cc);
        boolean hasAppended = false;
        while ((cc = this.read()) != -1) {
            if (cc == 45 || cc == 43) {
                if (!hasAppended) {
                    sb.append((char)cc);
                    hasAppended = true;
                    continue;
                }
                this.unread(cc);
                break;
            }
            if (CdMdxScanner.isDigit(cc)) {
                sb.append((char)cc);
                hasAppended = true;
                continue;
            }
            this.unread(cc);
            break;
        }
    }

    private static boolean isSingleQuoteStringStart(int cc) {
        return cc == 39;
    }

    private static boolean isDoubleQuoteStringStart(int cc) {
        return cc == 34;
    }

    private CdMdxToken scanSingleQuotedString(int cc) throws IOException, CdMdxScannerException {
        String lexeme;
        CdMdxTokenLocation begin = this.where();
        StringBuilder lexemeSB = new StringBuilder();
        StringBuilder valueSB = new StringBuilder();
        lexemeSB.append((char)cc);
        while ((cc = this.read()) != -1) {
            lexemeSB.append((char)cc);
            if (cc == 39) {
                int lookahead = this.read();
                if (lookahead == 39) {
                    lexemeSB.append((char)lookahead);
                    valueSB.append((char)cc);
                    continue;
                }
                this.unread(lookahead);
                break;
            }
            valueSB.append((char)cc);
        }
        if ((lexeme = lexemeSB.toString()).charAt(lexeme.length() - 1) != '\'') {
            this.onScannerError(this.range(begin), CdMdxTokenKind.STRING, CdMdxErrorCode.SCAN_INVALID_SINGLE_STRING_END, new Serializable[]{lexeme});
        }
        String value = valueSB.toString();
        return new CdMdxStringToken(begin, lexeme, value);
    }

    private CdMdxToken scanDoubleQuotedString(int cc) throws IOException, CdMdxScannerException {
        String lexeme;
        CdMdxTokenLocation begin = this.where();
        StringBuilder lexemeSB = new StringBuilder();
        StringBuilder valueSB = new StringBuilder();
        lexemeSB.append((char)cc);
        while ((cc = this.read()) != -1) {
            lexemeSB.append((char)cc);
            if (cc == 34) {
                int lookahead = this.read();
                if (lookahead == 34) {
                    lexemeSB.append((char)lookahead);
                    valueSB.append((char)cc);
                    continue;
                }
                this.unread(lookahead);
                break;
            }
            valueSB.append((char)cc);
        }
        if ((lexeme = lexemeSB.toString()).charAt(lexeme.length() - 1) != '\"') {
            this.onScannerError(this.range(begin), CdMdxTokenKind.STRING, CdMdxErrorCode.SCAN_INVALID_DOUBLE_STRING_END, new Serializable[]{lexeme});
        }
        String value = valueSB.toString();
        return new CdMdxStringToken(begin, lexeme, value);
    }

    private CdMdxToken scanAmpDelimitedIdentifier(int cc) throws IOException, CdMdxScannerException {
        CdMdxTokenLocation begin = this.where();
        ArrayList<String> identifiers = new ArrayList<String>();
        do {
            String identifier;
            StringBuilder sb = new StringBuilder();
            sb.append((char)cc);
            cc = this.read();
            if (cc != 91) {
                this.onScannerError(this.range(begin), CdMdxTokenKind.AMP_DELIMITED_IDENTIFIER, CdMdxErrorCode.SCAN_INVALID_AMP_DELIMITED_ID_START, new Serializable[0]);
            }
            if (CdMdxScanner.isEndOfLineStart(cc)) {
                this.onScannerError(this.range(begin), CdMdxTokenKind.AMP_DELIMITED_IDENTIFIER, CdMdxErrorCode.SCAN_INVALID_AMP_DELIMITED_ID_END, new Serializable[]{sb.toString()});
            }
            sb.append((char)cc);
            while ((cc = this.read()) != -1) {
                if (cc == 93) {
                    sb.append((char)cc);
                    cc = this.read();
                    if (cc == 93) {
                        sb.append((char)cc);
                        continue;
                    }
                    this.unread(cc);
                    break;
                }
                sb.append((char)cc);
            }
            if ((identifier = sb.toString()).charAt(identifier.length() - 1) != ']') {
                this.onScannerError(this.range(begin), CdMdxTokenKind.AMP_DELIMITED_IDENTIFIER, CdMdxErrorCode.SCAN_INVALID_AMP_DELIMITED_ID_END, new Serializable[]{identifier});
            }
            identifiers.add(identifier);
        } while ((cc = this.read()) == 38);
        this.unread(cc);
        if (identifiers.size() == 1) {
            return new CdMdxAmpDelimitedSingleIdentifierToken(begin, (String)identifiers.get(0));
        }
        return new CdMdxAmpDelimitedCompositeIdentifierToken(begin, identifiers);
    }

    private CdMdxToken scanDelimitedIdentifier(int cc) throws IOException, CdMdxScannerException {
        String identifier;
        CdMdxTokenLocation begin = this.where();
        StringBuilder sb = new StringBuilder();
        sb.append((char)cc);
        while ((cc = this.read()) != -1) {
            if (CdMdxScanner.isEndOfLineStart(cc)) {
                this.onScannerError(this.range(begin), CdMdxTokenKind.DELIMITED_IDENTIFIER, CdMdxErrorCode.SCAN_INVALID_DELIMITED_ID_END, new Serializable[]{sb.toString()});
            }
            if (cc == 93) {
                sb.append((char)cc);
                cc = this.read();
                if (cc == 93) {
                    sb.append((char)cc);
                    continue;
                }
                this.unread(cc);
                break;
            }
            sb.append((char)cc);
        }
        if ((identifier = sb.toString()).charAt(identifier.length() - 1) != ']') {
            this.onScannerError(this.range(begin), CdMdxTokenKind.DELIMITED_IDENTIFIER, CdMdxErrorCode.SCAN_INVALID_DELIMITED_ID_END, new Serializable[]{identifier});
        }
        if (identifier.length() == 2 && !this.acceptSCAN_EMPTY_DELIMITED_ID) {
            this.onScannerError(this.range(begin), CdMdxTokenKind.DELIMITED_IDENTIFIER, CdMdxErrorCode.SCAN_EMPTY_DELIMITED_ID, new Serializable[]{identifier});
        }
        return new CdMdxDelimitedIdentifierToken(begin, identifier);
    }

    private static boolean isRegularIdentifierOrKeywordStart(int cc) {
        return Character.isJavaIdentifierStart(cc) || 8709 == cc;
    }

    private static boolean isRegularIdentifierOrKeywordPart(int cc) {
        return Character.isJavaIdentifierPart(cc) || cc == 33 || 8709 == cc;
    }

    private CdMdxToken scanRegularIdentifierOrKeyword(int cc) throws IOException {
        String identifier;
        CdMdxKeywordToken keyword;
        CdMdxTokenLocation begin = this.where();
        StringBuilder sb = new StringBuilder();
        sb.append((char)cc);
        while ((cc = this.read()) != -1) {
            if (CdMdxScanner.isRegularIdentifierOrKeywordPart(cc)) {
                sb.append((char)cc);
                continue;
            }
            this.unread(cc);
            break;
        }
        if ((keyword = CdMdxKeywordToken.createKeyword(begin, identifier = sb.toString())) != null) {
            return keyword;
        }
        if ("null".equalsIgnoreCase(identifier)) {
            return new CdMdxToken(begin, CdMdxTokenKind.NULL, identifier);
        }
        if ("true".equalsIgnoreCase(identifier)) {
            return new CdMdxToken(begin, CdMdxTokenKind.TRUE, identifier);
        }
        if ("false".equalsIgnoreCase(identifier)) {
            return new CdMdxToken(begin, CdMdxTokenKind.FALSE, identifier);
        }
        if (CdMdxTokenKind.DIMENSION.name().equalsIgnoreCase(identifier)) {
            return new CdMdxToken(begin, CdMdxTokenKind.DIMENSION, identifier);
        }
        if (CdMdxTokenKind.PROPERTIES.name().equalsIgnoreCase(identifier)) {
            return new CdMdxToken(begin, CdMdxTokenKind.PROPERTIES, identifier);
        }
        return new CdMdxRegularIdentifierToken(begin, identifier);
    }

    @Nullable
    private CdMdxToken scanOperatorOrSeparator(int cc) throws IOException {
        CdMdxTokenLocation begin = this.where();
        CdMdxToken token = null;
        switch (cc) {
            case 46: {
                token = new CdMdxToken(begin, CdMdxTokenKind.DOT, ".");
                break;
            }
            case 44: {
                token = new CdMdxToken(begin, CdMdxTokenKind.COMMA, ",");
                break;
            }
            case 59: {
                token = new CdMdxToken(begin, CdMdxTokenKind.SEMI_COLON, ";");
                break;
            }
            case 43: {
                token = new CdMdxToken(begin, CdMdxTokenKind.PLUS, "+");
                break;
            }
            case 45: {
                cc = this.read();
                if (cc == 62) {
                    token = new CdMdxToken(begin, CdMdxTokenKind.OBJ_MC, "->");
                    break;
                }
                if (cc == 45) {
                    this.unread(cc);
                    break;
                }
                this.unread(cc);
                token = new CdMdxToken(begin, CdMdxTokenKind.MINUS, "-");
                break;
            }
            case 47: {
                cc = this.read();
                if (cc == 47) {
                    this.unread(cc);
                    break;
                }
                if (cc == 42) {
                    this.unread(cc);
                    break;
                }
                this.unread(cc);
                token = new CdMdxToken(begin, CdMdxTokenKind.DIVIDE, "/");
                break;
            }
            case 42: {
                token = new CdMdxToken(begin, CdMdxTokenKind.MULTIPLY, "*");
                break;
            }
            case 94: {
                token = new CdMdxToken(begin, CdMdxTokenKind.POWER, "^");
                break;
            }
            case 58: {
                token = new CdMdxToken(begin, CdMdxTokenKind.RANGE, ":");
                break;
            }
            case 123: {
                token = new CdMdxToken(begin, CdMdxTokenKind.OPEN_CURLY_BRACE, "{");
                break;
            }
            case 125: {
                token = new CdMdxToken(begin, CdMdxTokenKind.CLOSE_CURLY_BRACE, "}");
                break;
            }
            case 40: {
                token = new CdMdxToken(begin, CdMdxTokenKind.OPEN_PAREN, "(");
                break;
            }
            case 41: {
                token = new CdMdxToken(begin, CdMdxTokenKind.CLOSE_PAREN, ")");
                break;
            }
            case 33: {
                cc = this.read();
                if (cc == 61) {
                    token = new CdMdxToken(begin, CdMdxTokenKind.NEQEQ, "!=");
                    break;
                }
                this.unread(cc);
                break;
            }
            case 61: {
                cc = this.read();
                if (cc == 61) {
                    token = new CdMdxToken(begin, CdMdxTokenKind.EQEQ, "==");
                    break;
                }
                this.unread(cc);
                token = new CdMdxToken(begin, CdMdxTokenKind.EQ, "=");
                break;
            }
            case 62: {
                cc = this.read();
                if (cc == 62) {
                    cc = this.read();
                    if (cc == 61) {
                        token = new CdMdxToken(begin, CdMdxTokenKind.GGE, ">>=");
                        break;
                    }
                    this.unread(cc);
                    token = new CdMdxToken(begin, CdMdxTokenKind.GGT, ">>");
                    break;
                }
                if (cc == 61) {
                    token = new CdMdxToken(begin, CdMdxTokenKind.GE, ">=");
                    break;
                }
                this.unread(cc);
                token = new CdMdxToken(begin, CdMdxTokenKind.GT, ">");
                break;
            }
            case 60: {
                cc = this.read();
                if (cc == 60) {
                    cc = this.read();
                    if (cc == 61) {
                        token = new CdMdxToken(begin, CdMdxTokenKind.LLE, "<<=");
                        break;
                    }
                    this.unread(cc);
                    token = new CdMdxToken(begin, CdMdxTokenKind.LLT, "<<");
                    break;
                }
                if (cc == 61) {
                    token = new CdMdxToken(begin, CdMdxTokenKind.LE, "<=");
                    break;
                }
                if (cc == 62) {
                    token = new CdMdxToken(begin, CdMdxTokenKind.NE, "<>");
                    break;
                }
                this.unread(cc);
                token = new CdMdxToken(begin, CdMdxTokenKind.LT, "<");
            }
        }
        return token;
    }

    private CdMdxToken scanEndOfLine(int cc) throws IOException, CdMdxScannerException {
        CdMdxTokenLocation begin = this.where();
        StringBuilder sb = new StringBuilder();
        sb.append((char)cc);
        if (cc == 13) {
            cc = this.read();
            if (cc == 10) {
                sb.append((char)cc);
            } else {
                this.unread(cc);
            }
        } else if (cc != 10) {
            this.onScannerError(this.range(begin), CdMdxTokenKind.EOL, CdMdxErrorCode.SCAN_INVALID_EOL, new Serializable[0]);
        }
        String lexeme = sb.toString();
        ++this.lineNumber;
        return new CdMdxToken(begin, CdMdxTokenKind.EOL, lexeme);
    }

    private CdMdxToken scanWhiteSpace(int cc) throws IOException {
        CdMdxTokenLocation begin = this.where();
        StringBuilder sb = new StringBuilder();
        sb.append((char)cc);
        while (CdMdxScanner.isWhiteSpace(cc = this.read()) && cc != 13 && cc != 10) {
            sb.append((char)cc);
        }
        this.unread(cc);
        String lexeme = sb.toString();
        return new CdMdxToken(begin, CdMdxTokenKind.WHITE_SPACES, lexeme);
    }

    private CdMdxToken scanComments(int cc) throws IOException, CdMdxScannerException {
        CdMdxTokenLocation begin = this.where();
        StringBuilder sb = new StringBuilder();
        sb.append((char)cc);
        if (cc == 45) {
            cc = this.read();
            if (cc == 45) {
                sb.append((char)cc);
                return this.scanSingleLineComment(begin, sb);
            }
        } else if (cc == 47) {
            cc = this.read();
            sb.append((char)cc);
            if (cc == 47) {
                cc = this.read();
                if (cc == 35) {
                    return this.scanAnnotation(begin, cc);
                }
                this.unread(cc);
                return this.scanSingleLineComment(begin, sb);
            }
            if (cc == 42) {
                return this.scanMultiLineComment(begin, sb);
            }
        }
        return this.onScannerError(this.range(begin), CdMdxTokenKind.COMMENT, CdMdxErrorCode.SCAN_INVALID_COMMENT_START, Character.valueOf((char)cc));
    }

    private CdMdxToken scanSingleLineComment(CdMdxTokenLocation begin, StringBuilder sb) throws IOException {
        int cc;
        while ((cc = this.read()) != -1) {
            if (CdMdxScanner.isEndOfLineStart(cc)) {
                this.unread(cc);
                break;
            }
            sb.append((char)cc);
        }
        String lexeme = sb.toString();
        return new CdMdxToken(begin, CdMdxTokenKind.COMMENT, lexeme);
    }

    private CdMdxToken scanMultiLineComment(CdMdxTokenLocation begin, StringBuilder sb) throws IOException, CdMdxScannerException {
        int cc;
        int openedCount = 1;
        while ((cc = this.read()) != -1) {
            sb.append((char)cc);
            if (cc == 42) {
                cc = this.read();
                if (cc == -1) break;
                sb.append((char)cc);
                if (cc != 47 || --openedCount != 0) continue;
                break;
            }
            if (cc != 47) continue;
            cc = this.read();
            if (cc == -1) break;
            sb.append((char)cc);
            if (cc != 42) continue;
            ++openedCount;
        }
        if (openedCount > 0) {
            this.onScannerError(this.range(begin), CdMdxTokenKind.COMMENT, CdMdxErrorCode.SCAN_INVALID_MULTI_LINE_COMMENT_END, new Serializable[0]);
        }
        String lexeme = sb.toString();
        return new CdMdxToken(begin, CdMdxTokenKind.COMMENT, lexeme);
    }

    private void assertLocationConsistency(String mdx, String mdxHash, List<CdMdxToken> tokens) throws CdMdxScannerException {
        char[] mdxChars = mdx.toCharArray();
        for (CdMdxToken token : tokens) {
            int offset = token.getLocation().offset();
            char mdxChar = mdxChars[offset - this.offsetOffset];
            char tokenFirstChar = token.getLexeme().charAt(0);
            if (tokenFirstChar == mdxChar) continue;
            this.onScannerError(new CdMdxTokenLocationRange(mdx, mdxHash, 0, 0, 1), null, CdMdxErrorCode.SCAN_INCONSISTENCY_ERROR, new Serializable[]{token.getLexeme()});
        }
    }

    private CdMdxToken onScannerError(CdMdxTokenLocationRange location, @Nullable CdMdxTokenKind tokenKind, CdMdxErrorCode errorCode, Serializable ... params) throws CdMdxScannerException {
        CdMdxError error = new CdMdxError(location, errorCode, params);
        throw new CdMdxScannerException(tokenKind, this.offset, error);
    }
}

