/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.mdx;

public abstract class CdMdxColorUtils {
    public static int rgb(int r, int g, int b) {
        int rgb = r + (g << 8) + (b << 16);
        return rgb;
    }

    public static int hsv(double hue, double saturation, double value) {
        int[] rgb = CdMdxColorUtils.HSBtoRGB(hue, saturation, value);
        return CdMdxColorUtils.rgb(rgb[0], rgb[1], rgb[2]);
    }

    public static int hsl(double h, double s, double l) {
        double b_;
        double g_;
        double r_;
        double c = (1.0 - Math.abs(2.0 * l - 1.0)) * s;
        double h_ = h / 60.0;
        double h_mod2 = h_;
        if (h_mod2 >= 4.0) {
            h_mod2 -= 4.0;
        } else if (h_mod2 >= 2.0) {
            h_mod2 -= 2.0;
        }
        double x = c * (1.0 - Math.abs(h_mod2 - 1.0));
        if (h_ < 1.0) {
            r_ = c;
            g_ = x;
            b_ = 0.0;
        } else if (h_ < 2.0) {
            r_ = x;
            g_ = c;
            b_ = 0.0;
        } else if (h_ < 3.0) {
            r_ = 0.0;
            g_ = c;
            b_ = x;
        } else if (h_ < 4.0) {
            r_ = 0.0;
            g_ = x;
            b_ = c;
        } else if (h_ < 5.0) {
            r_ = x;
            g_ = 0.0;
            b_ = c;
        } else {
            r_ = c;
            g_ = 0.0;
            b_ = x;
        }
        double m = l - 0.5 * c;
        int r = (int)((r_ + m) * 255.0 + 0.5);
        int g = (int)((g_ + m) * 255.0 + 0.5);
        int b = (int)((b_ + m) * 255.0 + 0.5);
        return CdMdxColorUtils.rgb(r, g, b);
    }

    public static String hexValue(int rgb) {
        int r = rgb & 0xFF;
        int g = (rgb & 0xFF00) >> 8;
        int b = (rgb & 0xFF0000) >> 16;
        return String.format("#%02X%02X%02X", r, g, b);
    }

    public static int rgb(String rgb) {
        String rs = rgb.substring(1, 3);
        int r = Integer.parseInt(rs, 16);
        String gs = rgb.substring(3, 5);
        int g = Integer.parseInt(gs, 16);
        String bs = rgb.substring(5, 7);
        int b = Integer.parseInt(bs, 16);
        return CdMdxColorUtils.rgb(r, g, b);
    }

    public static RGB rgbValues(int rgb) {
        int r = rgb & 0xFF;
        int g = (rgb & 0xFF00) >> 8;
        int b = (rgb & 0xFF0000) >> 16;
        return new RGB(r, g, b);
    }

    public static byte[] rgbValuesX(int rgb) {
        int r = rgb & 0xFF;
        int g = (rgb & 0xFF00) >> 8;
        int b = (rgb & 0xFF0000) >> 16;
        return new byte[]{(byte)r, (byte)g, (byte)b};
    }

    public static double[] hsvValues(int rgb) {
        int r = rgb & 0xFF;
        int g = (rgb & 0xFF00) >> 8;
        int b = (rgb & 0xFF0000) >> 16;
        return CdMdxColorUtils.RGBtoHSB(r, g, b);
    }

    public static int interpolateHSV(int rgbColor1, int rgbColor2, double interpolationPoint) {
        if (interpolationPoint <= 0.0) {
            return rgbColor1;
        }
        if (interpolationPoint >= 1.0) {
            return rgbColor2;
        }
        double[] hsv1 = CdMdxColorUtils.hsvValues(rgbColor1);
        double[] hsv2 = CdMdxColorUtils.hsvValues(rgbColor2);
        double h = hsv1[0] + interpolationPoint * (hsv2[0] - hsv1[0]);
        double s = hsv1[1] + interpolationPoint * (hsv2[1] - hsv1[1]);
        double v = hsv1[2] + interpolationPoint * (hsv2[2] - hsv1[2]);
        return CdMdxColorUtils.hsv(h, s, v);
    }

    public static int interpolateRGB(int rgbColor1, int rgbColor2, double interpolationPoint) {
        if (interpolationPoint <= 0.0) {
            return rgbColor1;
        }
        if (interpolationPoint >= 1.0) {
            return rgbColor2;
        }
        RGB rgb1 = CdMdxColorUtils.rgbValues(rgbColor1);
        RGB rgb2 = CdMdxColorUtils.rgbValues(rgbColor2);
        int r = (int)((double)rgb1.r + interpolationPoint * (double)(rgb2.r - rgb1.r));
        int g = (int)((double)rgb1.g + interpolationPoint * (double)(rgb2.g - rgb1.g));
        int b = (int)((double)rgb1.b + interpolationPoint * (double)(rgb2.b - rgb1.b));
        return CdMdxColorUtils.rgb(r, g, b);
    }

    static int[] HSBtoRGB(double hue, double saturation, double brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0) {
            g = b = (int)(brightness * 255.0 + 0.5);
            r = b;
        } else {
            double h = (hue - Math.floor(hue)) * 6.0;
            double f = h - Math.floor(h);
            double p = brightness * (1.0 - saturation);
            double q = brightness * (1.0 - saturation * f);
            double t = brightness * (1.0 - saturation * (1.0 - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0 + 0.5);
                    g = (int)(t * 255.0 + 0.5);
                    b = (int)(p * 255.0 + 0.5);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0 + 0.5);
                    g = (int)(brightness * 255.0 + 0.5);
                    b = (int)(p * 255.0 + 0.5);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0 + 0.5);
                    g = (int)(brightness * 255.0 + 0.5);
                    b = (int)(t * 255.0 + 0.5);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0 + 0.5);
                    g = (int)(q * 255.0 + 0.5);
                    b = (int)(brightness * 255.0 + 0.5);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0 + 0.5);
                    g = (int)(p * 255.0 + 0.5);
                    b = (int)(brightness * 255.0 + 0.5);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0 + 0.5);
                    g = (int)(p * 255.0 + 0.5);
                    b = (int)(q * 255.0 + 0.5);
                }
            }
        }
        return new int[]{r, g, b};
    }

    static double[] RGBtoHSB(int r, int g, int b) {
        double hue;
        int cmin;
        int cmax;
        int n = cmax = r > g ? r : g;
        if (b > cmax) {
            cmax = b;
        }
        int n2 = cmin = r < g ? r : g;
        if (b < cmin) {
            cmin = b;
        }
        double brightness = (double)cmax / 255.0;
        double saturation = cmax != 0 ? (double)(cmax - cmin) / (double)cmax : 0.0;
        if (saturation == 0.0) {
            hue = 0.0;
        } else {
            double redc = (double)(cmax - r) / (double)(cmax - cmin);
            double greenc = (double)(cmax - g) / (double)(cmax - cmin);
            double bluec = (double)(cmax - b) / (double)(cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0 + redc - bluec : 4.0 + greenc - redc);
            if ((hue /= 6.0) < 0.0) {
                hue += 1.0;
            }
        }
        return new double[]{hue, saturation, brightness};
    }

    public static class RGB {
        public final int r;
        public final int g;
        public final int b;

        public RGB(int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }
    }
}

