/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.math;

import crazydev.common.collection.CdArrays;
import crazydev.common.math.CdIMatrix;
import java.util.Arrays;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.apache.commons.math3.util.Precision;
import org.jetbrains.annotations.Nullable;

public class CdFullMatrix
implements CdIMatrix {
    private final double[][] values;

    public CdFullMatrix(double[][] values) {
        this.values = values;
    }

    public CdFullMatrix(int rowDim, int colDim) {
        this.values = new double[rowDim][colDim];
    }

    public CdFullMatrix(double[] values, int cols) {
        if (values.length % cols != 0) {
            throw new RuntimeException("Not a n*m matrix ( m = " + cols + ", length " + values.length + " )");
        }
        int rows = values.length / cols;
        this.values = new double[rows][cols];
        int i = 0;
        int pos = 0;
        while (i < this.values.length) {
            System.arraycopy(values, pos, this.values[i], 0, cols);
            ++i;
            pos += cols;
        }
    }

    @Override
    public Object toTidyTableValue() {
        return this.values;
    }

    @Override
    public String asString() {
        return CdArrays.toString(this.values);
    }

    @Override
    public String asString(int maxSize) {
        return CdArrays.toString(this.values, maxSize);
    }

    @Override
    public int getColDimension() {
        return this.values[0].length;
    }

    @Override
    public int getRowDimension() {
        return this.values.length;
    }

    @Override
    public double getValue(int row, int col) {
        return this.values[row][col];
    }

    @Override
    public CdIMatrix sum(double value) {
        double[][] newValues = CdArrays.copy(this.values);
        for (int row = 0; row < newValues.length; ++row) {
            double[] colArray = newValues[row];
            int col = 0;
            while (col < colArray.length) {
                int n = col++;
                colArray[n] = colArray[n] + value;
            }
        }
        return new CdFullMatrix(newValues);
    }

    @Override
    public CdIMatrix multiply(double value) {
        double[][] newValues = CdArrays.copy(this.values);
        for (int row = 0; row < newValues.length; ++row) {
            double[] colArray = newValues[row];
            int col = 0;
            while (col < colArray.length) {
                int n = col++;
                colArray[n] = colArray[n] * value;
            }
        }
        return new CdFullMatrix(newValues);
    }

    @Override
    public CdIMatrix sum(CdIMatrix matrix) {
        double[][] newValues = CdArrays.copy(this.values);
        for (int row = 0; row < newValues.length; ++row) {
            double[] colArray = newValues[row];
            for (int col = 0; col < colArray.length; ++col) {
                int n = col;
                colArray[n] = colArray[n] + matrix.getSafe(row, col);
            }
        }
        return new CdFullMatrix(newValues);
    }

    @Override
    public CdIMatrix minus(CdIMatrix matrix) {
        double[][] newValues = CdArrays.copy(this.values);
        for (int row = 0; row < newValues.length; ++row) {
            double[] colArray = newValues[row];
            for (int col = 0; col < colArray.length; ++col) {
                int n = col;
                colArray[n] = colArray[n] - matrix.getSafe(row, col);
            }
        }
        return new CdFullMatrix(newValues);
    }

    @Override
    public CdIMatrix multiply(CdIMatrix matrix) {
        int rowDimension = this.getRowDimension();
        int colDimension = this.getColDimension();
        int matrixColDimension = matrix.getColDimension();
        int matrixRowDimension = matrix.getRowDimension();
        if (matrixRowDimension != colDimension) {
            throw new RuntimeException("Matrix can not be multiplied");
        }
        double[][] newValues = new double[rowDimension][matrixColDimension];
        for (int row = 0; row < rowDimension; ++row) {
            newValues[row] = new double[matrixColDimension];
            double[] newCols = newValues[row];
            for (int col = 0; col < matrixColDimension; ++col) {
                double cellValue = 0.0;
                for (int k = 0; k < colDimension; ++k) {
                    cellValue += this.getSafe(row, k) * matrix.getSafe(k, col);
                }
                newCols[col] = cellValue;
            }
        }
        return new CdFullMatrix(newValues);
    }

    @Override
    public double[] multiply(double[] vector) {
        double[] newVector = new double[this.getRowDimension()];
        for (int row = 0; row < newVector.length; ++row) {
            double[] colArray = this.values[row];
            double value = 0.0;
            for (int col = 0; col < colArray.length; ++col) {
                value += colArray[col] * (col < vector.length ? vector[col] : 0.0);
            }
            newVector[row] = value;
        }
        return newVector;
    }

    @Override
    public double[] toFlatArray() {
        int colDimension = this.getColDimension();
        double[] newVector = new double[this.getRowDimension() * colDimension];
        for (int row = 0; row < this.values.length; ++row) {
            double[] value = this.values[row];
            System.arraycopy(value, 0, newVector, row * colDimension, this.values.length);
        }
        return newVector;
    }

    @Override
    public CdIMatrix transpose() {
        return new CdFullMatrix(CdFullMatrix.transpose(this.values));
    }

    @Override
    @Nullable
    public CdIMatrix inverse() {
        Array2DRowRealMatrix commonMatrix = new Array2DRowRealMatrix(this.values, false);
        RealMatrix inverseMatrix = new LUDecomposition((RealMatrix)commonMatrix).getSolver().getInverse();
        return new CdFullMatrix(inverseMatrix.getData());
    }

    @Override
    @Nullable
    public double[] solve(double[] vector) {
        Array2DRowRealMatrix commonMatrix = new Array2DRowRealMatrix(this.values, false);
        RealVector solution = new LUDecomposition((RealMatrix)commonMatrix).getSolver().solve((RealVector)new ArrayRealVector(vector, false));
        return solution.toArray();
    }

    @Override
    public boolean same(CdIMatrix other) {
        return this.equals(other);
    }

    @Override
    public void eval(AbstractStorelessUnivariateStatistic stats) {
        for (int row = 0; row < this.values.length; ++row) {
            double[] colArray = this.values[row];
            for (int col = 0; col < colArray.length; ++col) {
                stats.increment(colArray[col]);
            }
        }
    }

    @Override
    public CdIMatrix round(int precision) {
        double[][] newValues = CdArrays.copy(this.values);
        for (int row = 0; row < newValues.length; ++row) {
            double[] colArray = newValues[row];
            for (int col = 0; col < colArray.length; ++col) {
                colArray[col] = Precision.round((double)colArray[col], (int)precision) + 0.0;
            }
        }
        return new CdFullMatrix(newValues);
    }

    @Override
    public CdIMatrix allZero() {
        double[][] newValues = new double[this.values.length][];
        int colDimension = this.getColDimension();
        for (int row = 0; row < newValues.length; ++row) {
            double[] colArray = new double[colDimension];
            newValues[row] = colArray;
            for (int col = 0; col < colArray.length; ++col) {
                colArray[col] = 0.0;
            }
        }
        return new CdFullMatrix(newValues);
    }

    @Override
    public boolean isZero() {
        for (int row = 0; row < this.values.length; ++row) {
            double[] colArray = this.values[row];
            for (int col = 0; col < colArray.length; ++col) {
                if (colArray[col] == 0.0) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void setValue(int row, int col, double value) {
        this.values[row][col] = value;
    }

    public boolean equals(Object other) {
        if (other instanceof CdFullMatrix) {
            CdFullMatrix otherMatrix = (CdFullMatrix)other;
            return CdArrays.equals(this.values, otherMatrix.values);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.deepHashCode((Object[])this.values);
    }

    static double[][] transpose(double[][] matrix) {
        if (matrix.length == 0) {
            return matrix;
        }
        int rows = matrix.length;
        int cols = matrix[0].length;
        double[][] transposed = new double[cols][rows];
        for (int j = 0; j < cols; ++j) {
            double[] transposedLine = transposed[j];
            for (int i = 0; i < rows; ++i) {
                transposedLine[i] = matrix[i][j];
            }
        }
        return transposed;
    }
}

