/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.lz4;

public abstract class CdLz4 {
    public static byte[] decompress(byte[] src, int decompressedLen) {
        byte[] dest = new byte[decompressedLen];
        int srcIdx = 0;
        int destIdx = 0;
        while (srcIdx < src.length) {
            int match_offset;
            int token;
            int literals_length;
            if ((literals_length = (token = src[srcIdx++] & 0xFF) >> 4) > 0) {
                int ll = literals_length + 240;
                while (ll == 255) {
                    ll = src[srcIdx++] & 0xFF;
                    literals_length += ll;
                }
                int end = srcIdx + literals_length;
                while (srcIdx < end) {
                    dest[destIdx++] = src[srcIdx++];
                }
                if (srcIdx == src.length) {
                    return dest;
                }
            }
            if ((match_offset = src[srcIdx++] & 0xFF | (src[srcIdx++] & 0xFF) << 8) == 0) {
                throw new RuntimeException("internal error: LZ4 decompression (match_offset) (0)");
            }
            if (match_offset > destIdx) {
                throw new RuntimeException("internal error: LZ4 decompression (match_offset > destIdx) (" + match_offset + ">" + destIdx + ")");
            }
            int match_length = token & 0xF;
            int ll = match_length + 240;
            while (ll == 255) {
                ll = src[srcIdx++] & 0xFF;
                match_length += ll;
            }
            int pos = destIdx - match_offset;
            int end = destIdx + match_length + 4;
            while (destIdx < end) {
                dest[destIdx++] = dest[pos++];
            }
        }
        return dest;
    }
}

