/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.locale;

import crazydev.common.locale.CdLanguageIdentifier;
import crazydev.common.utils.CdResourceUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class CdLanguageIdentifierHelper {
    public static final Logger LOGGER = Logger.getLogger((String)"icCube.general");
    private static final Map<CdLanguageIdentifier, Locale> allLocales = new HashMap<CdLanguageIdentifier, Locale>();
    private static final Map<String, CdLanguageIdentifier> allIdentifiers = new HashMap<String, CdLanguageIdentifier>();
    private static final Map<String, Locale> allLocalesPerPreferredLanguage = new HashMap<String, Locale>();
    private static final Map<String, Locale> allLocalesPerUsageLocation = new HashMap<String, Locale>();
    private static final Set<CdLanguageIdentifier> invalidIdentifiers = new HashSet<CdLanguageIdentifier>();
    private static boolean initialized = false;

    public static synchronized void setup() {
        CdLanguageIdentifier[] identifiers;
        if (initialized) {
            return;
        }
        initialized = true;
        HashMap<String, Locale> availableLocales = new HashMap<String, Locale>();
        HashMap<String, Locale> availableLocalesByCountries = new HashMap<String, Locale>();
        for (Locale availableLocale : Locale.getAvailableLocales()) {
            String key = availableLocale.toString();
            availableLocales.put(key, availableLocale);
            availableLocalesByCountries.put(availableLocale.getCountry(), availableLocale);
        }
        for (CdLanguageIdentifier identifier : identifiers = (CdLanguageIdentifier[])CdLanguageIdentifier.class.getEnumConstants()) {
            Locale cLocale;
            String countryCode;
            if (identifier == CdLanguageIdentifier.Neutral || identifier == CdLanguageIdentifier.UserDefault || identifier == CdLanguageIdentifier.SystemDefault) continue;
            String languageCode = identifier.getLanguageCode();
            Locale locale = (Locale)availableLocales.get(languageCode + "_" + (countryCode = identifier.getCountryCode()));
            if (locale == null && (locale = (Locale)availableLocalesByCountries.get(countryCode)) == null) {
                locale = (Locale)availableLocales.get(languageCode);
            }
            if (locale != null) {
                allLocales.put(identifier, locale);
                allIdentifiers.put("" + identifier.getPosition(), identifier);
                allIdentifiers.put(locale.toString(), identifier);
                allLocalesPerPreferredLanguage.put(languageCode + "-" + countryCode, locale);
            }
            if ((cLocale = (Locale)availableLocalesByCountries.get(countryCode)) != null) {
                allLocalesPerUsageLocation.put(countryCode, cLocale);
            }
            if (locale != null) continue;
            LOGGER.warn((Object)("Language identifier not supported :" + String.valueOf(identifier)));
            invalidIdentifiers.add(identifier);
        }
    }

    public static boolean isInvalid(CdLanguageIdentifier id) {
        return invalidIdentifiers.contains(id);
    }

    @Nullable
    public static Locale toJavaLocale(Locale olapEngineLocale, CdLanguageIdentifier id) {
        if (id == CdLanguageIdentifier.Neutral || id == CdLanguageIdentifier.UserDefault) {
            return null;
        }
        if (id == CdLanguageIdentifier.SystemDefault) {
            return olapEngineLocale;
        }
        Locale locale = CdLanguageIdentifierHelper.getJavaLocale(id);
        if (locale != null) {
            return locale;
        }
        return null;
    }

    @Nullable
    public static Locale getJavaLocale(CdLanguageIdentifier id) {
        return allLocales.get(id);
    }

    @Nullable
    public static String getJavaLocaleName(CdLanguageIdentifier id) {
        Locale locale = allLocales.get(id);
        if (locale != null) {
            return locale.toString();
        }
        return null;
    }

    @Nullable
    public static CdLanguageIdentifier getIdentifier(String idOrJavaLocaleName) {
        CdLanguageIdentifier id = allIdentifiers.get(idOrJavaLocaleName);
        return id;
    }

    @Nullable
    public static Locale getLocaleByPreferredLanguage(String preferredLanguage) {
        Locale locale = allLocalesPerPreferredLanguage.get(preferredLanguage);
        return locale;
    }

    public static Locale getLocaleByUsageLocation(String usageLocation) {
        Locale locale = allLocalesPerUsageLocation.get(usageLocation);
        return locale;
    }

    public static void main(String[] args) throws IOException {
        List<LanguageIdentifier> identifiers = CdLanguageIdentifierHelper.parse();
        CdLanguageIdentifierHelper.generatedCdLanguageIdentifierEnum(identifiers);
    }

    public static List<LanguageIdentifier> parse() throws IOException {
        String line;
        ArrayList<LanguageIdentifier> identifiers = new ArrayList<LanguageIdentifier>();
        InputStream in = CdResourceUtils.getResourceAsStream(CdLanguageIdentifierHelper.class, "CdLanguageIdentifier.csv");
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF8"));
        String[] previousParts = null;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("#")) continue;
            String[] parts = line.split(";");
            if (parts.length != 7) {
                throw new RuntimeException("Ouch!");
            }
            for (int i = 0; i < parts.length; ++i) {
                parts[i] = parts[i].trim();
            }
            int code = CdLanguageIdentifierHelper.parseCode(previousParts, parts);
            String languageName = CdLanguageIdentifierHelper.parseLanguageName(previousParts, parts);
            String languageCode = CdLanguageIdentifierHelper.parseLanguageCode(previousParts, parts);
            String countryName = CdLanguageIdentifierHelper.parseCountryName(previousParts, parts);
            String countryCode = CdLanguageIdentifierHelper.parseCountryCode(previousParts, parts);
            identifiers.add(new LanguageIdentifier(code, languageName, languageCode, countryName, countryCode));
            previousParts = parts;
        }
        return identifiers;
    }

    private static String setupPart(String[] previousParts, String[] parts, int pos) {
        if (parts[pos].isEmpty()) {
            if (previousParts[pos] == null) {
                throw new RuntimeException("Ouch!");
            }
            parts[pos] = previousParts[pos];
        }
        return parts[pos];
    }

    private static int parseCode(String[] previousParts, String[] parts) {
        String part = CdLanguageIdentifierHelper.setupPart(previousParts, parts, 0);
        return Integer.parseInt(part.substring(2), 16);
    }

    private static String parseLanguageName(String[] previousParts, String[] parts) {
        String part = CdLanguageIdentifierHelper.setupPart(previousParts, parts, 1);
        int paren = part.indexOf("(");
        if (paren == -1) {
            throw new RuntimeException("Ouch!");
        }
        String name = part.substring(0, paren).trim();
        if (name.isEmpty()) {
            throw new RuntimeException("Ouch!");
        }
        return name;
    }

    private static String parseLanguageCode(String[] previousParts, String[] parts) {
        String part = CdLanguageIdentifierHelper.setupPart(previousParts, parts, 1);
        int openParen = part.indexOf("(");
        if (openParen == -1) {
            throw new RuntimeException("Ouch!");
        }
        int closeParen = part.indexOf(")");
        if (closeParen == -1) {
            throw new RuntimeException("Ouch!");
        }
        String code = part.substring(openParen + 1, closeParen).trim();
        if (code.isEmpty()) {
            throw new RuntimeException("Ouch!");
        }
        return code;
    }

    private static String parseCountryName(String[] previousParts, String[] parts) {
        String part = CdLanguageIdentifierHelper.setupPart(previousParts, parts, 4);
        int paren = part.indexOf("(");
        if (paren == -1) {
            throw new RuntimeException("Ouch!");
        }
        String name = part.substring(0, paren).trim();
        if (name.isEmpty()) {
            throw new RuntimeException("Ouch!");
        }
        return name;
    }

    private static String parseCountryCode(String[] previousParts, String[] parts) {
        String part = CdLanguageIdentifierHelper.setupPart(previousParts, parts, 4);
        int openParen = part.indexOf("(");
        if (openParen == -1) {
            throw new RuntimeException("Ouch!");
        }
        int closeParen = part.indexOf(")");
        if (closeParen == -1) {
            throw new RuntimeException("Ouch!");
        }
        String code = part.substring(openParen + 1, closeParen).trim();
        if (code.isEmpty()) {
            throw new RuntimeException("Ouch!");
        }
        return code;
    }

    private static void generatedCdLanguageIdentifierEnum(List<LanguageIdentifier> identifiers) {
        for (LanguageIdentifier identifier : identifiers) {
            System.out.println("@XmlEnumValue(\"" + identifier.code + "\")" + identifier.escapedLanguageName() + "_" + identifier.escapedCountryName() + "(" + identifier.code + ",\"" + identifier.languageCode + "\",\"" + identifier.countryCode + "\"),");
        }
    }

    static class LanguageIdentifier {
        final int code;
        final String languageName;
        final String languageCode;
        final String countryName;
        final String countryCode;

        public LanguageIdentifier(int code, String languageName, String languageCode, String countryName, String countryCode) {
            this.code = code;
            this.languageName = languageName;
            this.languageCode = languageCode;
            this.countryName = countryName;
            this.countryCode = countryCode;
        }

        String escapedLanguageName() {
            return this.languageName.replace(" ", "").replace(",", "").replace(".", "").replace("'", "");
        }

        String escapedCountryName() {
            return this.countryName.replace(" ", "").replace(",", "").replace(".", "").replace("'", "");
        }
    }
}

