/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.javacompiler;

import crazydev.common.javacompiler.CompilationException;
import crazydev.common.javacompiler.CompiledClass;
import crazydev.common.javacompiler.CompiledCode;
import crazydev.common.javacompiler.DynamicClassLoader;
import crazydev.common.javacompiler.ExtendedStandardJavaFileManager;
import crazydev.common.javacompiler.SourceCode;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.ToolProvider;
import org.jetbrains.annotations.Nullable;

public class InMemoryJavaCompiler {
    private static final boolean ignoreWarnings = true;
    private final JavaCompiler javac;
    private final DynamicClassLoader classLoader;
    private final List<String> options = new ArrayList<String>();

    private InMemoryJavaCompiler(int securityProfileId) {
        this.javac = ToolProvider.getSystemJavaCompiler();
        this.classLoader = new DynamicClassLoader(ClassLoader.getSystemClassLoader(), securityProfileId);
    }

    public static boolean hasJavaCompilerInstalled() {
        return ToolProvider.getSystemJavaCompiler() != null;
    }

    public static InMemoryJavaCompiler newDefaultInstance(int securityProfileId) {
        InMemoryJavaCompiler inst = new InMemoryJavaCompiler(securityProfileId);
        inst.options.add("-Xlint");
        return inst;
    }

    public InMemoryJavaCompiler addOptions(String ... options) {
        this.options.addAll(Arrays.asList(options));
        return this;
    }

    public CompiledCode compile(String className, String sourceCode) throws CompilationException {
        SourceCode code = new SourceCode(className, sourceCode);
        DiagnosticCollector<JavaFileObject> collector = new DiagnosticCollector<JavaFileObject>();
        ExtendedStandardJavaFileManager fileManager = new ExtendedStandardJavaFileManager(this.javac.getStandardFileManager(null, null, null));
        JavaCompiler.CompilationTask task = this.javac.getTask(null, fileManager, collector, this.options, null, Collections.singleton(code));
        this.checkError(collector, task);
        List<CompiledCodeFileObject> codeFileObjects = fileManager.getCompiledCode();
        ArrayList<CompiledClass> classes = new ArrayList<CompiledClass>();
        for (CompiledCodeFileObject codeFileObject : codeFileObjects) {
            classes.add(new CompiledClass(codeFileObject.className, codeFileObject.baos.toByteArray()));
        }
        return new CompiledCode(classes);
    }

    public CompiledCode compile(@Nullable DynamicClassLoader classpath, List<SourceCode> compilationUnits) throws CompilationException {
        DiagnosticCollector<JavaFileObject> collector = new DiagnosticCollector<JavaFileObject>();
        ExtendedStandardJavaFileManager fileManager = new ExtendedStandardJavaFileManager(classpath, this.javac.getStandardFileManager(null, null, null));
        JavaCompiler.CompilationTask task = this.javac.getTask(null, fileManager, collector, this.options, null, compilationUnits);
        this.checkError(collector, task);
        List<CompiledCodeFileObject> codeFileObjects = fileManager.getCompiledCode();
        ArrayList<CompiledClass> classes = new ArrayList<CompiledClass>();
        for (CompiledCodeFileObject codeFileObject : codeFileObjects) {
            classes.add(new CompiledClass(codeFileObject.className, codeFileObject.baos.toByteArray()));
        }
        return new CompiledCode(classes);
    }

    public void loadClasses(CompiledCode code) throws ClassNotFoundException {
        this.classLoader.addCode(code);
        List<CompiledClass> classes = code.getClasses();
        if (classes != null) {
            for (CompiledClass clazz : classes) {
                this.classLoader.loadClass(clazz.getClassName());
            }
        }
    }

    public Class<?> getClass(String name) {
        try {
            Class<?> clazz = Class.forName(name, true, this.classLoader);
            return clazz;
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("internal error: missing class [" + name + "]", ex);
        }
    }

    private void checkError(DiagnosticCollector<JavaFileObject> collector, JavaCompiler.CompilationTask task) throws CompilationException {
        boolean result = task.call();
        if (!result || !collector.getDiagnostics().isEmpty()) {
            ArrayList<CompilationException.Error> errors = new ArrayList<CompilationException.Error>();
            for (Diagnostic<JavaFileObject> d : collector.getDiagnostics()) {
                switch (d.getKind()) {
                    case MANDATORY_WARNING: 
                    case WARNING: {
                        break;
                    }
                    case OTHER: 
                    case ERROR: {
                        errors.add(new CompilationException.Error(d));
                        break;
                    }
                }
            }
            if (!errors.isEmpty()) {
                throw new CompilationException(errors);
            }
        }
    }

    public DynamicClassLoader getClassloader() {
        return this.classLoader;
    }

    static class CompiledCodeFileObject
    extends SimpleJavaFileObject {
        private final String className;
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();

        CompiledCodeFileObject(String className) throws Exception {
            super(new URI(className), JavaFileObject.Kind.CLASS);
            this.className = className;
        }

        @Override
        public OutputStream openOutputStream() {
            return this.baos;
        }
    }
}

