/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.javacompiler;

import crazydev.common.javacompiler.CompiledClass;
import crazydev.common.javacompiler.SourceCode;
import crazydev.common.utils.CdStringUtils;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="CompileCode")
public class CompiledCode {
    @XmlElement(name="sourceCodeHash", required=true)
    private String sourceCodeHash;
    @XmlElement(name="class", required=true)
    @Nullable
    private List<CompiledClass> classes;

    CompiledCode() {
    }

    public CompiledCode(List<CompiledClass> classes) {
        this.classes = classes;
    }

    public String getClassNames() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int ii = 0; ii < this.classes.size(); ++ii) {
            CompiledClass clazz = this.classes.get(ii);
            if (ii > 0) {
                sb.append(",");
            }
            sb.append(clazz.getClassName());
        }
        sb.append("]");
        return sb.toString();
    }

    public void setSourceCode(List<SourceCode> compilationUnits) {
        this.sourceCodeHash = CompiledCode.getHashCode(compilationUnits);
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCodeHash = CompiledCode.getHashCode(sourceCode);
    }

    @Nullable
    public List<CompiledClass> getClasses() {
        return this.classes;
    }

    public boolean checkSourceCode(List<SourceCode> compilationUnits) {
        String newHashCode = CompiledCode.getHashCode(compilationUnits);
        return this.sourceCodeHash.equals(newHashCode);
    }

    public boolean checkSourceCode(String newSourceCode) {
        String newHashCode = CompiledCode.getHashCode(newSourceCode);
        return this.sourceCodeHash.equals(newHashCode);
    }

    private static String getHashCode(List<SourceCode> compilationUnits) {
        StringBuilder sb = new StringBuilder();
        for (SourceCode compilationUnit : compilationUnits) {
            sb.append(compilationUnit.getCharContent(true));
        }
        return CdStringUtils.getSHA512Hash(sb.toString());
    }

    private static String getHashCode(String methodBody) {
        return CdStringUtils.getSHA512Hash(methodBody);
    }
}

