/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.fs.revision;

import crazydev.common.fs.CdVFileSystem;
import crazydev.common.fs.CdVFileSystemTmpReason;
import crazydev.common.fs.CdVFileSystemTunneledIOExceptionR;
import crazydev.common.fs.CdVFileSystemUtils;
import crazydev.common.fs.revision.CdVFileRev;
import crazydev.common.fs.revision.CdVFileRevAction;
import crazydev.common.fs.revision.CdVFileRevActionOperation;
import crazydev.common.fs.revision.CdVFileRevFolder;
import crazydev.common.fs.revision.CdVFileRevFolderInfoResolver;
import crazydev.common.fs.revision.CdVFileRevHelperConf;
import crazydev.common.fs.revision.CdVFileRevManagerKind;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public class CdVFileRevHelper {
    private static final String REVISIONS_SUFFIX = ".revs";
    private static final String REVISION_FILENAME_PATTERN = "^r(\\d+)\\.zip$";
    private static final String REVISION_PROPERTIES = "properties";
    private static final String REVISION_PAYLOAD = "payload";
    private static long MAX_AGE_MS = TimeUnit.MINUTES.toMillis(15L);
    private static int MAX_COUNT = 25;
    private final CdVFileSystem vfs;
    private final CdVFileRevManagerKind kind;
    private final File tmpDirectory;
    private final File repository;

    public CdVFileRevHelper(CdVFileSystem vfs, CdVFileRevHelperConf configuration) {
        this.vfs = vfs;
        this.kind = configuration.kind();
        this.tmpDirectory = configuration.tmpDirectory();
        this.repository = configuration.repository();
    }

    public static boolean isRevFolder(File file) {
        return file.isDirectory() && (file.getName().endsWith(REVISIONS_SUFFIX) || file.getName().endsWith(".rev"));
    }

    public CdVFileSystem getVfs() {
        return this.vfs;
    }

    public CdVFileRev getRevision(File to, String revFileName, boolean withPayload) throws IOException {
        if (!to.exists()) {
            throw new FileNotFoundException("missing file : " + to.getName());
        }
        try {
            File revFile = this.getRevisionFile(to, revFileName);
            if (revFile == null) {
                throw new FileNotFoundException("missing file : " + to.getName());
            }
            return this.unmarshallRevision(to, revFile, withPayload);
        }
        catch (IOException ex) {
            CdVFileSystem.LOGGER.error((Object)("[vfs] could not retrieve the " + String.valueOf((Object)this.kind) + " revision for : " + to.getPath()), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreRevision(String savedBy, File to, boolean assertExistingTo, String revFileName) throws IOException {
        if (assertExistingTo && !to.exists()) {
            throw new FileNotFoundException("missing file : " + to.getName());
        }
        CdVFileSystem vfs = this.getVfs();
        try {
            File revFile = this.getRevisionFile(to, revFileName);
            if (revFile == null) {
                throw new FileNotFoundException("missing file : " + to.getName());
            }
            CdVFileRev revision = this.unmarshallRevision(to, revFile, false);
            File restoredTmp = vfs.createTmpFile(CdVFileSystemTmpReason.REVISION, this.tmpDirectory);
            try {
                this.unmarshallRevisionContent(restoredTmp, revFile);
                String operation = "restored from rev. " + revFileName;
                String revBookmark = revision.getBookmark();
                if (revBookmark != null) {
                    operation = operation + " : " + revBookmark;
                }
                try (BufferedInputStream content = new BufferedInputStream(new FileInputStream(restoredTmp));){
                    this.saveOrUpdate(to, content, new CdVFileRevActionOperation(savedBy, operation));
                }
            }
            finally {
                vfs.delete(restoredTmp);
            }
        }
        catch (IOException ex) {
            CdVFileSystem.LOGGER.error((Object)("[vfs] could not restore the " + String.valueOf((Object)this.kind) + " revision [" + revFileName + "] for : " + to.getPath()), (Throwable)ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bookmarkRevision(File to, String revFileName, String bookmark) throws IOException {
        if (!to.exists()) {
            throw new FileNotFoundException("missing file : " + to.getName());
        }
        try {
            File revFile = this.getRevisionFile(to, revFileName);
            if (revFile == null) {
                throw new FileNotFoundException("missing file : " + to.getName());
            }
            File revFileTmp = this.vfs.createTmpFile(CdVFileSystemTmpReason.REVISION, this.tmpDirectory);
            try {
                Files.copy(revFile.toPath(), revFileTmp.toPath(), StandardCopyOption.REPLACE_EXISTING);
                CdVFileRev revision = this.unmarshallRevision(to, revFileTmp, false);
                try (FileSystem fs = FileSystems.newFileSystem(revFileTmp.toPath());){
                    String operationBy;
                    Properties properties = new Properties();
                    properties.put("bookmark", bookmark);
                    String operation = revision.getOperation();
                    if (operation != null) {
                        properties.put("operation", operation);
                    }
                    if ((operationBy = revision.getOperationBy()) != null) {
                        properties.put("operationBy", operationBy);
                    }
                    Path props = fs.getPath("/properties", new String[0]);
                    Path propsNEW = fs.getPath("/properties." + System.currentTimeMillis(), new String[0]);
                    try (OutputStream out = Files.newOutputStream(propsNEW, new OpenOption[0]);){
                        properties.store(out, null);
                    }
                    Files.move(propsNEW, props, StandardCopyOption.REPLACE_EXISTING);
                }
                try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(revFileTmp));){
                    this.vfs.saveFile(revFile, in);
                }
            }
            finally {
                CdVFileSystemUtils.deleteQuietly(revFileTmp);
            }
        }
        catch (IOException ex) {
            CdVFileSystem.LOGGER.error((Object)("[vfs] could not bookmark the " + String.valueOf((Object)this.kind) + " revision [" + revFileName + "] for : " + to.getPath()), (Throwable)ex);
            throw ex;
        }
    }

    public void forEachRevisions(File to, Consumer<CdVFileRev> consumer) {
        try {
            if (!to.exists()) {
                return;
            }
            File revDirectory = this.getRevisionDirectory(to);
            if (revDirectory != null) {
                this.vfs.forEachFile(revDirectory, entry -> entry.toFile().getName().endsWith(".zip"), vPath -> {
                    try {
                        CdVFileRev revision = this.unmarshallRevision(to, vPath.path.toFile(), false);
                        consumer.accept(revision);
                    }
                    catch (IOException ex) {
                        CdVFileSystem.LOGGER.error((Object)("[vfs] could not unmarshall the " + String.valueOf((Object)this.kind) + " revision for : " + vPath.path.toFile().getPath()), (Throwable)ex);
                    }
                });
            }
        }
        catch (IOException ex) {
            CdVFileSystem.LOGGER.error((Object)("[vfs] could not list the " + String.valueOf((Object)this.kind) + " revisions for : " + to.getPath()), (Throwable)ex);
        }
    }

    @Nullable
    public CdVFileRevFolder getRevDirectory(CdVFileRevFolderInfoResolver resolver, String relPath) {
        File directory = new File(this.repository, relPath);
        if (!directory.isDirectory() || !directory.getName().endsWith(REVISIONS_SUFFIX)) {
            return null;
        }
        String name = directory.getName();
        String info = this.unmarshallRevDirectoryInfo(resolver, directory);
        return new CdVFileRevFolder(relPath, name, info);
    }

    public void forEachRevDirectory(CdVFileRevFolderInfoResolver resolver, Consumer<CdVFileRevFolder> consumer) {
        try {
            this.vfs.forEachFileRecursive(this.repository, entry -> true, vPath -> {
                File directory = vPath.path.toFile();
                if (directory.isDirectory() && directory.getName().endsWith(REVISIONS_SUFFIX)) {
                    String info = this.unmarshallRevDirectoryInfo(resolver, directory);
                    File relPath = this.repository.toPath().relativize(directory.toPath()).toFile();
                    String name = directory.getName();
                    CdVFileRevFolder revDirectory = new CdVFileRevFolder(relPath.getPath(), name, info);
                    consumer.accept(revDirectory);
                }
            });
        }
        catch (IOException ex) {
            CdVFileSystem.LOGGER.error((Object)"[vfs] could not retrieve the rev. directories", (Throwable)ex);
        }
    }

    public File restoreRevDirectory(String savedBy, String relPath) throws IOException {
        File directory = new File(this.repository, relPath);
        if (!directory.isDirectory() || !directory.getName().endsWith(REVISIONS_SUFFIX)) {
            throw new IOException("unexpected/missing rev. directory : " + relPath);
        }
        File revFile = this.getLatestRevisionFileForRestoreRevDirectory(directory);
        if (revFile == null) {
            throw new IOException("no revision found in : " + relPath);
        }
        File toParent = directory.getParentFile();
        String toName = directory.getName().substring(0, directory.getName().length() - REVISIONS_SUFFIX.length());
        File to = new File(toParent, toName);
        this.restoreRevision(savedBy, to, false, revFile.getName());
        return to;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOrUpdate(File to, InputStream content, CdVFileRevAction action) throws IOException {
        CdVFileSystem vfs = this.getVfs();
        File toTmp = vfs.createTmpFile(CdVFileSystemTmpReason.REVISION, this.tmpDirectory);
        try {
            Files.copy(content, toTmp.toPath(), StandardCopyOption.REPLACE_EXISTING);
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(toTmp));){
                vfs.saveFile(to, in);
            }
            this.addNewRevision(to, toTmp, action);
        }
        finally {
            vfs.delete(toTmp);
        }
    }

    private void addNewRevision(File to, File content, CdVFileRevAction action) throws IOException {
        Properties properties = new Properties();
        if (action != null) {
            action.setupProperties(properties);
        }
        File newRevFile = this.vfs.createRevisionFile(to, REVISIONS_SUFFIX);
        try (FileInputStream in = new FileInputStream(content);
             ZipOutputStream out = new ZipOutputStream(new FileOutputStream(newRevFile));){
            out.putNextEntry(new ZipEntry(REVISION_PROPERTIES));
            properties.store(out, null);
            out.closeEntry();
            out.putNextEntry(new ZipEntry(REVISION_PAYLOAD));
            IOUtils.copy((InputStream)in, (OutputStream)out);
            out.closeEntry();
            out.finish();
        }
        catch (IOException ex) {
            CdVFileSystemUtils.deleteQuietly(newRevFile);
            throw ex;
        }
        this.autoCleanupRevisions(newRevFile.getParentFile());
    }

    private void autoCleanupRevisions(File revs) {
        long now = System.currentTimeMillis();
        ArrayList revisions = new ArrayList();
        try {
            this.vfs.forEachFile(revs, entry -> entry.toFile().getName().endsWith(".zip"), vPath -> {
                try {
                    CdVFileRev revision = this.unmarshallRevision(revs, vPath.path.toFile(), false);
                    if (!revision.hasBookmark()) {
                        revisions.add(revision);
                    }
                }
                catch (IOException ex) {
                    CdVFileSystem.LOGGER.error((Object)("[vfs] auto-cleanup: could not unmarshall the " + String.valueOf((Object)this.kind) + " revision for : " + vPath.path.toFile().getPath()), (Throwable)ex);
                }
            });
        }
        catch (IOException ex) {
            CdVFileSystem.LOGGER.error((Object)("[vfs] auto-cleanup: could not unmarshall the " + String.valueOf((Object)this.kind) + " revisions for : " + revs.getPath()), (Throwable)ex);
            return;
        }
        revisions.sort((o1, o2) -> -Long.compare(o1.getRevFileNameS_value(), o2.getRevFileNameS_value()));
        int keptCount = 0;
        for (CdVFileRev revision : revisions) {
            if (revision.hasBookmark()) continue;
            long creationTimestamp = revision.getAutoCleanupCreationTimestamp();
            long age = now - creationTimestamp;
            if (age <= MAX_AGE_MS) {
                ++keptCount;
                continue;
            }
            if (keptCount < MAX_COUNT) {
                ++keptCount;
                continue;
            }
            CdVFileSystem.LOGGER.info((Object)("[vfs] auto-cleanup: delete " + String.valueOf((Object)this.kind) + " revision : " + revision.getFile().getPath()));
            CdVFileSystemUtils.deleteQuietly(revision.getFile());
        }
    }

    @Nullable
    private File getLatestRevisionFileForRestoreRevDirectory(File directory) throws IOException {
        try {
            Path[] lastFile = new Path[1];
            FileTime[] lastFileModified = new FileTime[1];
            this.vfs.forEachFile(directory, entry -> entry.toFile().getName().endsWith(".zip"), vPath -> {
                try {
                    FileTime modified = Files.getLastModifiedTime(vPath.path, new LinkOption[0]);
                    if (lastFileModified[0] == null || lastFileModified[0].compareTo(modified) < 0) {
                        lastFile[0] = vPath.path;
                        lastFileModified[0] = modified;
                    }
                }
                catch (IOException ex) {
                    throw new CdVFileSystemTunneledIOExceptionR(ex);
                }
            });
            return lastFile[0] != null ? lastFile[0].toFile() : null;
        }
        catch (CdVFileSystemTunneledIOExceptionR ex) {
            throw ex.getActual();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private String unmarshallRevDirectoryInfo(CdVFileRevFolderInfoResolver resolver, File revs) {
        try {
            File revFile = this.getLatestRevisionFileForRestoreRevDirectory(revs);
            if (revFile == null) {
                return null;
            }
            CdVFileSystem vfs = this.getVfs();
            File revTmp = vfs.createTmpFile(CdVFileSystemTmpReason.REVISION, this.tmpDirectory);
            try {
                if (this.kind == CdVFileRevManagerKind.SCHEMA_BUILDER) {
                    this.unmarshallRevisionContent(revTmp, revFile);
                    String string = resolver.resolve(revs.getName(), revTmp);
                    return string;
                }
                String string = null;
                return string;
            }
            catch (IOException ex) {
                CdVFileSystem.LOGGER.error((Object)("[vfs] could not unmarshall the " + String.valueOf((Object)this.kind) + " revision payload : " + revFile.getPath()), (Throwable)ex);
                String string2 = null;
                return string2;
            }
            finally {
                vfs.delete(revTmp);
            }
        }
        catch (IOException ex2) {
            CdVFileSystem.LOGGER.error((Object)("[vfs] could not unmarshall the " + String.valueOf((Object)this.kind) + " revision(s) payload : " + revs.getPath()), (Throwable)ex2);
            return null;
        }
    }

    private CdVFileRev unmarshallRevision(File to, File revFile, boolean withPayload) throws IOException {
        List<CdVFileRevAction> actions = null;
        String payload = null;
        try (FileInputStream in = new FileInputStream(revFile);
             ZipInputStream zIn = new ZipInputStream(in);){
            ZipEntry entry;
            while ((entry = zIn.getNextEntry()) != null) {
                if (entry.getName().equals(REVISION_PROPERTIES)) {
                    Properties properties = new Properties();
                    properties.load(zIn);
                    actions = CdVFileRevAction.create(properties);
                    continue;
                }
                if (!entry.getName().equals(REVISION_PAYLOAD) || !withPayload) continue;
                payload = IOUtils.toString((InputStream)zIn, (Charset)StandardCharsets.UTF_8);
            }
        }
        String mainFileName = to.getName();
        return new CdVFileRev(mainFileName, revFile, actions, payload);
    }

    private void unmarshallRevisionContent(File to, File revFile) throws IOException {
        try (FileInputStream in = new FileInputStream(revFile);
             ZipInputStream zIn = new ZipInputStream(in);){
            ZipEntry entry;
            while ((entry = zIn.getNextEntry()) != null && !entry.getName().equals(REVISION_PAYLOAD)) {
            }
            try (FileOutputStream out = new FileOutputStream(to);
                 BufferedOutputStream bOut = new BufferedOutputStream(out);){
                IOUtils.copy((InputStream)zIn, (OutputStream)bOut);
            }
        }
    }

    @Nullable
    private File getRevisionDirectory(File to) {
        String toName;
        File toParent = to.getParentFile();
        File revisions = new File(toParent, (toName = to.getName()) + REVISIONS_SUFFIX);
        if (revisions.isDirectory()) {
            return revisions;
        }
        return null;
    }

    @Nullable
    private File getRevisionFile(File to, String revFileName) {
        File revDirectory = this.getRevisionDirectory(to);
        if (revDirectory == null) {
            return null;
        }
        return new File(revDirectory, revFileName);
    }
}

