/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.fs.revision;

import crazydev.common.fs.CdVFileSystem;
import crazydev.common.fs.revision.CdVFileRevAction;
import crazydev.common.utils.CdStringUtils;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class CdVFileRev {
    private static final Pattern DEPRECATED_FILE_NUMBER_PATTERN = Pattern.compile("^r(\\d+)\\.zip$");
    public static final String BOOKMARK = "bookmark";
    public static final String OPERATION = "operation";
    public static final String OPERATION_BY = "operationBy";
    private final String mainFileName;
    private final File file;
    private final int number;
    private final List<CdVFileRevAction> actions;
    @Nullable
    private final String payload;

    public CdVFileRev(String mainFileName, File file, @Nullable List<CdVFileRevAction> actions, @Nullable String payload) {
        this.mainFileName = mainFileName;
        this.file = file;
        Matcher matcher = DEPRECATED_FILE_NUMBER_PATTERN.matcher(file.getName());
        this.number = matcher.find() ? Integer.parseInt(matcher.group(1)) : -1;
        this.actions = actions;
        this.payload = payload;
    }

    public String getMainFileName() {
        return this.mainFileName;
    }

    public File getFile() {
        return this.file;
    }

    public String getRevFileName() {
        return this.file.getName();
    }

    public String getRevFileNameS() {
        return this.number != -1 ? String.valueOf(this.number) : this.file.getName();
    }

    public long getRevFileNameS_value() {
        if (this.number != -1) {
            return this.number;
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss SSS zzz");
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
            Date date = df.parse(this.file.getName());
            return date.getTime();
        }
        catch (ParseException ex) {
            CdVFileSystem.LOGGER.error((Object)("[vfs] could not get the timestamp of the revision : " + this.file.getPath()));
            return this.file.lastModified();
        }
    }

    public long getAutoCleanupCreationTimestamp() {
        long lastModified;
        if (this.number == -1) {
            try {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss SSS zzz");
                df.setTimeZone(TimeZone.getTimeZone("UTC"));
                Date date = df.parse(this.file.getName());
                return date.getTime();
            }
            catch (ParseException ex) {
                CdVFileSystem.LOGGER.error((Object)("[vfs] auto-cleanup: could not get the creation timestamp of the revision : " + this.file.getPath()), (Throwable)ex);
            }
        }
        if ((lastModified = this.file.lastModified()) == 0L) {
            CdVFileSystem.LOGGER.error((Object)("[vfs] auto-cleanup: could not get the creation timestamp of the revision : " + this.file.getPath()));
            return new Date().getTime();
        }
        return lastModified;
    }

    @Nullable
    public String getLastModifiedS() {
        long modified = this.file.lastModified();
        if (modified == 0L) {
            CdVFileSystem.LOGGER.error((Object)("[vfs] could not retrieve the revision timestamp : " + this.file.getPath()));
            return null;
        }
        Date timestamp = new Date(modified);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss SSS zzz");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df.format(timestamp);
    }

    public boolean hasBookmark() {
        if (this.actions != null) {
            for (CdVFileRevAction action : this.actions) {
                if (!action.isBookmark()) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public String getBookmark() {
        if (this.actions != null) {
            for (CdVFileRevAction action : this.actions) {
                if (!action.isBookmark()) continue;
                return action.message;
            }
        }
        return null;
    }

    @Nullable
    public String getOperationBy() {
        if (this.actions != null) {
            for (CdVFileRevAction action : this.actions) {
                if (!CdStringUtils.isNotNullAndNotBlank(action.messageBy)) continue;
                return action.messageBy;
            }
        }
        return null;
    }

    @Nullable
    public String getOperation() {
        if (this.actions != null) {
            for (CdVFileRevAction action : this.actions) {
                if (!action.isOperation()) continue;
                return action.message;
            }
        }
        return null;
    }

    @Nullable
    public String getPayload() {
        return this.payload;
    }

    public String toString() {
        return this.file.getName() + (this.hasBookmark() ? "*" : "");
    }
}

