/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.fs;

import crazydev.common.fs.SafeZipEntry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SafeZipInputStream
extends InputStream {
    private final ZipInputStream zip;
    private final String targetCanPath;
    private final Path targetPath;

    public SafeZipInputStream(InputStream in, Path targetPath) throws IOException {
        this.zip = new ZipInputStream(in);
        this.targetPath = targetPath;
        this.targetCanPath = targetPath.toFile().getCanonicalPath() + File.separator;
    }

    @Override
    public int read() throws IOException {
        return this.zip.read();
    }

    @Override
    public int read(byte @NotNull [] b) throws IOException {
        return this.zip.read(b);
    }

    @Override
    public int read(byte @NotNull [] b, int off, int len) throws IOException {
        return this.zip.read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        this.zip.close();
    }

    public SafeZipEntry getNextEntry() throws IOException {
        ZipEntry next;
        while ((next = this.zip.getNextEntry()) != null) {
            String safeName = this.checkPathTraversal(next);
            if (safeName == null) continue;
            return new SafeZipEntry(safeName, next.isDirectory());
        }
        return null;
    }

    @Nullable
    private String checkPathTraversal(ZipEntry zipEntry) {
        try {
            String name = zipEntry.getName();
            Path zipPath = this.targetPath.resolve(Path.of(name, new String[0]));
            String zipCanPath = zipPath.toFile().getCanonicalPath();
            if (zipCanPath.startsWith(this.targetCanPath)) {
                return name;
            }
            return null;
        }
        catch (IOException ignored) {
            return null;
        }
    }
}

