/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.fs;

import crazydev.common.fs.CdVFilePath;
import crazydev.common.fs.CdVFileSystem;
import crazydev.common.fs.CdVFileSystemTunneledIOExceptionR;
import crazydev.common.fs.CdVFileSystemUtils;
import crazydev.common.fs.CdZipOptions;
import crazydev.common.fs.SafeZipEntry;
import crazydev.common.fs.SafeZipInputStream;
import crazydev.common.utils.CdMutableInt;
import crazydev.common.utils.CdSystemUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

class CdVFileSystemHelper {
    private final CdVFileSystem vfs;

    CdVFileSystemHelper(CdVFileSystem vfs) {
        this.vfs = vfs;
    }

    void forEachFileRecursive(Path target, DirectoryStream.Filter<? super Path> filter, Consumer<CdVFilePath> action) throws IOException {
        CdMutableInt count = new CdMutableInt(0);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(target, filter);){
            for (Path entry : stream) {
                if (count.value++ % 100 == 0 && Thread.interrupted()) {
                    throw new RuntimeException("interrupted: directory-iteration");
                }
                if (!entry.toFile().canRead()) continue;
                action.accept(new CdVFilePath(this.vfs, entry));
                if (!Files.isDirectory(entry, new LinkOption[0])) continue;
                this.forEachFileRecursive(entry, filter, action);
            }
        }
    }

    Path createDashboardsBackupDirectory(File backups) throws IOException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss", Locale.US);
        while (true) {
            try {
                String now = format.format(new Date());
                Path path = new File(backups, now).toPath();
                return CdVFileSystemHelper.createFileOrDirectory(path, true);
            }
            catch (FileAlreadyExistsException ignored) {
                CdSystemUtils.sleep(10L);
                continue;
            }
            break;
        }
    }

    Path createTmpFileAsSibling(Path target) throws IOException {
        String name = target.toFile().getName();
        while (true) {
            try {
                Path path = target.resolveSibling(name + CdVFileSystemHelper.suffix());
                return CdVFileSystemHelper.createFileOrDirectory(path, false);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                continue;
            }
            break;
        }
    }

    Path createTmpDirectoryAsSibling(Path target) throws IOException {
        String name = target.toFile().getName();
        while (true) {
            try {
                Path path = target.resolveSibling(name + CdVFileSystemHelper.suffix());
                return CdVFileSystemHelper.createFileOrDirectory(path, true);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                continue;
            }
            break;
        }
    }

    Path createTmpDirectory(File tmpDirectory, String name) throws IOException {
        while (true) {
            try {
                Path path = new File(tmpDirectory, name + "-" + CdVFileSystemHelper.uuid()).toPath();
                return CdVFileSystemHelper.createFileOrDirectory(path, true);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                continue;
            }
            break;
        }
    }

    Path createTmpFile(File tmpDirectory, String name, @Nullable String extension) throws IOException {
        while (true) {
            try {
                Object ext = extension != null ? "." + extension : CdVFileSystem.TMP_EXTENSION;
                Path path = new File(tmpDirectory, name + "-" + CdVFileSystemHelper.uuid() + (String)ext).toPath();
                return CdVFileSystemHelper.createFileOrDirectory(path, false);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                continue;
            }
            break;
        }
    }

    Path createSchemaBackupDirectory(File backupDirectory, String schema, String schemaFileName) throws IOException {
        boolean master = false;
        File schemaDirectory = new File(backupDirectory, schemaFileName);
        try {
            Files.createDirectory(schemaDirectory.toPath(), new FileAttribute[0]);
            master = true;
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
        if (master) {
            File metaInfo = new File(schemaDirectory, "meta-info.txt");
            Files.createFile(metaInfo.toPath(), new FileAttribute[0]);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(metaInfo), StandardCharsets.UTF_8);
            writer.write("schema:" + schema + "\n");
            ((Writer)writer).close();
        }
        return schemaDirectory.toPath();
    }

    Path createSchemaBackupDirectory(File backupDirectory, String schema, String schemaFileName, Supplier<String> timestamp) throws IOException {
        File schemaDirectory = this.createSchemaBackupDirectory(backupDirectory, schema, schemaFileName).toFile();
        String prevTS = null;
        while (true) {
            try {
                String ts = timestamp.get();
                if (ts.equals(prevTS)) {
                    throw new RuntimeException("internal error: inconsistent timestamp");
                }
                prevTS = ts;
                Path path = new File(schemaDirectory, ts).toPath();
                return CdVFileSystemHelper.createFileOrDirectory(path, true);
            }
            catch (FileAlreadyExistsException ignored) {
                CdSystemUtils.sleep(1L);
                continue;
            }
            break;
        }
    }

    Path createSchemaBackupTmpDirectoryForIncrLoad(File backupDirectory, String schemaFileName, Supplier<String> timestamp) throws IOException {
        Path path;
        File existingSchema = new File(backupDirectory, schemaFileName);
        while (true) {
            try {
                path = CdVFileSystemHelper.createFileOrDirectory(new File(existingSchema, "incr-load" + CdVFileSystemHelper.suffix()).toPath(), true);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                continue;
            }
            break;
        }
        return CdVFileSystemHelper.createFileOrDirectory(new File(path.toFile(), timestamp.get()).toPath(), true);
    }

    public Path createSchemaBackupTmpDirectoryForUpload(File backupDirectory, String fileName) throws IOException {
        while (true) {
            try {
                Path path = new File(backupDirectory, fileName + CdVFileSystemHelper.suffix()).toPath();
                return CdVFileSystemHelper.createFileOrDirectory(path, true);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                continue;
            }
            break;
        }
    }

    Path createRevisionFile(File target, String revs) throws IOException {
        File toParent = target.getParentFile();
        String toName = target.getName();
        File revisions = new File(toParent, toName + revs);
        try {
            CdVFileSystemHelper.createFileOrDirectory(revisions.toPath(), true);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
        while (true) {
            try {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss SSS zzz");
                df.setTimeZone(TimeZone.getTimeZone("UTC"));
                Path path = new File(revisions, df.format(new Date()) + ".zip").toPath();
                return CdVFileSystemHelper.createFileOrDirectory(path, false);
            }
            catch (FileAlreadyExistsException ignored) {
                CdSystemUtils.sleep(1L);
                continue;
            }
            break;
        }
    }

    void uploadZipFile(Path tmpDirectory, File zip, Predicate<String> exclude) throws IOException {
        this.uploadZipFile(tmpDirectory, new FileInputStream(zip), exclude);
    }

    void uploadZipFile(Path tmpDirectory, InputStream zip) throws IOException {
        this.uploadZipFile(tmpDirectory, zip, null);
    }

    void uploadZipFile(Path tmpDirectory, InputStream zip, @Nullable Predicate<String> exclude) throws IOException {
        try (SafeZipInputStream in = new SafeZipInputStream(zip, tmpDirectory);){
            SafeZipEntry zipEntry;
            while ((zipEntry = in.getNextEntry()) != null) {
                String zipEntryName = zipEntry.getName();
                if (exclude != null && !exclude.test(zipEntryName)) continue;
                if (CdVFileSystem.LOGGER.isDebugEnabled()) {
                    CdVFileSystem.LOGGER.debug((Object)("[vfs] << " + zipEntryName));
                }
                Path target = tmpDirectory.resolve(Path.of(zipEntryName, new String[0]));
                target.getParent().toFile().mkdirs();
                if (zipEntry.isDirectory()) continue;
                try (FileOutputStream out = new FileOutputStream(target.toFile());){
                    IOUtils.copyLarge((InputStream)in, (OutputStream)out);
                }
            }
        }
    }

    void zip(CdZipOptions options, File zip, File ... sources) throws IOException {
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zip));
        try {
            if (sources != null) {
                for (File source : sources) {
                    Path sourceP = source.toPath();
                    if (!Files.isDirectory(sourceP, new LinkOption[0])) {
                        CdVFileSystemHelper.zipFile(options, out, sourceP, sourceP);
                        continue;
                    }
                    this.forEachFileRecursive(sourceP, p -> true, vPath -> CdVFileSystemHelper.zipFile(options, out, sourceP, vPath.path));
                }
            }
            out.flush();
            out.close();
        }
        catch (CdVFileSystemTunneledIOExceptionR ex) {
            IOUtils.closeQuietly((OutputStream)out);
            throw ex.getActual();
        }
        catch (IOException ex) {
            IOUtils.closeQuietly((OutputStream)out);
            throw ex;
        }
    }

    void gcDashboardBackup(Path backupTimestamp, Path backupTimestampApp) {
        try {
            if (backupTimestamp != null && this.vfs.isEmpty(backupTimestamp.toFile())) {
                CdVFileSystemUtils.deleteQuietly(backupTimestamp.toFile());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (backupTimestamp != null && backupTimestampApp != null && this.vfs.isEmpty(backupTimestampApp.toFile())) {
                CdVFileSystemUtils.deleteQuietly(backupTimestamp.toFile());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipFile(CdZipOptions options, ZipOutputStream out, Path root, Path file) {
        block7: {
            try {
                Object zipName;
                Path rootParent = !options.noRoot ? root.getParent() : root;
                Object object = zipName = rootParent != null ? rootParent.relativize(file).toFile().getPath() : file.toFile().getPath();
                if (File.separatorChar != '/') {
                    zipName = ((String)zipName).replace(File.separatorChar, '/');
                }
                if (Files.isDirectory(file, new LinkOption[0])) {
                    if (!((String)zipName).endsWith("/")) {
                        zipName = (String)zipName + "/";
                    }
                    ZipEntry entry = new ZipEntry((String)zipName);
                    out.putNextEntry(entry);
                    out.closeEntry();
                    break block7;
                }
                ZipEntry entry = new ZipEntry((String)zipName);
                out.putNextEntry(entry);
                BufferedInputStream in = null;
                try {
                    in = new BufferedInputStream(new FileInputStream(file.toFile()));
                    IOUtils.copyLarge((InputStream)in, (OutputStream)out);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
                out.closeEntry();
            }
            catch (IOException ex) {
                throw new CdVFileSystemTunneledIOExceptionR(ex);
            }
        }
    }

    private static Path createFileOrDirectory(Path path, boolean directory) throws IOException {
        Path file = directory ? Files.createDirectory(path, new FileAttribute[0]) : Files.createFile(path, new FileAttribute[0]);
        return file;
    }

    private static String uuid() {
        return UUID.randomUUID().toString();
    }

    private static String suffix() {
        return "-" + CdVFileSystemHelper.uuid() + CdVFileSystem.TMP_EXTENSION;
    }
}

