/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.fs;

import crazydev.common.fs.CdVFilePath;
import crazydev.common.fs.CdVFileSupplier;
import crazydev.common.fs.CdVFileSystemHelper;
import crazydev.common.fs.CdVFileSystemTmpReason;
import crazydev.common.fs.CdVFileSystemUtils;
import crazydev.common.fs.CdZipOptions;
import crazydev.common.fs.revision.CdVFileRev;
import crazydev.common.fs.revision.CdVFileRevAction;
import crazydev.common.fs.revision.CdVFileRevFolder;
import crazydev.common.fs.revision.CdVFileRevFolderInfoResolver;
import crazydev.common.fs.revision.CdVFileRevHelper;
import crazydev.common.fs.revision.CdVFileRevHelperConf;
import crazydev.common.fs.revision.CdVFileRevManagerKind;
import crazydev.common.utils.CdMutableInt;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class CdVFileSystem {
    public static final char BOM_FOR_UTF8 = '\ufeff';
    public static String TMP_EXTENSION = ".icc-tmp";
    public static final Logger LOGGER = Logger.getLogger((String)"icCube.vfs");
    private final CdVFileSystemHelper helper = new CdVFileSystemHelper(this);

    public static boolean isTemporary(Path target) {
        return target.toFile().getName().endsWith(TMP_EXTENSION);
    }

    public static boolean isRevFolder(File file) {
        return CdVFileRevHelper.isRevFolder(file);
    }

    public static String toFileName(String name) {
        StringBuilder sb = new StringBuilder();
        for (int idx = 0; idx < name.length(); ++idx) {
            char cc = name.charAt(idx);
            if (Character.isLetter(cc) || Character.isDigit(cc) || cc == '-') {
                sb.append(cc);
                continue;
            }
            sb.append('_');
        }
        return sb.toString();
    }

    public static File toRelativePath(File root, File target) {
        File parentFile;
        ArrayList<String> names = new ArrayList<String>();
        for (parentFile = target; parentFile != null && !parentFile.equals(root); parentFile = parentFile.getParentFile()) {
            names.add(0, parentFile.getName());
        }
        if (parentFile == null || names.isEmpty()) {
            return target;
        }
        File relPath = null;
        for (String name : names) {
            if (relPath == null) {
                relPath = new File(name);
                continue;
            }
            relPath = new File(relPath, name);
        }
        return relPath;
    }

    public static File assertDirectory(String name, @Nullable File directory) {
        if (directory == null) {
            throw new RuntimeException("internal error: [" + name + "] no directory [null]!");
        }
        if (!directory.exists()) {
            throw new RuntimeException("internal error: [" + name + "] missing directory [" + directory.getAbsolutePath() + "]!");
        }
        if (!directory.isDirectory()) {
            throw new RuntimeException("internal error: [" + name + "] not a directory [" + directory.getAbsolutePath() + "]!");
        }
        return directory;
    }

    public boolean validateDirectoryOnStartup(File directory) throws IOException {
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                throw new IOException(String.format("the requested directory [%s] is not a directory", directory.getAbsolutePath()));
            }
            return false;
        }
        LOGGER.debug((Object)("[vfs] creating " + directory.getAbsolutePath()));
        if (!this.mkdir(directory)) {
            if (directory.isDirectory()) {
                return false;
            }
            throw new IOException(String.format("could not create the requested directory [%s]", directory.getAbsolutePath()));
        }
        LOGGER.debug((Object)("[vfs] created " + directory.getAbsolutePath()));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installWebDashboards(File app, File backups, File zip, Predicate<String> filter, boolean backup) throws IOException {
        Path appTmpDirectory = this.helper.createTmpDirectoryAsSibling(app.toPath());
        Path appBackupsTimestamp = null;
        Path appBackupsTimestampApp = null;
        try {
            this.helper.uploadZipFile(appTmpDirectory, zip, filter);
            if (backup && app.exists() && !this.isEmpty(app)) {
                appBackupsTimestamp = this.helper.createDashboardsBackupDirectory(backups);
                appBackupsTimestampApp = new File(appBackupsTimestamp.toFile(), "app").toPath();
                this.moveDirectory(app, appBackupsTimestampApp.toFile());
            }
            LOGGER.debug((Object)("[vfs] delete [" + app.getAbsolutePath() + "]"));
            CdVFileSystemUtils.deleteDirectory(app);
            LOGGER.debug((Object)("[vfs] move [" + appTmpDirectory.toFile().getAbsolutePath() + "][" + app.getAbsolutePath() + "][" + app.exists() + "]"));
            this.moveDirectory(appTmpDirectory.toFile(), app);
        }
        catch (Throwable throwable) {
            CdVFileSystemUtils.deleteQuietly(appTmpDirectory.toFile());
            this.helper.gcDashboardBackup(appBackupsTimestamp, appBackupsTimestampApp);
            throw throwable;
        }
        CdVFileSystemUtils.deleteQuietly(appTmpDirectory.toFile());
        this.helper.gcDashboardBackup(appBackupsTimestamp, appBackupsTimestampApp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installWebDashboardsFromBackup(File app, File backups, String timestamp) throws IOException {
        File backup = new File(backups, timestamp);
        if (!backup.exists()) {
            throw new IOException("missing Dashboards app. backup [" + timestamp + "]");
        }
        File backupApp = new File(backup, "app");
        if (!backupApp.exists()) {
            throw new IOException("missing Dashboards app. backup [" + timestamp + "] /app");
        }
        File backupAppApp = new File(backupApp, "app");
        if (!backupAppApp.exists()) {
            throw new IOException("missing Dashboards app. backup [" + timestamp + "] /app/app");
        }
        Path appBackupsTimestamp = null;
        Path appBackupsTimestampApp = null;
        try {
            if (app.exists() && !this.isEmpty(app)) {
                appBackupsTimestamp = this.helper.createDashboardsBackupDirectory(backups);
                appBackupsTimestampApp = new File(appBackupsTimestamp.toFile(), "app").toPath();
                this.moveDirectory(app, appBackupsTimestampApp.toFile());
            }
            CdVFileSystemUtils.deleteDirectory(app);
            this.moveDirectory(backupApp, app);
            this.delete(backup);
            this.helper.gcDashboardBackup(appBackupsTimestamp, appBackupsTimestampApp);
            this.helper.gcDashboardBackup(backup.toPath(), backupApp.toPath());
        }
        catch (Throwable throwable) {
            this.helper.gcDashboardBackup(appBackupsTimestamp, appBackupsTimestampApp);
            this.helper.gcDashboardBackup(backup.toPath(), backupApp.toPath());
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadZip(File target, CdVFileSupplier<InputStream> zip) throws IOException {
        try (InputStream in = zip.get();){
            Path tmpDirectory = this.helper.createTmpDirectoryAsSibling(target.toPath());
            try {
                this.helper.uploadZipFile(tmpDirectory, in);
                this.moveDirectory(tmpDirectory.toFile(), target);
            }
            finally {
                CdVFileSystemUtils.deleteQuietly(tmpDirectory.toFile());
            }
        }
    }

    public void zip(CdZipOptions options, File zip, File ... sources) throws IOException {
        this.helper.zip(options, zip, sources);
    }

    public File createTmpDirectory(CdVFileSystemTmpReason reason, File tmpDirectory) throws IOException {
        return this.helper.createTmpDirectory(tmpDirectory, reason.fileName).toFile();
    }

    public File createTmpFile(CdVFileSystemTmpReason reason, File tmpDirectory) throws IOException {
        return this.helper.createTmpFile(tmpDirectory, reason.fileName, null).toFile();
    }

    public File createTmpFileForDownload(File tmpDirectory, String extension) throws IOException {
        return this.helper.createTmpFile(tmpDirectory, CdVFileSystemTmpReason.FILE_DOWNLOAD.fileName, extension).toFile();
    }

    public File createTmpFileForUpload(File tmpDirectory, String extension) throws IOException {
        return this.helper.createTmpFile(tmpDirectory, CdVFileSystemTmpReason.FILE_UPLOAD.fileName, extension).toFile();
    }

    public File createSchemaBackupDirectory(File backupDirectory, String schema, String schemaFileName) throws IOException {
        return this.helper.createSchemaBackupDirectory(backupDirectory, schema, schemaFileName).toFile();
    }

    public File createSchemaBackupDirectory(File backupDirectory, String schema, String schemaFileName, Supplier<String> timestamp) throws IOException {
        return this.helper.createSchemaBackupDirectory(backupDirectory, schema, schemaFileName, timestamp).toFile();
    }

    public File createSchemaBackupTmpDirectoryForIncrLoad(File backupDirectory, String schemaFileName, Supplier<String> timestamp) throws IOException {
        return this.helper.createSchemaBackupTmpDirectoryForIncrLoad(backupDirectory, schemaFileName, timestamp).toFile();
    }

    public File createSchemaBackupTmpDirectoryForUpload(File backupDirectory, String fileName) throws IOException {
        return this.helper.createSchemaBackupTmpDirectoryForUpload(backupDirectory, fileName).toFile();
    }

    public File createRevisionFile(File target, String revs) throws IOException {
        return this.helper.createRevisionFile(target, revs).toFile();
    }

    public InputStream createInputStream(File target) throws IOException {
        return Files.newInputStream(target.toPath(), new OpenOption[0]);
    }

    public List<String> readAllLines(File target) throws IOException {
        return Files.readAllLines(target.toPath(), StandardCharsets.UTF_8);
    }

    public DirectoryStream<Path> createDirectoryStream(File target, DirectoryStream.Filter<? super Path> filter) throws IOException {
        return Files.newDirectoryStream(target.toPath(), filter);
    }

    public void forEachFile(File target, DirectoryStream.Filter<? super Path> filter, Consumer<CdVFilePath> action) throws IOException {
        CdMutableInt count = new CdMutableInt(0);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(target.toPath(), filter);){
            for (Path entry : stream) {
                if (count.value++ % 100 == 0 && Thread.interrupted()) {
                    throw new RuntimeException("interrupted: directory-iteration");
                }
                action.accept(new CdVFilePath(this, entry));
            }
        }
    }

    public void forEachFileRecursive(File target, DirectoryStream.Filter<? super Path> filter, Consumer<CdVFilePath> action) throws IOException {
        this.helper.forEachFileRecursive(target.toPath(), filter, action);
    }

    public boolean exists(File target) {
        return Files.exists(target.toPath(), new LinkOption[0]);
    }

    public boolean isEmpty(File target) throws IOException {
        Path path = target.toPath();
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (DirectoryStream<Path> directory = Files.newDirectoryStream(path);){
                boolean bl = !directory.iterator().hasNext();
                return bl;
            }
        }
        return false;
    }

    public long getSize(File target) {
        if (!target.exists()) {
            return 0L;
        }
        if (target.isFile()) {
            return target.length();
        }
        try {
            final MutableLong size = new MutableLong(0L);
            Files.walkFileTree(target.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){
                {
                    Objects.requireNonNull(this$0);
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    size.add(attrs.size());
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }
            });
            return size.longValue();
        }
        catch (IOException ignored) {
            LOGGER.error((Object)("[vfs] could not retrieve the size of " + String.valueOf(target)));
            return -1L;
        }
    }

    public boolean mkdir(File target) {
        return target.mkdir();
    }

    public boolean delete(File target) {
        return CdVFileSystemUtils.deleteQuietly(target);
    }

    public void empty(File target) {
        try {
            CdVFileSystemUtils.cleanDirectory(target);
        }
        catch (IOException ignored) {
            LOGGER.warn((Object)("[vfs] could not empty the directory [" + target.getAbsolutePath() + "]"), (Throwable)ignored);
        }
    }

    public void copyForDirectoryInitOnStartup(File from, File to) throws IOException {
        Files.copy(from.toPath(), to.toPath(), new CopyOption[0]);
    }

    public boolean copyForUI(Reader source, Writer output, int maxLen) throws IOException {
        char[] buffer = new char[4096];
        long written = 0L;
        int read = 0;
        while (-1 != (read = source.read(buffer))) {
            output.write(buffer, 0, read);
            if ((written += (long)read) < (long)maxLen) continue;
            return true;
        }
        return false;
    }

    public void moveDirectory(File source, File target) throws IOException {
        Files.move(source.toPath(), target.toPath(), StandardCopyOption.ATOMIC_MOVE);
    }

    public void moveFile(File source, File target) throws IOException {
        Files.move(source.toPath(), target.toPath(), StandardCopyOption.ATOMIC_MOVE);
    }

    public void saveFile(File target, InputStream content) throws IOException {
        Path tmp = this.helper.createTmpFileAsSibling(target.toPath());
        try {
            try (OutputStream out = Files.newOutputStream(tmp, StandardOpenOption.WRITE);){
                IOUtils.copyLarge((InputStream)content, (OutputStream)out);
            }
            Files.move(tmp, target.toPath(), StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException ex) {
            try {
                Files.deleteIfExists(tmp);
            }
            catch (IOException ignored) {
                LOGGER.warn((Object)("[vfs] could not delete the tmp. file [" + String.valueOf(tmp.toAbsolutePath()) + "]"), (Throwable)ignored);
            }
            throw ex;
        }
    }

    public void saveOrUpdateWithRevision(CdVFileRevHelperConf configuration, File to, InputStream content, CdVFileRevAction action) throws IOException {
        if (configuration.kind() == CdVFileRevManagerKind.SCHEMA_BUILDER) {
            CdVFileRevHelper revisions = new CdVFileRevHelper(this, configuration);
            revisions.saveOrUpdate(to, content, action);
        } else {
            this.saveFile(to, content);
        }
    }

    public void bookmarkRevision(CdVFileRevHelperConf configuration, File to, String revFileName, String bookmark) throws IOException {
        CdVFileRevHelper revisions = new CdVFileRevHelper(this, configuration);
        revisions.bookmarkRevision(to, revFileName, bookmark);
    }

    public void restoreRevision(CdVFileRevHelperConf configuration, String savedBy, File to, String revFileName) throws IOException {
        CdVFileRevHelper revisions = new CdVFileRevHelper(this, configuration);
        revisions.restoreRevision(savedBy, to, true, revFileName);
    }

    public File restoreRevDirectory(CdVFileRevHelperConf configuration, String savedBy, String relPath) throws IOException {
        CdVFileRevHelper revisions = new CdVFileRevHelper(this, configuration);
        return revisions.restoreRevDirectory(savedBy, relPath);
    }

    public void forEachRevisions(CdVFileRevHelperConf configuration, File to, Consumer<CdVFileRev> consumer) {
        CdVFileRevHelper revisions = new CdVFileRevHelper(this, configuration);
        revisions.forEachRevisions(to, consumer);
    }

    public void forEachRevDirectory(CdVFileRevHelperConf configuration, CdVFileRevFolderInfoResolver resolver, Consumer<CdVFileRevFolder> consumer) {
        CdVFileRevHelper revisions = new CdVFileRevHelper(this, configuration);
        revisions.forEachRevDirectory(resolver, consumer);
    }

    public CdVFileRev getRevision(CdVFileRevHelperConf configuration, File to, String revFileName, boolean withPayload) throws IOException {
        CdVFileRevHelper revisions = new CdVFileRevHelper(this, configuration);
        return revisions.getRevision(to, revFileName, withPayload);
    }

    @Nullable
    public CdVFileRevFolder getRevDirectory(CdVFileRevHelperConf configuration, CdVFileRevFolderInfoResolver resolver, String relPath) {
        CdVFileRevHelper revisions = new CdVFileRevHelper(this, configuration);
        return revisions.getRevDirectory(resolver, relPath);
    }

    public void saveLicense(File folder, byte[] content) throws IOException {
        LOGGER.info((Object)("[vfs] writing license " + folder.getAbsolutePath()));
        File lix = new File(folder, "icCube-4.lic");
        this.saveFile(lix, new ByteArrayInputStream(content));
    }
}

