/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.exception;

import crazydev.common.exception.CdErrorCode;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.utils.CdClassUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class CdErrorCodes {
    private static final Map<Class, Mapping> mappings = new HashMap<Class, Mapping>();

    public static <T extends CdErrorCode> Collection<T> getAllErrorCodes(Class<T> clazz) {
        Mapping mapping = mappings.get(clazz);
        if (mapping == null) {
            throw new CdProgrammingException("Missing mappings for [" + String.valueOf(clazz) + "]!");
        }
        return mapping.getAllErrorCodes();
    }

    @Nullable
    public static <T extends CdErrorCode> T getErrorCode(Class<T> clazz, String name) {
        Mapping mapping = mappings.get(clazz);
        if (mapping == null) {
            throw new CdProgrammingException("Missing mappings for [" + String.valueOf(clazz) + "]!");
        }
        return mapping.getErrorCode(name);
    }

    public static synchronized <T extends CdErrorCode> void register(Class<T> clazz, String prefix) {
        if (mappings.containsKey(clazz)) {
            return;
        }
        mappings.put(clazz, new Mapping<T>(clazz, prefix));
    }

    static class Mapping<T extends CdErrorCode> {
        private final Class<T> clazz;
        private final List<T> errorCodes = new ArrayList<T>();
        private final Map<String, T> errorCodesByName = new HashMap<String, T>();

        public Mapping(Class<T> clazz, String prefix) {
            this.clazz = clazz;
            for (Field field : CdClassUtils.getAllDeclaredStaticFields(clazz, clazz)) {
                this.register(field, prefix);
            }
        }

        private void register(Field field, String prefix) {
            try {
                CdErrorCode errorCode = (CdErrorCode)field.get(null);
                String value = errorCode.getValue();
                if (this.errorCodesByName.containsKey(value)) {
                    throw new CdProgrammingException("Duplicated error code value [" + String.valueOf(field) + "]!");
                }
                if (!value.startsWith(prefix)) {
                    throw new CdProgrammingException("Missing prefix [" + prefix + "] for the error code value [" + String.valueOf(field) + "]!");
                }
                this.errorCodesByName.put(value, errorCode);
                this.errorCodes.add(errorCode);
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace(System.err);
                throw new CdProgrammingException("Field [" + String.valueOf(field) + "] error!", ex);
            }
        }

        public Collection<T> getAllErrorCodes() {
            return this.errorCodes;
        }

        @Nullable
        public T getErrorCode(String name) {
            return (T)((CdErrorCode)this.errorCodesByName.get(name));
        }
    }
}

