/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.exception;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.babylon.CdBabylonUtils;
import crazydev.common.exception.CdError;
import crazydev.common.exception.programming.CdProgrammingException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.zip.CRC32;

public abstract class CdErrorCode
implements Serializable {
    private static final long serialVersionUID = 7852268103345826850L;
    protected final String value;
    protected final boolean localizeParams;
    private final long numericalValue;
    private static final Map<Long, CdErrorCode> checksums = new HashMap<Long, CdErrorCode>();

    public CdErrorCode(String value) {
        this(false, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CdErrorCode(boolean localizeParams, String value) {
        this.value = value;
        this.localizeParams = localizeParams;
        CRC32 crc32 = new CRC32();
        crc32.update(value.getBytes(StandardCharsets.UTF_8));
        this.numericalValue = crc32.getValue();
        Map<Long, CdErrorCode> map = checksums;
        synchronized (map) {
            CdErrorCode errorCode = checksums.get(this.numericalValue);
            if (errorCode != null) {
                throw new CdProgrammingException("Duplicated error-code numerical value [" + String.valueOf(errorCode) + "]");
            }
            checksums.put(this.numericalValue, this);
        }
    }

    public String getValue() {
        return this.value;
    }

    public String getValueAsMdHref() {
        return this.value.toLowerCase().replace(" ", "-").replace(".", "");
    }

    public long getNumericalValue() {
        return this.numericalValue;
    }

    public String asMessage(CdBabylonService babylon, Serializable ... params) {
        Serializable[] localizedParams;
        if (params != null && params.length > 0) {
            localizedParams = new Serializable[params.length];
            for (int idx = 0; idx < params.length; ++idx) {
                Serializable param = params[idx];
                localizedParams[idx] = param instanceof CdError ? ((CdError)param).asMessage(babylon) : (param instanceof String && this.localizeParams ? babylon.translate((String)((Object)param), new Serializable[0]) : param);
            }
        } else {
            localizedParams = params;
        }
        String resourceBundleName = this.getClass().getName();
        ClassLoader cl = this.getClass().getClassLoader();
        Locale locale = babylon.getLocale();
        return CdBabylonUtils.translate(new HashSet<String>(), locale, resourceBundleName, cl, this.getValue(), localizedParams);
    }

    public String toString() {
        return this.value;
    }
}

