/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.exception;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.babylon.CdLoggingBabylonService;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.exception.CdErrorLocation;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public class CdError<LOCATION extends CdErrorLocation, CODE extends CdErrorCode>
implements Serializable {
    private static final long serialVersionUID = 3244944948051038186L;
    @Nullable
    private LOCATION location;
    private final CODE code;
    @Nullable
    private final Serializable[] params;
    @Nullable
    private String prefix;

    protected CdError(CODE code, Serializable ... params) {
        this(null, code, params);
    }

    protected CdError(@Nullable LOCATION location, CODE code, Serializable ... params) {
        this.location = location;
        this.code = code;
        this.params = params;
    }

    public static CdError create(CdErrorCode code, Serializable ... params) {
        return new CdError(code, params);
    }

    @Nullable
    public LOCATION getLocation() {
        return this.location;
    }

    public void setLocation(@Nullable LOCATION location) {
        this.location = location;
    }

    @Nullable
    public CdErrorLocation getErrorRange() {
        return null;
    }

    public CODE getCode() {
        return this.code;
    }

    public void wrapMessage(String prefix) {
        this.prefix = prefix;
    }

    public String asMessage(CdBabylonService babylon) {
        String message = ((CdErrorCode)this.code).asMessage(babylon, this.params);
        if (this.prefix != null) {
            return this.prefix + message;
        }
        return message;
    }

    public String asFullMessage(CdBabylonService babylon) {
        String message = this.asMessage(babylon);
        LOCATION where = this.getLocation();
        String extra = where == null ? "" : " location: " + ((CdErrorLocation)where).asString(babylon);
        return "[" + ((CdErrorCode)this.code).getValue() + "] " + message + extra;
    }

    @Nullable
    public Serializable[] getParams() {
        return this.params;
    }

    @Nullable
    public Serializable getFirstParam() {
        return this.params != null && this.params.length > 0 ? this.params[0] : null;
    }

    public String toString() {
        return this.asFullMessage(CdLoggingBabylonService.INSTANCE);
    }
}

