/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.concurrent.atomic;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;

public class CdAtomicDouble
implements Serializable {
    private static final long serialVersionUID = -506228726867480030L;
    protected static final long ZERO = CdAtomicDouble.toLong(0.0);
    protected final AtomicLong bits;

    public CdAtomicDouble() {
        this(0.0);
    }

    public CdAtomicDouble(double value) {
        this.bits = new AtomicLong(CdAtomicDouble.toLong(value));
    }

    public static long toLong(double v) {
        return Double.doubleToLongBits(v);
    }

    public static double toDouble(long v) {
        return Double.longBitsToDouble(v);
    }

    public final double get() {
        return CdAtomicDouble.toDouble(this.bits.get());
    }

    public final void set(double newValue) {
        this.bits.set(CdAtomicDouble.toLong(newValue));
    }

    public final double getAndSet(double newValue) {
        return CdAtomicDouble.toDouble(this.bits.getAndSet(CdAtomicDouble.toLong(newValue)));
    }

    public boolean compareAndSet(double expect, double update) {
        return this.bits.compareAndSet(CdAtomicDouble.toLong(expect), CdAtomicDouble.toLong(update));
    }

    private boolean compareAndSetLongDouble(long expect, double update) {
        return this.bits.compareAndSet(expect, CdAtomicDouble.toLong(update));
    }

    public final double getAndAdd(double delta) {
        double currentAsDouble;
        double next;
        long currentAsLong;
        while (!this.compareAndSetLongDouble(currentAsLong = this.bits.get(), next = (currentAsDouble = CdAtomicDouble.toDouble(currentAsLong)) + delta)) {
        }
        return currentAsDouble;
    }

    public void add(double delta) {
        double currentAsDouble;
        long currentAsLong;
        while (!this.compareAndSetLongDouble(currentAsLong = this.bits.get(), (currentAsDouble = CdAtomicDouble.toDouble(currentAsLong)) + delta)) {
        }
    }

    public double addAndGet(double delta) {
        double currentAsDouble;
        double next;
        long currentAsLong;
        while (!this.compareAndSetLongDouble(currentAsLong = this.bits.get(), next = (currentAsDouble = CdAtomicDouble.toDouble(currentAsLong)) + delta)) {
        }
        return next;
    }

    public final void clear() {
        this.bits.set(ZERO);
    }
}

