/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.collection;

import java.util.Arrays;
import java.util.Random;
import java.util.function.IntPredicate;

public class TCharArrayList
implements Cloneable {
    protected static final int DEFAULT_CAPACITY = 4;
    protected transient char[] _data;
    protected transient int _pos;

    public TCharArrayList() {
    }

    public TCharArrayList(int capacity) {
        this._data = new char[capacity];
        this._pos = 0;
    }

    public TCharArrayList(char[] values) {
        this(Math.max(values.length, 4));
        this.add(values);
    }

    public void ensureCapacity(int capacity) {
        if (this._data == null) {
            this._data = new char[Math.max(4, capacity)];
        }
        if (capacity > this._data.length) {
            int newCap = Math.max(this._data.length << 1, capacity);
            char[] tmp = new char[newCap];
            System.arraycopy(this._data, 0, tmp, 0, this._data.length);
            this._data = tmp;
        }
    }

    public int size() {
        return this._pos;
    }

    public boolean isEmpty() {
        return this._pos == 0;
    }

    public void trimToSize() {
        if (this._data != null && this._data.length > this.size()) {
            char[] tmp = new char[this.size()];
            this.toNativeArray(tmp, 0, tmp.length);
            this._data = tmp;
        }
    }

    public void add(char val) {
        this.ensureCapacity(this._pos + 1);
        this._data[this._pos++] = val;
    }

    public void add(char[] vals) {
        this.add(vals, 0, vals.length);
    }

    public void add(char[] vals, int offset, int length) {
        this.ensureCapacity(this._pos + length);
        System.arraycopy(vals, offset, this._data, this._pos, length);
        this._pos += length;
    }

    public void insert(int offset, char value) {
        if (offset == this._pos) {
            this.add(value);
            return;
        }
        this.ensureCapacity(this._pos + 1);
        System.arraycopy(this._data, offset, this._data, offset + 1, this._pos - offset);
        this._data[offset] = value;
        ++this._pos;
    }

    public void insert(int offset, char[] values) {
        this.insert(offset, values, 0, values.length);
    }

    public void insert(int offset, char[] values, int valOffset, int len) {
        if (offset == this._pos) {
            this.add(values, valOffset, len);
            return;
        }
        this.ensureCapacity(this._pos + len);
        System.arraycopy(this._data, offset, this._data, offset + len, this._pos - offset);
        System.arraycopy(values, valOffset, this._data, offset, len);
        this._pos += len;
    }

    public char get(int offset) {
        if (offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        return this._data[offset];
    }

    public char getQuick(int offset) {
        return this._data[offset];
    }

    public void set(int offset, char val) {
        if (offset < 0 || offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        this._data[offset] = val;
    }

    public char getSet(int offset, char val) {
        if (offset < 0 || offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        char old = this._data[offset];
        this._data[offset] = val;
        return old;
    }

    public void set(int offset, char[] values) {
        this.set(offset, values, 0, values.length);
    }

    public void set(int offset, char[] values, int valOffset, int length) {
        if (offset < 0 || offset + length > this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        System.arraycopy(this._data, offset, values, valOffset, length);
    }

    public void setQuick(int offset, char val) {
        this._data[offset] = val;
    }

    public void clear() {
        this._data = null;
        this._pos = 0;
    }

    public void clear(int capacity) {
        this._data = new char[capacity];
        this._pos = 0;
    }

    public void reset() {
        this.fill('\u0000');
        this._pos = 0;
    }

    public void resetQuick() {
        this._pos = 0;
    }

    public int remove(int offset) {
        char old = this.get(offset);
        this.remove(offset, 1);
        return old;
    }

    public void remove(int offset, int length) {
        if (offset < 0 || offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        if (offset == 0) {
            System.arraycopy(this._data, length, this._data, 0, this._pos - length);
        } else if (this._pos - length != offset) {
            System.arraycopy(this._data, offset + length, this._data, offset, this._pos - (offset + length));
        }
        this._pos -= length;
    }

    public void reverse() {
        this.reverse(0, this._pos);
    }

    public void reverse(int from, int to) {
        if (from == to) {
            return;
        }
        if (from > to) {
            throw new IllegalArgumentException("from cannot be greater than to");
        }
        int i = from;
        for (int j = to - 1; i < j; ++i, --j) {
            this.swap(i, j);
        }
    }

    public void shuffle(Random rand) {
        int i = this._pos;
        while (i-- > 1) {
            this.swap(i, rand.nextInt(i));
        }
    }

    private void swap(int i, int j) {
        char tmp = this._data[i];
        this._data[i] = this._data[j];
        this._data[j] = tmp;
    }

    public Object clone() {
        TCharArrayList clone = null;
        try {
            clone = (TCharArrayList)super.clone();
            clone._data = this._data == null ? null : (char[])this._data.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public char[] toNativeArray() {
        return this.toNativeArray(0, this._pos);
    }

    public char[] toNativeArray(int offset, int len) {
        char[] rv = new char[len];
        this.toNativeArray(rv, offset, len);
        return rv;
    }

    public void toNativeArray(char[] dest, int offset, int len) {
        if (len == 0) {
            return;
        }
        if (offset < 0 || offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        System.arraycopy(this._data, offset, dest, 0, len);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof TCharArrayList) {
            TCharArrayList that = (TCharArrayList)other;
            if (that.size() != this.size()) {
                return false;
            }
            int i = this._pos;
            while (i-- > 0) {
                if (this._data[i] == that._data[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int h = 0;
        int i = this._pos;
        while (i-- > 0) {
            h = h * 31 + this._data[i];
        }
        return h;
    }

    public boolean forEach(IntPredicate procedure) {
        for (int i = 0; i < this._pos; ++i) {
            if (procedure.test(this._data[i])) continue;
            return false;
        }
        return true;
    }

    public void sort() {
        if (!this.isEmpty()) {
            Arrays.sort(this._data, 0, this._pos);
        }
    }

    public void sort(int fromIndex, int toIndex) {
        if (!this.isEmpty()) {
            Arrays.sort(this._data, fromIndex, toIndex);
        }
    }

    public void fill(char val) {
        if (!this.isEmpty()) {
            Arrays.fill(this._data, 0, this._pos, val);
        }
    }

    public void fill(int fromIndex, int toIndex, char val) {
        if (toIndex > this._pos) {
            this.ensureCapacity(toIndex);
            this._pos = toIndex;
        }
        if (!this.isEmpty()) {
            Arrays.fill(this._data, fromIndex, toIndex, val);
        }
    }

    public int binarySearch(char value) {
        return this.binarySearch(value, 0, this._pos);
    }

    public int binarySearch(char value, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > this._pos) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            char midVal = this._data[mid];
            if (midVal < value) {
                low = mid + 1;
                continue;
            }
            if (midVal > value) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public int indexOf(char value) {
        return this.indexOf(0, value);
    }

    public int indexOf(int offset, char value) {
        for (int i = offset; i < this._pos; ++i) {
            if (this._data[i] != value) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(char value) {
        return this.lastIndexOf(this._pos, value);
    }

    public int lastIndexOf(int offset, char value) {
        int i = offset;
        while (i-- > 0) {
            if (this._data[i] != value) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(char value) {
        return this.lastIndexOf(value) >= 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("{");
        this.forEach(val -> {
            buf.append(val);
            buf.append(", ");
            return true;
        });
        buf.append("}");
        return buf.toString();
    }
}

