/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.collection;

import crazydev.common.collection.CdISortedList;
import crazydev.common.exception.programming.CdNotImplementedProgrammingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.jetbrains.annotations.Nullable;

public class CdSortedList<T>
extends ArrayList<T>
implements CdISortedList<T> {
    private final Comparator<T> comparator;
    private static final long serialVersionUID = 4418477650577223943L;

    public CdSortedList(CdSortedList<T> other) {
        super(other);
        this.comparator = other.comparator;
    }

    public CdSortedList(Comparator<T> comparator) {
        this.comparator = comparator;
    }

    public CdSortedList(Comparator<T> comparator, int size) {
        super(size);
        this.comparator = comparator;
    }

    @Override
    @Nullable
    public T last() {
        return this.isEmpty() ? null : (T)this.get(this.size() - 1);
    }

    @Override
    public boolean add(T t) {
        int val = Collections.binarySearch(this, t, this.comparator);
        if (val >= 0) {
            this.addInternal(val + 1, t);
        } else {
            this.addInternal(-val - 1, t);
        }
        return true;
    }

    @Override
    public boolean addIfMissing(T t) {
        int val = Collections.binarySearch(this, t, this.comparator);
        if (val >= 0) {
            return false;
        }
        this.addInternal(-val - 1, t);
        return true;
    }

    private int addInternal(int pos, T t) {
        while (pos < this.size() && this.comparator.compare(t, this.get(pos)) == 0) {
            ++pos;
        }
        if (pos >= this.size()) {
            super.add(t);
            return this.size() - 1;
        }
        super.add(pos, t);
        return pos;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        for (T item : c) {
            this.add(item);
        }
        return !c.isEmpty();
    }

    public boolean containsSlow(Object o) {
        return super.indexOf(o) >= 0;
    }

    @Override
    public boolean contains(Object o) {
        return Collections.binarySearch(this, o, this.comparator) >= 0;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean remove(Object o) {
        throw new CdNotImplementedProgrammingException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new CdNotImplementedProgrammingException();
    }

    @Override
    public boolean removeLastItem() {
        return !this.isEmpty() && super.remove(this.size() - 1) != null;
    }

    @Override
    public long getLongSize() {
        return this.size();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new CdNotImplementedProgrammingException();
    }

    @Override
    public int indexOf(Object o) {
        int pos = Collections.binarySearch(this, o, this.comparator);
        return pos < 0 ? -1 : pos;
    }

    public ArrayList<T> asArrayList() {
        return new ArrayList(this);
    }
}

