/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.collection;

import crazydev.common.collection.CdIIntArrayList;
import crazydev.common.system.CdRamUsageEstimator;
import java.util.function.Supplier;

public class CdRangeArrayList
implements CdIIntArrayList {
    protected static long SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf(new CdRangeArrayList(1, 1));
    final int start;
    final int end;

    public CdRangeArrayList(int start, int end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public int getInt(int idx) {
        return this.start + idx;
    }

    @Override
    public int size() {
        return this.end - this.start + 1;
    }

    @Override
    public long sizeOf() {
        return SHALLOW_SIZE_OF;
    }

    @Override
    public void trimToSize() {
    }

    @Override
    public CdIIntArrayList toMutable(Supplier<CdIIntArrayList> constructor) {
        return this.pushAllValues(constructor.get());
    }

    public String toString() {
        return "[" + this.start + ":" + this.end + "]";
    }
}

