/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.collection;

import crazydev.common.collection.CdArrays;
import crazydev.common.collection.CdIIntArrayList;
import crazydev.common.collection.CdPaginatedIntList;
import java.util.Comparator;
import java.util.RandomAccess;

public class CdPaginatedSortedIntList
extends CdPaginatedIntList
implements CdIIntArrayList,
RandomAccess {
    private static final long SHALLOW_SIZE_OF = -1L;
    private final Comparator<Integer> comparator;

    public CdPaginatedSortedIntList(Comparator<Integer> comparator) {
        this.comparator = comparator;
    }

    @Override
    public boolean add(int item) {
        int pageSize;
        if (this._size == 0) {
            super.add(item);
            return true;
        }
        int page = this.hasSinglePage() ? 0 : this.binarySearchPage(item, this.comparator);
        int[] pageArray = this._data[page];
        int pagePos = CdArrays.binarySearch(pageArray, 0, pageSize = this._pos[page], item, this.comparator);
        if (pagePos >= 0) {
            while (++pagePos < pageSize && this.comparator.compare(item, pageArray[pagePos]) == 0) {
            }
            this.insertInternal(page, pagePos, item);
        } else {
            this.insertInternal(page, -pagePos - 1, item);
        }
        return true;
    }

    public boolean contains(int o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public int indexOf(int item) {
        if (this._size == 0) {
            return -1;
        }
        return this.binarySearch(item, this.comparator);
    }

    public int binarySearch(Object key, Comparator comparator) {
        int page = this.hasSinglePage() ? 0 : this.binarySearchPage(key, comparator);
        int pagePos = CdArrays.binarySearch(this._data[page], 0, this._pos[page], key, comparator);
        if (pagePos >= 0) {
            return this._startPos[page] + pagePos;
        }
        return pagePos;
    }

    private int binarySearchPage(Object item, Comparator comparator) {
        int low = 0;
        int high = this.getLastPage();
        while (low <= high) {
            int mid = low + high >>> 1;
            int[] page = this._data[mid];
            int comp = -comparator.compare(page[this._pos[mid] - 1], item);
            if (comp == 0) {
                return this.getLastMatching(mid, item, comparator);
            }
            if (comp > 0) {
                low = mid + 1;
                continue;
            }
            comp = -comparator.compare(page[0], item);
            if (comp == 0) {
                return mid;
            }
            if (comp < 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return Math.max(0, low - 1);
    }

    private int getLastMatching(int page, Object item, Comparator comparator) {
        int[] pageArray;
        int maxPage = this.getLastPage();
        for (int lookupPage = page + 1; lookupPage <= maxPage && comparator.compare((pageArray = this._data[lookupPage])[0], item) == 0; ++lookupPage) {
            page = lookupPage;
            if (comparator.compare(pageArray[this._pos[lookupPage] - 1], item) != 0) break;
        }
        return page;
    }

    public Comparator getComparator() {
        return this.comparator;
    }
}

