/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.collection;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.system.CdRamUsageEstimator;
import java.util.Arrays;

public class CdPaginatedIntList {
    private static final int DEFAULT_CAPACITY = 64;
    private static final int DEFAULT_MAX_ARRAY_SIZE = 32768;
    private static final int DEFAULT_MULTIPLIER = 2;
    private static long SHALLOW_SIZE_OF = -1L;
    private final int default_max_array_size;
    private final int default_multiplier;
    protected int[][] _data;
    protected int[] _startPos;
    protected int[] _pos;
    protected int _size;

    public CdPaginatedIntList() {
        this(32768, 2);
    }

    public CdPaginatedIntList(int default_max_array_size, int default_multiplier) {
        this._data = new int[1][];
        this._data[0] = new int[64];
        this._startPos = new int[1];
        this._pos = new int[1];
        this.default_max_array_size = default_max_array_size;
        this.default_multiplier = default_multiplier;
        if (this.default_multiplier < 2) {
            throw new CdShouldNotBeHereProgrammingException("Algo will not work");
        }
    }

    public CdPaginatedIntList(Integer[] values) {
        int pageSize = Math.max(64, Math.min(values.length, 32768));
        int numberOfPages = values.length / pageSize + (values.length % pageSize == 0 ? 0 : 1);
        this._data = new int[numberOfPages][];
        this._startPos = new int[numberOfPages];
        this._pos = new int[numberOfPages];
        int index = 0;
        for (int pageIdx = 0; pageIdx < numberOfPages; ++pageIdx) {
            int posPage;
            this._data[pageIdx] = new int[pageIdx == numberOfPages - 1 ? Math.max(64, Integer.highestOneBit(values.length - index) << 1) : pageSize];
            int[] page = this._data[pageIdx];
            this._startPos[pageIdx] = index;
            for (posPage = 0; posPage < pageSize && index < values.length; ++posPage, ++index) {
                page[posPage] = values[index];
            }
            this._pos[pageIdx] = posPage;
        }
        this._size = values.length;
        this.default_max_array_size = 32768;
        this.default_multiplier = 2;
    }

    public long sizeOf() {
        long size;
        long l = size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf(this));
        if (this._data != null) {
            size += CdRamUsageEstimator.shallowSizeOf((Object[])this._data);
            for (int[] data : this._data) {
                if (data == null) continue;
                size += CdRamUsageEstimator.sizeOf(data);
            }
        }
        if (this._startPos != null) {
            size += CdRamUsageEstimator.sizeOf(this._startPos);
        }
        if (this._pos != null) {
            size += CdRamUsageEstimator.sizeOf(this._pos);
        }
        return size;
    }

    public void insert(int offset, int value) {
        if (offset >= this._size) {
            if (offset == this._size) {
                this.add(value);
                return;
            }
            throw new RuntimeException();
        }
        int page = this.getPage(offset);
        page = this.ensureCapacity(page, this._pos[page] + 1, offset);
        int arraySize = this._pos[page];
        int[] hitArray = this._data[page];
        int offsetInArray = offset - this._startPos[page];
        System.arraycopy(hitArray, offsetInArray, hitArray, offsetInArray + 1, arraySize - offsetInArray);
        hitArray[offsetInArray] = value;
        this._pos[page] = arraySize + 1;
        ++this._size;
        for (int i = page + 1; i < this._data.length; ++i) {
            this._startPos[i] = this._startPos[i] + 1;
        }
    }

    private int getPage(int offset) {
        int low = 0;
        int high = this._startPos.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = this._startPos[mid];
            if (midVal < (long)offset) {
                low = mid + 1;
                continue;
            }
            if (midVal > (long)offset) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return low - 1;
    }

    protected void insertInternal(int page, int offsetInArray, int value) {
        int pageOffset;
        if (page != 0 && offsetInArray == 0) {
            offsetInArray = this._pos[--page];
        }
        if ((pageOffset = this.ensureCapacityAndGetOffset(page, this._pos[page] + 1)) >= 0) {
            page = this.getPage(pageOffset + Math.max(0, offsetInArray - 1));
            offsetInArray = pageOffset + offsetInArray - this._startPos[page];
        }
        int pageSize = this._pos[page];
        int[] hitArray = this._data[page];
        System.arraycopy(hitArray, offsetInArray, hitArray, offsetInArray + 1, pageSize - offsetInArray);
        hitArray[offsetInArray] = value;
        this._pos[page] = pageSize + 1;
        ++this._size;
        int i = page + 1;
        while (i < this._pos.length) {
            int n = i++;
            this._startPos[n] = this._startPos[n] + 1;
        }
    }

    protected boolean hasSinglePage() {
        return this._pos.length == 1;
    }

    protected final int getLastPage() {
        return this._pos.length - 1;
    }

    public boolean add(int val) {
        this.ensureCapacity();
        int page = this._data.length - 1;
        this._data[page][this._pos[page]] = val;
        ++this._size;
        this._pos[page] = this._pos[page] + 1;
        return true;
    }

    public int getInt(int offset) {
        int page = this.getPage(offset);
        return this._data[page][offset - this._startPos[page]];
    }

    public int size() {
        return this._size;
    }

    public void trimToSize() {
        for (int i = 0; i < this._data.length; ++i) {
            int[] d = this._data[i];
            int actualSize = this._pos[i];
            if (d.length <= actualSize) continue;
            int[] temp = new int[actualSize];
            System.arraycopy(d, 0, temp, 0, actualSize);
            this._data[i] = temp;
        }
    }

    private void ensureCapacity() {
        this.ensureCapacity(this._data.length - 1, this._pos[this._data.length - 1] + 1, 0);
    }

    private int ensureCapacityAndGetOffset(int page, int capacity) {
        int[] _array = this._data[page];
        if (capacity > _array.length) {
            if (capacity > this.default_max_array_size) {
                int index = this._startPos[page];
                this.addPage(page);
                return index;
            }
            int newCap = Math.min(this.default_max_array_size, Math.max(_array.length << 1, capacity));
            int[] tmp = new int[newCap];
            System.arraycopy(_array, 0, tmp, 0, _array.length);
            this._data[page] = tmp;
        }
        return -1;
    }

    private int ensureCapacity(int page, int capacity, int offset) {
        int[] _array = this._data[page];
        if (capacity > _array.length) {
            if (capacity > this.default_max_array_size) {
                this.addPage(page);
                return this.getPage(offset);
            }
            int newCap = Math.min(this.default_max_array_size, Math.max(_array.length << 1, capacity));
            int[] tmp = new int[newCap];
            System.arraycopy(_array, 0, tmp, 0, _array.length);
            this._data[page] = tmp;
        }
        return page;
    }

    private void addPage(int page) {
        int newPages = this.default_multiplier - 1;
        int numPages = this._data.length + newPages;
        int[][] ndata = new int[numPages][];
        int[] nstartPos = new int[numPages];
        int[] npos = new int[numPages];
        System.arraycopy(this._data, 0, ndata, 0, page);
        System.arraycopy(this._startPos, 0, nstartPos, 0, page);
        System.arraycopy(this._pos, 0, npos, 0, page);
        int start = page + 1;
        int nstart = start + newPages;
        int end = this._data.length - start;
        System.arraycopy(this._data, start, ndata, nstart, end);
        System.arraycopy(this._startPos, start, nstartPos, nstart, end);
        System.arraycopy(this._pos, start, npos, nstart, end);
        start = 0;
        int sourceSize = this._pos[page];
        int sourceBlockSize = 1 + sourceSize / (newPages + 1);
        int startPos = this._startPos[page];
        for (int i = page; i < page + newPages + 1; ++i) {
            int size = Math.min(sourceBlockSize, sourceSize);
            if (i == page) {
                ndata[i] = this._data[page];
            } else {
                ndata[i] = new int[this.default_max_array_size];
                System.arraycopy(this._data[page], start, ndata[i], 0, Math.min(this.default_max_array_size, size));
            }
            npos[i] = size;
            nstartPos[i] = startPos;
            startPos += size;
            start += size;
            sourceSize -= size;
        }
        Arrays.fill(this._data[page], sourceBlockSize, this._pos[page], 0);
        if (sourceSize != 0) {
            throw new RuntimeException();
        }
        this._data = ndata;
        this._pos = npos;
        this._startPos = nstartPos;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }
}

