/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.collection;

import crazydev.common.system.CdRamUsageEstimator;
import crazydev.common.utils.CdIntConsumer;

public abstract class CdObject2IntHollowMap<T> {
    protected static final int defRetValue = -1;
    static final int DEFAULT_INITIAL_SIZE = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final float FAST_LOAD_FACTOR = 0.5f;
    static final float VERY_FAST_LOAD_FACTOR = 0.25f;
    private static final int INT_PHI = -1640531527;
    private static long SHALLOW_SIZE_OF = -1L;
    protected final transient int minN;
    protected final float f;
    protected transient int[] key;
    protected transient int mask;
    protected transient boolean containsNullKey;
    protected transient int n;
    protected transient int maxFill;
    protected int size;

    public CdObject2IntHollowMap(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.minN = this.n = CdObject2IntHollowMap.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = CdObject2IntHollowMap.maxFill(this.n, f);
        this.key = new int[this.n + 1];
    }

    public CdObject2IntHollowMap() {
        this(16, 0.75f);
    }

    public CdObject2IntHollowMap(float f) {
        this(16, f);
    }

    public int get(T k) {
        if (this.size == 0) {
            return -1;
        }
        if (k == null) {
            return this.containsNullKey ? this.key[this.n] : -1;
        }
        int[] key = this.key;
        int pos = this.hashOnKey(k) & this.mask;
        int curr = key[pos];
        if (curr == 0) {
            return -1;
        }
        if (this._equals(k, curr)) {
            return key[pos] - 1;
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != 0) continue;
            return -1;
        } while (!this._equals(k, curr));
        return key[pos] - 1;
    }

    public int put(T k, int v) {
        if (v < 0) {
            throw new IllegalArgumentException(Integer.toString(v));
        }
        int pos = this.find(k);
        if (pos < 0) {
            this.insert(-pos - 1, v + 1);
            return -1;
        }
        return this.key[pos];
    }

    public int size() {
        return this.size;
    }

    private int _hashOnKey(int idx) {
        return this.hashOnKey(idx - 1);
    }

    protected abstract int hashOnKey(int var1);

    protected abstract int hashOnKey(T var1);

    private boolean _equals(T first, int secondIdx) {
        return this.equals(first, secondIdx - 1);
    }

    protected abstract boolean equals(T var1, int var2);

    private int find(T k) {
        if (k == null) {
            return this.containsNullKey ? this.n : -(this.n + 1);
        }
        int[] key = this.key;
        int pos = this.hashOnKey(k) & this.mask;
        int curr = key[pos];
        if (curr == 0) {
            return -(pos + 1);
        }
        if (this._equals(k, curr)) {
            return pos;
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != 0) continue;
            return -(pos + 1);
        } while (!this._equals(k, curr));
        return pos;
    }

    private void insert(int pos, int v) {
        if (pos == this.n) {
            this.containsNullKey = true;
        }
        this.key[pos] = v;
        if (this.size++ >= this.maxFill) {
            this.rehash(CdObject2IntHollowMap.arraySize(this.size + 1, this.f));
        }
    }

    private void rehash(int newN) {
        int[] key = this.key;
        int mask = newN - 1;
        int[] newKey = new int[newN + 1];
        int i = this.n;
        int j = this.realSize();
        while (j-- != 0) {
            while (key[--i] == 0) {
            }
            int pos = this._hashOnKey(key[i]) & mask;
            if (newKey[pos] != 0) {
                while (newKey[pos = pos + 1 & mask] != 0) {
                }
            }
            newKey[pos] = key[i];
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = CdObject2IntHollowMap.maxFill(this.n, this.f);
        this.key = newKey;
    }

    public void forEachKey(CdIntConsumer consumer) {
        if (this.containsNullKey) {
            consumer.accept(0);
        }
        int pos = this.n;
        while (pos-- != 0) {
            int key = this.key[pos];
            if (key == 0) continue;
            consumer.accept(key - 1);
        }
    }

    private int realSize() {
        return this.containsNullKey ? this.size - 1 : this.size;
    }

    protected int secondHash(int hashcCode) {
        return CdObject2IntHollowMap.mix(hashcCode);
    }

    public boolean trim() {
        int l = CdObject2IntHollowMap.arraySize(this.size, this.f);
        if (l >= this.n || this.size > CdObject2IntHollowMap.maxFill(l, this.f)) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    private static long nextPowerOfTwo(long x) {
        if (x == 0L) {
            return 1L;
        }
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return (x | x >> 32) + 1L;
    }

    private static int arraySize(int expected, float f) {
        long s = Math.max(2L, CdObject2IntHollowMap.nextPowerOfTwo((long)Math.ceil((float)expected / f)));
        if (s > 0x40000000L) {
            throw new IllegalArgumentException("Too large (" + expected + " expected elements with load factor " + f + ")");
        }
        return (int)s;
    }

    private static int maxFill(int n, float f) {
        return Math.min((int)Math.ceil((float)n * f), n - 1);
    }

    public static int mix(int x) {
        int h = x * -1640531527;
        return h ^ h >>> 16;
    }

    public long sizeOf() {
        long size = SHALLOW_SIZE_OF != -1L ? SHALLOW_SIZE_OF : (SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf(this));
        return size += CdRamUsageEstimator.sizeOf(this.key);
    }
}

