/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.collection;

import crazydev.common.collection.CdIntEmptyArrayList;
import crazydev.common.collection.CdRangeArrayList;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.utils.CdPackedBitList;
import java.util.Comparator;
import java.util.function.Supplier;

public interface CdIIntArrayList {
    public int getInt(int var1);

    default public int set(int idx, int value) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    public int size();

    public long sizeOf();

    public void trimToSize();

    default public CdIIntArrayList toMutable(Supplier<CdIIntArrayList> constructor) {
        return this;
    }

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    default public boolean add(int value) {
        throw new CdShouldNotBeHereProgrammingException();
    }

    default public int indexOf(int value) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (this.getInt(i) != value) continue;
            return i;
        }
        return -1;
    }

    default public int binarySearch(Integer key, Comparator<Integer> c) {
        int low = 0;
        int high = this.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = this.getInt(mid);
            int cmp = c.compare(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    default public CdIIntArrayList pushAllValues(CdIIntArrayList listToAdd) {
        for (int i = 0; i < this.size(); ++i) {
            listToAdd.add(this.getInt(i));
        }
        return listToAdd;
    }

    public static CdIIntArrayList trimAndCompress(CdIIntArrayList intList) {
        int size = intList.size();
        if (size == 0) {
            return CdIntEmptyArrayList.INSTANCE;
        }
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        int former = -1;
        boolean isRange = true;
        for (int i = 0; i < size; ++i) {
            int value = intList.getInt(i);
            if (isRange && i != 0) {
                isRange = former == value - 1;
            }
            former = value;
            min = Math.min(min, value);
            max = Math.max(max, value);
        }
        if (isRange) {
            return new CdRangeArrayList(intList.getInt(0), intList.getInt(intList.size() - 1));
        }
        intList.trimToSize();
        if (CdPackedBitList.estimatedSizeBytes(size, min, max) > intList.sizeOf()) {
            return intList;
        }
        CdPackedBitList packed = new CdPackedBitList(size, min, max);
        for (int i = 0; i < size; ++i) {
            packed.set(i, intList.getInt(i));
        }
        return packed;
    }
}

