/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.collection;

import crazydev.common.collection.CdAction;
import crazydev.common.collection.CdFilter;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public abstract class CdCollections {
    private static final Comparator COMPARATOR = new ReverseComparator();

    public static void setValue(DoubleArrayList list, int pos, double value) {
        if (pos >= list.size()) {
            list.ensureCapacity(pos + 1);
            int itemsToAdd = pos - list.size() + 1;
            while (--itemsToAdd >= 0) {
                list.add(0.0);
            }
        }
        list.set(pos, value);
    }

    public static <T> void switchItems(List<T> list, int pos1, int pos2) {
        T temp = list.get(pos1);
        list.set(pos1, list.get(pos2));
        list.set(pos2, temp);
    }

    public static <T> ArrayList<T> intersects(Collection<T> left, Collection<T> right) {
        ArrayList<T> intersects = new ArrayList<T>();
        Collection<T> xleft = left.size() < right.size() ? left : right;
        Collection<T> xright = xleft == left ? right : left;
        for (T item : xleft) {
            if (!xright.contains(item)) continue;
            intersects.add(item);
        }
        return intersects;
    }

    public static <T> boolean intersect(Collection<T> left, Collection<T> right) {
        Collection<T> xleft = left.size() < right.size() ? left : right;
        Collection<T> xright = xleft == left ? right : left;
        for (T item : xleft) {
            if (!xright.contains(item)) continue;
            return true;
        }
        return false;
    }

    public static <T> void complement(Collection<T> a, Collection<T> b, Collection<T> z) {
        for (T t : b) {
            if (a.contains(t)) continue;
            z.add(t);
        }
    }

    @Nullable
    public static <T> T getLast(List<T> items) {
        if (items == null || items.isEmpty()) {
            return null;
        }
        return items.getLast();
    }

    public static boolean containsOneNull(Object ... objects) {
        if (objects != null) {
            int nullCount = 0;
            for (Object object : objects) {
                if (object != null || ++nullCount <= 1) continue;
                return false;
            }
            return nullCount == 1;
        }
        return false;
    }

    public static boolean containsNoNull(Object ... objects) {
        if (objects != null) {
            for (Object object : objects) {
                if (object != null) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static <T> ArrayList<T> filter(Iterable<T> items, CdFilter<T> filter) {
        ArrayList<T> filtered = new ArrayList<T>();
        if (items == null) {
            return filtered;
        }
        for (T item : items) {
            if (!filter.accept(item)) continue;
            filtered.add(item);
        }
        return filtered;
    }

    @Nullable
    public static <T> T findFirst(List<T> items, CdFilter<T> filter) {
        if (items == null) {
            return null;
        }
        int size = items.size();
        for (int ii = 0; ii < size; ++ii) {
            T item = items.get(ii);
            if (!filter.accept(item)) continue;
            return item;
        }
        return null;
    }

    public static <T> boolean hasElement(List<T> collection, CdFilter<T> filter) {
        return CdCollections.findFirst(collection, filter) != null;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !CdCollections.isEmpty(collection);
    }

    @Nullable(value="if no duplicates found")
    public static <T> @Nullable(value="if no duplicates found") T findFirstDuplicate(List<T> items) {
        if (items == null) {
            return null;
        }
        HashSet<T> set = new HashSet<T>();
        for (T item : items) {
            if (set.add(item)) continue;
            return item;
        }
        return null;
    }

    public static <T> void apply(List<T> items, CdAction<T> action) {
        if (items == null) {
            return;
        }
        for (int i = 0; i < items.size(); ++i) {
            T item = items.get(i);
            action.apply(item);
        }
    }

    public static <T> void apply(Iterable<T> items, CdAction<T> action) {
        if (items == null) {
            return;
        }
        for (T item : items) {
            action.apply(item);
        }
    }

    public static void shrinkTo(List<?> items, int newSize) {
        int deleteCount = items.size() - newSize;
        if (deleteCount <= 0 || newSize < 0) {
            return;
        }
        if (newSize == 0) {
            items.clear();
        } else {
            for (int i = 0; i < deleteCount; ++i) {
                items.remove(items.size() - 1);
            }
        }
    }

    public static void shrinkTo(IntArrayList items, int newSize) {
        int deleteCount = items.size() - newSize;
        if (deleteCount <= 0 || newSize < 0) {
            return;
        }
        if (newSize == 0) {
            items.clear();
        } else {
            items.removeElements(newSize, newSize + deleteCount);
        }
    }

    public static <A, B> void add(Map<A, List<B>> map, A key, B value) {
        List<B> list = map.get(key);
        if (list == null) {
            list = new ArrayList<B>();
            map.put(key, list);
        }
        list.add(value);
    }

    @Nullable
    public static <T> T last(List<T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.getLast();
    }

    @Nullable
    public static <T> T first(List<T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.getFirst();
    }

    @Nullable
    public static <T> T first(Collection<T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.iterator().next();
    }

    public static <T> T firstNotNull(Collection<T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (T t : list) {
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public static <T> String toString(@Nullable Collection<T> items, String quote) {
        return CdCollections.toString(items, quote, ", ");
    }

    public static <T> String toString(@Nullable Collection<T> items, String quote, String separator) {
        return CdCollections.toString(items, quote, separator, DefaultStringfier.INST);
    }

    public static <T> String toString(@Nullable Collection<T> items, String quote, String separator, Stringfier<T> stringfier) {
        if (items == null) {
            return "NULL";
        }
        StringBuilder builder = new StringBuilder();
        for (T item : items) {
            if (builder.length() != 0) {
                builder.append(separator);
            }
            if (item == null) {
                builder.append("NULL");
                continue;
            }
            builder.append(quote);
            builder.append(stringfier.toString(item));
            builder.append(quote);
        }
        return builder.toString();
    }

    public static <T> void addIfNotNull(List<T> columns, @Nullable T item) {
        if (item != null) {
            columns.add(item);
        }
    }

    public static <T> int rangeIndexOf(List<? extends Comparable<T>> rangedList, T position, boolean isAsc) {
        if (isAsc) {
            int pos = Collections.binarySearch(rangedList, position);
            int memberPos = pos >= 0 ? pos : Math.min(rangedList.size() - 1, Math.max(0, -2 - pos));
            return memberPos;
        }
        int pos = Collections.binarySearch(rangedList, position, CdCollections.reverseOrder());
        int memberPos = pos >= 0 ? pos : Math.min(rangedList.size() - 1, Math.max(0, -1 - pos));
        return memberPos;
    }

    public static <T> boolean allEquals(List<T> items) {
        T formerItem = items.get(0);
        for (int i = 1; i < items.size(); ++i) {
            T item = items.get(i);
            if (formerItem == null ? item != null : !item.equals(formerItem)) {
                return false;
            }
            formerItem = item;
        }
        return true;
    }

    public static <T> List<T> minus(List<T> list, T ... items) {
        if (items == null || items.length == 0) {
            return list;
        }
        ArrayList<T> newList = new ArrayList<T>(list);
        for (T item : items) {
            newList.remove(item);
        }
        return newList.size() == list.size() ? list : newList;
    }

    @Nullable
    public static <T> T firstNotNull(List<T> partitions) {
        for (int i = 0; i < partitions.size(); ++i) {
            T t = partitions.get(i);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public static <T> boolean containsIdentity(List<T> vGeneratedColumns, T column) {
        for (int i = 0; i < vGeneratedColumns.size(); ++i) {
            if (column != vGeneratedColumns.get(i)) continue;
            return true;
        }
        return false;
    }

    public static <T> Comparator<T> reverseOrder() {
        return COMPARATOR;
    }

    public static void subListRangeCheck(int fromIndex, int toIndex, int size) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > size) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
    }

    public static boolean hasDuplicate(Collection collection) {
        HashSet items = new HashSet();
        for (Object item : collection) {
            if (items.add(item)) continue;
            return true;
        }
        return false;
    }

    public static <T> T getSafe(List<T> list, int idx, @Nullable T outofBounds) {
        if (idx < 0 || idx >= list.size()) {
            return outofBounds;
        }
        return list.get(idx);
    }

    public static <T> boolean matchesForAll(Stream<T> stream, Predicate<? super T> matches) {
        Optional<Object> found = stream.filter(t -> !matches.test(t)).findFirst();
        return !found.isPresent();
    }

    public static <T> T[] copy(Iterable<T> collection, T[] array) {
        int maxSize = array.length;
        int i = 0;
        for (T t : collection) {
            if (i >= maxSize) break;
            array[i++] = t;
        }
        return array;
    }

    public static <T> ArrayList<T> list(Iterable<T> iterable) {
        ArrayList<T> list = new ArrayList<T>();
        for (T t : iterable) {
            list.add(t);
        }
        return list;
    }

    public static <T> boolean emptyOrWithNulls(@Nullable List<T> list) {
        return CdCollections.isEmpty(list) || CdCollections.first(list) == null && CdCollections.allEquals(list);
    }

    public static <T> Collection<T> join(List<T> list, T newElements) {
        ArrayList<T> newList = new ArrayList<T>(list);
        newList.add(newElements);
        return newList;
    }

    private static class DefaultStringfier<T>
    implements Stringfier<T> {
        static final Stringfier INST = new DefaultStringfier();

        private DefaultStringfier() {
        }

        @Override
        public String toString(T t) {
            return t == null ? "NULL" : t.toString();
        }
    }

    public static interface Stringfier<T> {
        public String toString(T var1);
    }

    private static class ReverseComparator<T>
    implements Comparator<Comparable<Object>>,
    Serializable {
        private ReverseComparator() {
        }

        @Override
        public int compare(Comparable<Object> c1, Comparable<Object> c2) {
            return -c1.compareTo(c2);
        }
    }
}

