/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.collection;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class CdArrays {
    public static String toString(double[][] a) {
        if (a == null) {
            return "null";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(Arrays.toString(a[i]));
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static String toString(double[][] a, int maxSize) {
        if (a == null) {
            return "null";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            if (b.length() >= maxSize) {
                b.append("...");
                i = iMax;
            } else {
                b.append(CdArrays.toString(a[i], maxSize));
            }
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static String toString(double[] a, int maxSize) {
        if (a == null) {
            return "null";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            if (b.length() >= maxSize) {
                b.append("...");
                i = iMax;
            } else {
                b.append(a[i]);
            }
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static String toString(Object[] a, int maxSize) {
        if (a == null) {
            return "null";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            if (b.length() >= maxSize) {
                b.append("...");
                i = iMax;
            } else {
                b.append(a[i]);
            }
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static <T> boolean contains(T option, T ... options) {
        if (options == null) {
            return false;
        }
        for (T item : options) {
            if (!item.equals(option)) continue;
            return true;
        }
        return false;
    }

    public static <T> T[] concat(@Nullable T[] a, T[] b) {
        if (a == null) {
            return b;
        }
        int alen = a.length;
        int blen = b.length;
        Object[] result = (Object[])Array.newInstance(a.getClass().getComponentType(), alen + blen);
        System.arraycopy(a, 0, result, 0, alen);
        System.arraycopy(b, 0, result, alen, blen);
        return result;
    }

    public static int compareTo(Comparable[] a, Comparable[] b) {
        for (int i = 0; i < a.length && i < b.length; ++i) {
            Comparable va = a[i];
            Comparable vb = b[i];
            int comp = va.compareTo(vb);
            if (comp == 0) continue;
            return comp;
        }
        return 0;
    }

    public static double[][] copy(double[][] from) {
        double[][] newPages = new double[from.length][];
        for (int idx = 0; idx < from.length; ++idx) {
            double[] fromPage = from[idx];
            double[] newPage = new double[fromPage.length];
            System.arraycopy(fromPage, 0, newPage, 0, fromPage.length);
            newPages[idx] = newPage;
        }
        return newPages;
    }

    public static float[][] copy(float[][] from) {
        float[][] newPages = new float[from.length][];
        for (int idx = 0; idx < from.length; ++idx) {
            float[] fromPage = from[idx];
            float[] newPage = new float[fromPage.length];
            System.arraycopy(fromPage, 0, newPage, 0, fromPage.length);
            newPages[idx] = newPage;
        }
        return newPages;
    }

    public static double[][] convertToDouble(long[][] from) {
        double[][] newPages = new double[from.length][];
        for (int idx = 0; idx < from.length; ++idx) {
            long[] fromPage = from[idx];
            double[] newPage = new double[fromPage.length];
            for (int pIdx = 0; pIdx < fromPage.length; ++pIdx) {
                newPage[pIdx] = fromPage[pIdx];
            }
            newPages[idx] = newPage;
        }
        return newPages;
    }

    public static double[][] convertToDouble(short[][] from) {
        double[][] newPages = new double[from.length][];
        for (int idx = 0; idx < from.length; ++idx) {
            short[] fromPage = from[idx];
            double[] newPage = new double[fromPage.length];
            for (int pIdx = 0; pIdx < fromPage.length; ++pIdx) {
                newPage[pIdx] = fromPage[pIdx];
            }
            newPages[idx] = newPage;
        }
        return newPages;
    }

    public static double[][] convertToDouble(int[][] from) {
        double[][] newPages = new double[from.length][];
        for (int idx = 0; idx < from.length; ++idx) {
            int[] fromPage = from[idx];
            double[] newPage = new double[fromPage.length];
            for (int pIdx = 0; pIdx < fromPage.length; ++pIdx) {
                newPage[pIdx] = fromPage[pIdx];
            }
            newPages[idx] = newPage;
        }
        return newPages;
    }

    public static float[][] convertToFloat(long[][] from) {
        float[][] newPages = new float[from.length][];
        for (int idx = 0; idx < from.length; ++idx) {
            long[] fromPage = from[idx];
            float[] newPage = new float[fromPage.length];
            for (int pIdx = 0; pIdx < fromPage.length; ++pIdx) {
                newPage[pIdx] = fromPage[pIdx];
            }
            newPages[idx] = newPage;
        }
        return newPages;
    }

    public static float[][] convertToFloat(int[][] from) {
        float[][] newPages = new float[from.length][];
        for (int idx = 0; idx < from.length; ++idx) {
            int[] fromPage = from[idx];
            float[] newPage = new float[fromPage.length];
            for (int pIdx = 0; pIdx < fromPage.length; ++pIdx) {
                newPage[pIdx] = fromPage[pIdx];
            }
            newPages[idx] = newPage;
        }
        return newPages;
    }

    public static float[][] convertToFloat(short[][] from) {
        float[][] newPages = new float[from.length][];
        for (int idx = 0; idx < from.length; ++idx) {
            short[] fromPage = from[idx];
            float[] newPage = new float[fromPage.length];
            for (int pIdx = 0; pIdx < fromPage.length; ++pIdx) {
                newPage[pIdx] = fromPage[pIdx];
            }
            newPages[idx] = newPage;
        }
        return newPages;
    }

    public static float[][] convertToFloat(double[][] from) {
        float[][] newPages = new float[from.length][];
        for (int idx = 0; idx < from.length; ++idx) {
            double[] fromPage = from[idx];
            float[] newPage = new float[fromPage.length];
            for (int pIdx = 0; pIdx < fromPage.length; ++pIdx) {
                newPage[pIdx] = (float)fromPage[pIdx];
            }
            newPages[idx] = newPage;
        }
        return newPages;
    }

    public static int compareTo(byte[] a, byte[] b) {
        int comp = 0;
        for (int i = 0; i < a.length && i < b.length; ++i) {
            if (b.length > i) {
                comp = a[i] - b[i];
                if (comp == 0) continue;
                return comp;
            }
            return -1;
        }
        return a.length == b.length ? 0 : b.length - a.length;
    }

    public static <T> void swap(T[] array, int one, int two) {
        T temp = array[one];
        array[one] = array[two];
        array[two] = temp;
    }

    public static void swap(int[] array, int one, int two) {
        int temp = array[one];
        array[one] = array[two];
        array[two] = temp;
    }

    public static boolean equals(double[][] left, double[][] right) {
        if (left == null || right == null || left.length != right.length) {
            return left == right;
        }
        for (int i = 0; i < left.length; ++i) {
            double[] leftArray = left[i];
            double[] rightArray = right[i];
            if (Arrays.equals(leftArray, rightArray)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean equals(@Nullable List<T> left, @Nullable List<T> right) {
        if (left == null || right == null || left == right) {
            return left == right;
        }
        int size = left.size();
        if (size != right.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (left.get(i).equals(right.get(i))) continue;
            return false;
        }
        return true;
    }

    public static int[] sortedBubblePositions(int size, IntComparator comparator) {
        int i;
        int[] array = new int[size];
        for (i = 0; i < array.length; ++i) {
            array[i] = i;
        }
        for (i = 0; i < size; ++i) {
            for (int j = i; j > 0 && comparator.compare(array[j - 1], array[j]) > 0; --j) {
                CdArrays.swap(array, j, j - 1);
            }
        }
        return array;
    }

    public static int indexOf(int[] array, int value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static <T> int indexOf(T[] array, T value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(double[] array, double value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public static <T> void forEach(@Nullable T[] array, Consumer<T> consumer) {
        if (array == null || consumer == null) {
            return;
        }
        for (int i = 0; i < array.length; ++i) {
            T t = array[i];
            consumer.accept(t);
        }
    }

    public static <T> List<T> asList(T[] t) {
        return t == null ? Collections.emptyList() : Arrays.asList(t);
    }

    @Nullable
    public static <T> T getNullable(T[] array, int idx) {
        return idx < 0 || idx >= array.length ? null : (T)array[idx];
    }

    public static int binarySearch(int[] a, int fromIndex, int toIndex, Object key, Comparator c) {
        if (c == null) {
            throw new CdShouldNotBeHereProgrammingException();
        }
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = a[mid];
            int cmp = c.compare(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @FunctionalInterface
    public static interface IntComparator {
        public int compare(int var1, int var2);
    }
}

