/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.cache;

import crazydev.common.cache.CdLRUCacheI;
import crazydev.common.cache.CdLRUCacheListener;
import org.jetbrains.annotations.Nullable;

class CdLRUCacheWithListener<KEY, VALUE>
implements CdLRUCacheI<KEY, VALUE> {
    private final CdLRUCacheListener listener;
    private final CdLRUCacheI<KEY, VALUE> cache;
    private long nil;
    private long prevHit;
    private long hit;
    private long miss;

    public CdLRUCacheWithListener(CdLRUCacheListener listener, CdLRUCacheI<KEY, VALUE> cache) {
        this.listener = listener;
        this.cache = cache;
    }

    @Override
    public String getTypeInfo() {
        return this.cache.getTypeInfo();
    }

    @Override
    public void nil() {
        ++this.nil;
    }

    @Override
    public void put(KEY key, VALUE value) {
        this.cache.put(key, value);
    }

    @Override
    @Nullable
    public VALUE get(KEY key) {
        VALUE value = this.cache.get(key);
        if (value != null) {
            ++this.hit;
        } else {
            ++this.miss;
        }
        return value;
    }

    @Override
    public void putPrev(KEY key, VALUE value) {
        this.cache.putPrev(key, value);
    }

    @Override
    @Nullable
    public VALUE getPrev(KEY key) {
        VALUE value = this.cache.getPrev(key);
        if (value != null) {
            ++this.prevHit;
        }
        return value;
    }

    @Override
    public void onProcessingCompleted() {
        this.listener.onNil(this.nil);
        this.listener.onPrevHit(this.prevHit);
        this.listener.onHit(this.hit);
        this.listener.onMiss(this.miss);
        this.cache.onProcessingCompleted();
    }

    public String toString() {
        return "listening(" + this.cache.toString() + ")";
    }
}

