/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.cache;

import crazydev.common.cache.CdLRUCache;
import crazydev.common.cache.CdLRUCacheI;
import crazydev.common.cache.CdLRUCacheListener;
import crazydev.common.cache.CdLRUCacheWithListener;
import crazydev.common.cache.CdLRUCacheWithoutLRU;
import org.jetbrains.annotations.Nullable;

public abstract class CdLRUCacheHelper {
    public static <KEY, VALUE> CdLRUCacheI<KEY, VALUE> create(int maxSize) {
        return CdLRUCacheHelper.create(false, maxSize, null);
    }

    public static <KEY, VALUE> CdLRUCacheI<KEY, VALUE> create(boolean withLT, int maxSize, @Nullable CdLRUCacheListener listener) {
        CdLRUCache cache = new CdLRUCache(maxSize);
        if (listener == null) {
            return cache;
        }
        return new CdLRUCacheWithListener(listener, cache);
    }

    public static <KEY, VALUE> CdLRUCacheI<KEY, VALUE> createWithoutLRU(boolean withLT, int lruMaxSize, int expectedMaxSize, @Nullable CdLRUCacheListener listener) {
        CdLRUCacheWithoutLRU cache = new CdLRUCacheWithoutLRU(lruMaxSize, expectedMaxSize);
        if (listener == null) {
            return cache;
        }
        return new CdLRUCacheWithListener(listener, cache);
    }
}

