/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.model.message.execute;

import crazydev.xmla.model.message.XmlaParameter;
import crazydev.xmla.model.message.XmlaProperty;
import crazydev.xmla.model.message.XmlaQuery;
import crazydev.xmla.model.message.XmlaQueryKind;
import crazydev.xmla.model.message.execute.XmlaStatementCommandQuery;
import crazydev.xmla.model.message.property.XmlaCatalogProperty;
import crazydev.xmla.model.types.XmlaFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class XmlaMdxStatementCommandQuery
extends XmlaStatementCommandQuery {
    private final List<XmlaParameter> parameters;

    public XmlaMdxStatementCommandQuery(String uuid, String sessionId, String statement, List<XmlaProperty> properties) {
        this(uuid, sessionId, statement, properties, Collections.emptyList());
    }

    public XmlaMdxStatementCommandQuery(String uuid, String sessionId, String statement, List<XmlaProperty> properties, List<XmlaParameter> parameters) {
        super(uuid, sessionId, XmlaMdxStatementCommandQuery.changeParams(statement, parameters), properties);
        this.parameters = parameters;
    }

    public XmlaMdxStatementCommandQuery(XmlaMdxStatementCommandQuery that, @Nullable String newSessionId, @Nullable String newSchemaName, @Nullable String newStatement) {
        super(that, newSessionId, newSchemaName, newStatement);
        this.parameters = new ArrayList<XmlaParameter>();
        for (XmlaParameter thatParameter : that.parameters) {
            this.parameters.add(new XmlaParameter(thatParameter));
        }
    }

    private static String changeParams(String statement, List<XmlaParameter> parameters) {
        for (XmlaParameter parameter : parameters) {
            statement = parameter.replace(statement);
        }
        return statement;
    }

    @Override
    public XmlaQuery duplicateForLoadTesting(@Nullable String newSessionId, @Nullable String newSchemaName, @Nullable String newSchemaDefinition, @Nullable String newStatement) {
        return new XmlaMdxStatementCommandQuery(this, newSessionId, newSchemaName, newStatement);
    }

    @Override
    protected XmlaFormat getActualFormatForNative() {
        return XmlaFormat.Multidimensional;
    }

    @Override
    public boolean isMdxStatement() {
        return true;
    }

    @Override
    public String getMdxForCancelReport() {
        return this.statement;
    }

    @Override
    public XmlaQueryKind getKind() {
        return XmlaQueryKind.MDX;
    }

    @Override
    public String getUserFriendlyTypeName() {
        return "XMLA Execute MDX";
    }

    @Override
    public boolean isMonitored() {
        return true;
    }

    @Override
    public void fixMissingCatalog(Supplier<String> firstAuthorizedSchemaName) {
        String initialCatalog;
        String catalog = this.getCatalog();
        if (catalog == null && (initialCatalog = firstAuthorizedSchemaName.get()) != null) {
            this.addProperties(new XmlaCatalogProperty(initialCatalog));
        }
    }
}

