/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.model.message.execute;

import crazydev.xmla.model.message.XmlaProperty;
import crazydev.xmla.model.message.XmlaQuery;
import crazydev.xmla.model.message.XmlaQueryKind;
import crazydev.xmla.model.message.execute.XmlaSchemaManagementStatementCommandQuery;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class XmlaFullLoadSchemaStatementCommandQuery
extends XmlaSchemaManagementStatementCommandQuery {
    public static final String NAME = "FULL_LOAD_SCHEMA";
    private final XmlaSchemaManagementStatementCommandQuery.OfflineMode offlineMode;
    @Nullable
    private final String offlineSnapshot;
    @Nullable
    private final String schemaFactoryFileName;
    private final boolean forceBackupOn;

    public XmlaFullLoadSchemaStatementCommandQuery(String uuid, String sessionId, String statement, XmlaSchemaManagementStatementCommandQuery.OfflineMode offlineMode, @Nullable String offlineSnapshot, String schema, @Nullable String schemaFactoryFileName, boolean forceBackupOn, int waitS, int cancelS, List<XmlaProperty> properties) {
        super(uuid, sessionId, statement, schema, waitS, cancelS, properties);
        this.offlineMode = offlineMode;
        this.offlineSnapshot = offlineSnapshot;
        this.schemaFactoryFileName = schemaFactoryFileName;
        this.forceBackupOn = forceBackupOn;
    }

    private XmlaFullLoadSchemaStatementCommandQuery(XmlaFullLoadSchemaStatementCommandQuery that, @Nullable String newSessionId, @Nullable String newSchemaName, @Nullable String newStatement) {
        super(that, newSessionId, newSchemaName, newStatement);
        this.offlineMode = XmlaSchemaManagementStatementCommandQuery.OfflineMode.OFF;
        this.offlineSnapshot = null;
        this.schemaFactoryFileName = that.schemaFactoryFileName;
        this.forceBackupOn = that.forceBackupOn;
    }

    @Override
    public XmlaQuery duplicateForLoadTesting(@Nullable String newSessionId, @Nullable String newSchemaName, @Nullable String newSchemaDefinition, @Nullable String newStatement) {
        return new XmlaFullLoadSchemaStatementCommandQuery(this, newSessionId, newSchemaName, newStatement);
    }

    @Override
    public boolean isSchemaLifeCycle() {
        return true;
    }

    @Override
    public boolean isLoadSchema() {
        return true;
    }

    @Override
    public boolean isFullLoadSchema() {
        return true;
    }

    @Override
    public boolean isLoadSchemaWithOffline() {
        return this.offlineMode != null && this.offlineMode.isActive();
    }

    public boolean isForceBackupOn() {
        return this.forceBackupOn;
    }

    public XmlaSchemaManagementStatementCommandQuery.OfflineMode getOfflineMode() {
        return this.offlineMode;
    }

    @Override
    @Nullable
    public String getOfflineSnapshot() {
        return this.offlineSnapshot;
    }

    @Override
    @Nullable
    public String getSchemaFactoryFileName() {
        return this.schemaFactoryFileName;
    }

    @Override
    public boolean isSchemaWrite() {
        return true;
    }

    @Override
    public XmlaQueryKind getKind() {
        return XmlaQueryKind.LOAD;
    }

    @Override
    public String getUserFriendlyTypeName() {
        return "XMLA FULL_LOAD_SCHEMA";
    }

    @Override
    public boolean isMonitored() {
        return true;
    }

    @Override
    public String toString() {
        return "FULL_LOAD_SCHEMA " + this.schema;
    }
}

