/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.model.message.execute;

import crazydev.common.exception.CdRuntimeException;
import crazydev.common.mdx.scanner.CdMdxScanner;
import crazydev.common.mdx.scanner.CdMdxToken;
import crazydev.common.mdx.scanner.CdMdxTokenKind;
import crazydev.common.mdx.scanner.exception.CdMdxScannerException;
import crazydev.common.mdx.scanner.token.CdMdxDelimitedIdentifierToken;
import crazydev.common.mdx.scanner.token.CdMdxKeywordToken;
import crazydev.common.mdx.scanner.token.CdMdxNumberToken;
import crazydev.common.mdx.scanner.token.CdMdxRegularIdentifierToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class XmlaCommandArguments {
    private final String command;
    private final List<String> rawArgs = new ArrayList<String>();
    private final int rawArgsRange;

    public XmlaCommandArguments(String command, String statement) {
        this.command = command;
        String arguments = statement.trim().substring(command.length()).trim();
        if (arguments.isEmpty()) {
            this.rawArgsRange = -1;
            return;
        }
        try {
            CdMdxScanner scanner = new CdMdxScanner();
            List tokens = scanner.scan(arguments, "?");
            int rangePos = -1;
            for (CdMdxToken token : tokens) {
                if (token.isInvisible()) continue;
                if (token.getKind() == CdMdxTokenKind.RANGE && rangePos == -1) {
                    rangePos = this.rawArgs.size();
                    continue;
                }
                if (token instanceof CdMdxRegularIdentifierToken) {
                    this.rawArgs.add(((CdMdxRegularIdentifierToken)token).getIdentifier());
                    continue;
                }
                if (token instanceof CdMdxDelimitedIdentifierToken) {
                    this.rawArgs.add(((CdMdxDelimitedIdentifierToken)token).getIdentifier());
                    continue;
                }
                if (token instanceof CdMdxNumberToken || token instanceof CdMdxKeywordToken) {
                    this.rawArgs.add(token.getLexeme());
                    continue;
                }
                String error = command + ": illegal argument (pos:" + token.getStartOffset() + ") " + token.getLexeme();
                throw new CdRuntimeException(error);
            }
            this.rawArgsRange = rangePos;
        }
        catch (CdMdxScannerException ex) {
            throw new CdRuntimeException((Throwable)ex, command + ": error " + ex.getMessage());
        }
    }

    protected XmlaCommandArguments(String command, List<String> rawArgs, int rawArgsRange) {
        this.command = command;
        this.rawArgs.addAll(rawArgs);
        this.rawArgsRange = rawArgsRange;
    }

    public static XmlaCommandArguments createForLoadPartitions(String command, String statement) {
        String arguments = statement.trim().substring(command.length()).trim();
        if (arguments.isEmpty()) {
            return new XmlaCommandArguments(command, Collections.emptyList(), -1);
        }
        try {
            ArrayList<String> rawArgs = new ArrayList<String>();
            CdMdxScanner scanner = new CdMdxScanner();
            List tokens = scanner.scan(arguments, "?");
            for (CdMdxToken token : tokens) {
                if (token.isInvisible()) continue;
                if (token.getKind() == CdMdxTokenKind.RANGE) {
                    rawArgs.add(token.getLexeme());
                    continue;
                }
                if (token instanceof CdMdxRegularIdentifierToken) {
                    rawArgs.add(((CdMdxRegularIdentifierToken)token).getIdentifier());
                    continue;
                }
                if (token instanceof CdMdxDelimitedIdentifierToken) {
                    rawArgs.add(((CdMdxDelimitedIdentifierToken)token).getIdentifier());
                    continue;
                }
                if (token instanceof CdMdxNumberToken || token instanceof CdMdxKeywordToken) {
                    rawArgs.add(token.getLexeme());
                    continue;
                }
                String error = command + ": illegal argument (pos:" + token.getStartOffset() + ") " + token.getLexeme();
                throw new CdRuntimeException(error);
            }
            return new XmlaCommandArguments(command, rawArgs, -1);
        }
        catch (CdMdxScannerException ex) {
            throw new CdRuntimeException((Throwable)ex, command + ": error " + ex.getMessage());
        }
    }

    public boolean isEmpty() {
        return this.rawArgs.isEmpty();
    }

    public int size() {
        return this.rawArgs.size();
    }

    public String get(int argPos) {
        return this.rawArgs.get(argPos);
    }

    public String get(String argName, int argPos) {
        if (argPos >= this.rawArgs.size()) {
            throw new CdRuntimeException(this.command + ": missing parameter [name:" + argName + "]");
        }
        return this.rawArgs.get(argPos);
    }

    public boolean hasByName(String name) {
        for (String rawArg : this.rawArgs) {
            if (!rawArg.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Integer getByNameOptionalInt(String name) {
        for (String rawArg : this.rawArgs) {
            String prefix = name.toUpperCase() + ":";
            if (!rawArg.toUpperCase().startsWith(prefix)) continue;
            String valueS = rawArg.substring(prefix.length());
            int value = Integer.parseInt(valueS);
            return value;
        }
        return null;
    }

    public List<String> getAsList(String argName, int argPos) {
        if (argPos >= this.rawArgs.size()) {
            throw new CdRuntimeException(this.command + ": missing parameter [name:" + argName + "]");
        }
        List<String> args = this.rawArgs.subList(argPos, this.rawArgs.size());
        if (this.rawArgsRange != -1 && (args.size() != 2 || this.rawArgsRange != argPos + 1)) {
            throw new CdRuntimeException(this.command + ": range parameter [name:" + argName + "] type mismatch");
        }
        return args;
    }

    public boolean isRange() {
        return this.rawArgsRange != -1;
    }
}

