/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.model.message;

import crazydev.common.locale.CdLanguageIdentifier;
import crazydev.xmla.model.message.XmlaProperty;
import crazydev.xmla.model.message.property.XmlaContentProperty;
import crazydev.xmla.model.message.property.XmlaDbpropMsmdFlattened2Property;
import crazydev.xmla.model.message.property.XmlaExecutionModeProperty;
import crazydev.xmla.model.message.property.XmlaFormatProperty;
import crazydev.xmla.model.message.property.XmlaLocaleIdentifierProperty;
import crazydev.xmla.model.message.property.XmlaUntypedProperty;
import crazydev.xmla.model.message.property.XmlaVisualModeProperty;
import crazydev.xmla.model.types.XmlaContent;
import crazydev.xmla.model.types.XmlaExecutionMode;
import crazydev.xmla.model.types.XmlaFormat;
import crazydev.xmla.model.types.XmlaVisualMode;
import org.apache.log4j.Logger;

public abstract class XmlaPropertyParser {
    public static final Logger LOGGER = Logger.getLogger((String)"icCube.xmla.request");

    protected static XmlaProperty parseProperty(String name, String value) {
        XmlaProperty property;
        if ("Content".equals(name)) {
            property = new XmlaContentProperty(XmlaContent.valueOf(value));
        } else if ("Format".equals(name)) {
            property = new XmlaFormatProperty(XmlaFormat.valueOf(value));
        } else if ("VisualMode".equals(name)) {
            property = "1".equals(value) ? new XmlaVisualModeProperty(XmlaVisualMode.VISUAL_TOTAL) : ("2".equals(value) ? new XmlaVisualModeProperty(XmlaVisualMode.NON_VISUAL_TOTAL) : new XmlaUntypedProperty(name, value));
        } else if ("LocaleIdentifier".equals(name)) {
            CdLanguageIdentifier id = null;
            try {
                int valueAsInt = Integer.valueOf(value);
                id = CdLanguageIdentifier.fromPosition((int)valueAsInt);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (id != null) {
                property = new XmlaLocaleIdentifierProperty(id);
            } else {
                LOGGER.warn((Object)("Unsupported XMLA LocaleIdentifier [" + value + "] reverting to Neutral (i.e., MDX engine locale)"));
                property = new XmlaLocaleIdentifierProperty(CdLanguageIdentifier.Neutral);
            }
        } else {
            property = "DbpropMsmdFlattened2".equals(name) ? new XmlaDbpropMsmdFlattened2Property(Boolean.valueOf(value)) : ("ExecutionMode".equals(name) ? new XmlaExecutionModeProperty(XmlaExecutionMode.valueOf(value)) : new XmlaUntypedProperty(name, value));
        }
        return property;
    }
}

