/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.model.discover.bean;

import crazydev.xmla.model.discover.IXmlaDiscoverXmlMetaData;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

@XmlRootElement(name="row")
public class XmlaDiscoverXmlMetaDataBean
implements IXmlaDiscoverXmlMetaData {
    public static final Logger XMLA_REQUEST = Logger.getLogger((String)"icCube.xmla.request");
    @XmlElement(name="METADATA")
    private String metaData;

    private XmlaDiscoverXmlMetaDataBean() {
    }

    public XmlaDiscoverXmlMetaDataBean(String serverId, String version, List<String> catalogs) {
        List<String> catalogsF = this.filterForSpecialCharacter(catalogs);
        Object databases = "";
        if (!catalogs.isEmpty()) {
            databases = (String)databases + "        <Databases>";
            for (String catalog : catalogsF) {
                databases = (String)databases + "<Database><Name>" + catalog + "</Name><ID>" + catalog + "</ID></Database>";
            }
            databases = (String)databases + "</Databases>\n";
        }
        this.metaData = "<xars:METADATA xmlns=\"http://schemas.microsoft.com/analysisservices/2003/engine\"\n               xmlns:xars=\"urn:schemas-microsoft-com:xml-analysis:rowset\">\n    <Server>\n        <Name>" + serverId + "</Name>\n        <ID>" + serverId + "</ID>\n        <Version>" + version + "</Version>\n        <Edition>Developer64</Edition>\n" + (String)databases + "    </Server>\n</xars:METADATA>";
    }

    private List<String> filterForSpecialCharacter(List<String> databases) {
        try {
            String regex = "[.,;'`:/\\\\*|?\"%$!+=()\\[\\]{}<>]";
            Pattern pattern = Pattern.compile("[.,;'`:/\\\\*|?\"%$!+=()\\[\\]{}<>]");
            ArrayList<String> databasesF = new ArrayList<String>();
            for (String database : databases) {
                Matcher matcher = pattern.matcher(database);
                if (matcher.find()) continue;
                databasesF.add(database);
            }
            return databasesF;
        }
        catch (Exception ex) {
            XMLA_REQUEST.error((Object)"XMLA databases name error", (Throwable)ex);
            return Collections.emptyList();
        }
    }

    @Override
    public String getMetaData() {
        return this.metaData;
    }
}

