/*
 * Decompiled with CFR 0.152.
 */
package crazydev.xmla.model.common;

import crazydev.common.exception.CdRuntimeException;
import crazydev.xmla.model.mddataset.IXmlaAxis;
import crazydev.xmla.model.mddataset.IXmlaCell;
import crazydev.xmla.model.mddataset.IXmlaCellData;
import crazydev.xmla.model.mddataset.IXmlaCellInfo;
import crazydev.xmla.model.mddataset.IXmlaCellProperty;
import crazydev.xmla.model.mddataset.IXmlaError;
import crazydev.xmla.model.mddataset.IXmlaMDDataSet;
import crazydev.xmla.model.mddataset.IXmlaMember;
import crazydev.xmla.model.mddataset.IXmlaPropertyValue;
import crazydev.xmla.model.mddataset.IXmlaTuple;
import crazydev.xmla.model.mddataset.XmlaCellPropertyNames;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class XmlaMDDataSetPrettyPrinter {
    private final List<Integer> maxColumnSizes = new ArrayList<Integer>();
    private final List<List<IXmlaMember>> columns = new ArrayList<List<IXmlaMember>>();
    private final List<List<IXmlaMember>> rows = new ArrayList<List<IXmlaMember>>();
    private final IXmlaMDDataSet result;
    private final boolean useFormattedValue;

    public XmlaMDDataSetPrettyPrinter(IXmlaMDDataSet dataSet) {
        this(dataSet, true);
    }

    public XmlaMDDataSetPrettyPrinter(IXmlaMDDataSet dataSet, boolean useFormattedValue) {
        this.result = dataSet;
        this.useFormattedValue = useFormattedValue;
    }

    public String print() {
        StringWriter out = new StringWriter();
        this.print(new PrintWriter(out));
        return out.getBuffer().toString();
    }

    public String printAsHtml(Html html) {
        StringWriter out = new StringWriter();
        this.print(new PrintWriter(out), html);
        return out.getBuffer().toString();
    }

    public void print(PrintWriter out) {
        this.print(out, null);
    }

    private void print(PrintWriter out, @Nullable Html html) {
        List<IXmlaAxis> axes = this.getRegularAxes(this.result);
        if (axes.size() > 2) {
            throw new CdRuntimeException("Too many axes [" + axes.size() + "] for pretty printing!");
        }
        IXmlaCellData cellData = this.result.getCellData();
        if (axes.size() == 0) {
            IXmlaCell cell = cellData.getCellByOrdinal(0);
            if (cell != null) {
                if (html != null) {
                    out.println("<pre>" + this.getFormattedValue(html, this.result.getOlapInfo().getCellInfo(), cell) + "</pre>");
                } else {
                    out.println(this.getFormattedValue(html, this.result.getOlapInfo().getCellInfo(), cell));
                }
            } else {
                if (html != null) {
                    throw new CdRuntimeException("Not yet!");
                }
                out.println("");
            }
            return;
        }
        IXmlaAxis onColumns = axes.get(0);
        IXmlaAxis onRows = axes.size() > 1 ? axes.get(1) : null;
        this.prepareOnRows(onRows);
        this.prepareOnColumns(onColumns, onRows, this.result.getOlapInfo().getCellInfo(), cellData);
        if (html != null) {
            out.println("<table  class=\"" + html.tableCss + "\">");
        }
        this.printOnColumns(out, html);
        this.printOnRows(out, html, onColumns, onRows, this.result.getOlapInfo().getCellInfo(), cellData);
        if (html != null) {
            out.println("</table>");
        }
        out.flush();
    }

    private List<IXmlaAxis> getRegularAxes(IXmlaMDDataSet result) {
        ArrayList<IXmlaAxis> axes = new ArrayList<IXmlaAxis>();
        List<? extends IXmlaAxis> resultAxes = result.getAxes().getAxes();
        for (IXmlaAxis iXmlaAxis : resultAxes) {
            if (iXmlaAxis.isSlicer()) continue;
            axes.add(iXmlaAxis);
        }
        return axes;
    }

    private void prepareOnRows(@Nullable IXmlaAxis onRows) {
        if (onRows == null) {
            return;
        }
        for (IXmlaTuple iXmlaTuple : onRows.getTuples().getTuples()) {
            int columnIdx = 0;
            for (IXmlaMember iXmlaMember : iXmlaTuple.getMembers()) {
                if (this.columns.size() <= columnIdx) {
                    this.columns.add(new ArrayList());
                }
                List<IXmlaMember> column = this.columns.get(columnIdx);
                column.add(iXmlaMember);
                ++columnIdx;
            }
        }
        for (int idx = 0; idx < this.columns.size(); ++idx) {
            List<IXmlaMember> list = this.columns.get(idx);
            for (IXmlaMember member : list) {
                int n = member.getCaption().length() + member.getLevelNumber() * 2;
                if (idx >= this.maxColumnSizes.size()) {
                    this.maxColumnSizes.add(0);
                }
                if (n <= this.maxColumnSizes.get(idx)) continue;
                this.maxColumnSizes.set(idx, n);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void prepareOnColumns(IXmlaAxis onColumns, @Nullable IXmlaAxis onRows, IXmlaCellInfo cellInfo, IXmlaCellData cells) {
        int size;
        for (IXmlaTuple iXmlaTuple : onColumns.getTuples().getTuples()) {
            int n = 0;
            for (IXmlaMember iXmlaMember : iXmlaTuple.getMembers()) {
                if (this.rows.size() <= n) {
                    this.rows.add(new ArrayList());
                }
                this.rows.get(n).add(iXmlaMember);
                ++n;
            }
        }
        int columnOffset = this.columns.size();
        for (List<IXmlaMember> list : this.rows) {
            for (int i = 0; i < list.size(); ++i) {
                IXmlaMember iXmlaMember = list.get(i);
                size = iXmlaMember.getCaption().length();
                if (i >= this.maxColumnSizes.size() - columnOffset) {
                    this.maxColumnSizes.add(0);
                }
                if (size <= this.maxColumnSizes.get(i + columnOffset)) continue;
                this.maxColumnSizes.set(i + columnOffset, size);
            }
        }
        if (onRows == null) {
            boolean bl = false;
            for (IXmlaTuple iXmlaTuple : onColumns.getTuples().getTuples()) {
                void var6_10;
                IXmlaCell iXmlaCell = cells.getCellByOrdinal((int)var6_10);
                if (iXmlaCell != null && (size = this.getFormattedValue(null, cellInfo, iXmlaCell).length()) > this.maxColumnSizes.get((int)(var6_10 + columnOffset))) {
                    this.maxColumnSizes.set((int)(var6_10 + columnOffset), size);
                }
                ++var6_10;
            }
        } else {
            boolean bl = false;
            for (IXmlaTuple iXmlaTuple : onRows.getTuples().getTuples()) {
                void var6_12;
                int n = 0;
                int colCount = onColumns.getTupleCount();
                for (IXmlaTuple iXmlaTuple2 : onColumns.getTuples().getTuples()) {
                    IXmlaCell cell = this.getCellByOrdinal(cells, n, (int)var6_12);
                    int size2 = this.getFormattedValue(null, cellInfo, cell).length();
                    if (size2 > this.maxColumnSizes.get(n + columnOffset)) {
                        this.maxColumnSizes.set(n + columnOffset, size2);
                    }
                    ++n;
                }
                ++var6_12;
            }
        }
    }

    private void printOnColumns(PrintWriter out, @Nullable Html html) {
        if (html != null) {
            this.printOnColumnsHtml(out, html);
            return;
        }
        int horizontalOffset = 0;
        for (int col = 0; col < this.columns.size(); ++col) {
            int maxSize = this.maxColumnSizes.get(col);
            horizontalOffset += maxSize + 3;
        }
        for (int row = 0; row < this.rows.size(); ++row) {
            StringBuilder line = new StringBuilder();
            for (int p = 0; p < horizontalOffset; ++p) {
                line.append(" ");
            }
            List<IXmlaMember> members = this.rows.get(row);
            for (int col = 0; col < members.size(); ++col) {
                IXmlaMember member = members.get(col);
                line.append(" | ");
                int len = line.length();
                line.append(member.getCaption());
                int padding = len + this.maxColumnSizes.get(col + this.columns.size()) - line.length();
                for (int p = 0; p < padding; ++p) {
                    line.append(" ");
                }
            }
            out.println(String.valueOf(line) + " |");
        }
    }

    private void printOnColumnsHtml(PrintWriter out, Html html) {
        for (int row = 0; row < this.rows.size(); ++row) {
            out.println("<tr>");
            for (int col = 0; col < this.columns.size(); ++col) {
                out.println("  <td class=\"" + html.emptyHeaderCss + "\"></td>");
            }
            List<IXmlaMember> members = this.rows.get(row);
            for (int col = 0; col < members.size(); ++col) {
                IXmlaMember member = members.get(col);
                out.println("  <td class=\"" + html.headerCss + "\">" + member.getCaption() + "</td>");
            }
            out.println("</tr>");
        }
    }

    private void printOnRows(PrintWriter out, @Nullable Html html, IXmlaAxis onColumns, @Nullable IXmlaAxis onRows, IXmlaCellInfo cellInfo, IXmlaCellData cells) {
        if (html != null) {
            this.printOnRowsHtml(out, html, onColumns, onRows, cellInfo, cells);
            return;
        }
        if (onRows == null) {
            StringBuilder line = new StringBuilder();
            int columnIdx = 0;
            for (IXmlaTuple iXmlaTuple : onColumns.getTuples().getTuples()) {
                line.append(" | ");
                int len = line.length();
                IXmlaCell cell = cells.getCellByOrdinal(columnIdx);
                line.append(this.getFormattedValue(html, cellInfo, cell));
                int padding = len + this.maxColumnSizes.get(columnIdx + this.columns.size()) - line.length();
                for (int i = 0; i < padding; ++i) {
                    line.append(" ");
                }
                ++columnIdx;
            }
            out.println(String.valueOf(line) + " |");
            return;
        }
        int rowIndex = 0;
        for (IXmlaTuple iXmlaTuple : onRows.getTuples().getTuples()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int col = 0; col < this.columns.size(); ++col) {
                stringBuilder.append(" | ");
                List<IXmlaMember> column = this.columns.get(col);
                IXmlaMember member = column.get(rowIndex);
                int n = stringBuilder.length();
                if (rowIndex == 0) {
                    this.appendMemberCaption(stringBuilder, member);
                } else if (!member.equals(column.get(rowIndex - 1))) {
                    this.appendMemberCaption(stringBuilder, member);
                } else if (col > 0 && !this.columns.get(col - 1).get(rowIndex).equals(this.columns.get(col - 1).get(rowIndex - 1))) {
                    this.appendMemberCaption(stringBuilder, member);
                }
                int padding = n + this.maxColumnSizes.get(col) - stringBuilder.length();
                for (int p = 0; p < padding; ++p) {
                    stringBuilder.append(" ");
                }
            }
            int columnIndex = 0;
            int colCount = onColumns.getTupleCount();
            for (IXmlaTuple iXmlaTuple2 : onColumns.getTuples().getTuples()) {
                stringBuilder.append(" | ");
                int len = stringBuilder.length();
                IXmlaCell cell = this.getCellByOrdinal(cells, columnIndex, rowIndex);
                stringBuilder.append(this.getFormattedValue(html, cellInfo, cell));
                int padding = len + this.maxColumnSizes.get(columnIndex + this.columns.size()) - stringBuilder.length();
                for (int p = 0; p < padding; ++p) {
                    stringBuilder.append(" ");
                }
                ++columnIndex;
            }
            out.println(String.valueOf(stringBuilder) + " |");
            ++rowIndex;
        }
    }

    private void printOnRowsHtml(PrintWriter out, Html html, IXmlaAxis onColumns, @Nullable IXmlaAxis onRows, IXmlaCellInfo cellInfo, IXmlaCellData cells) {
        if (onRows == null) {
            int columnIdx = 0;
            out.println("<tr>");
            for (IXmlaTuple iXmlaTuple : onColumns.getTuples().getTuples()) {
                IXmlaCell cell = cells.getCellByOrdinal(columnIdx);
                this.printCellValue(out, html, cellInfo, cell);
                ++columnIdx;
            }
            out.println("</tr>");
        } else {
            int rowIndex = 0;
            for (IXmlaTuple iXmlaTuple : onRows.getTuples().getTuples()) {
                out.println("<tr>");
                for (int col = 0; col < this.columns.size(); ++col) {
                    List<IXmlaMember> column = this.columns.get(col);
                    IXmlaMember member = column.get(rowIndex);
                    if (rowIndex == 0) {
                        out.println("<td class=\"" + html.headerCss + "\">" + this.getMemberCaptionForHtml(member) + "</td>");
                        continue;
                    }
                    if (!member.equals(column.get(rowIndex - 1))) {
                        out.println("<td class=\"" + html.headerCss + "\">" + this.getMemberCaptionForHtml(member) + "</td>");
                        continue;
                    }
                    if (col <= 0 || this.columns.get(col - 1).get(rowIndex).equals(this.columns.get(col - 1).get(rowIndex - 1))) continue;
                    out.println("<td class=\"" + html.headerCss + "\">" + this.getMemberCaptionForHtml(member) + "</td>");
                }
                int columnIndex = 0;
                int colCount = onColumns.getTupleCount();
                for (IXmlaTuple iXmlaTuple2 : onColumns.getTuples().getTuples()) {
                    IXmlaCell cell = this.getCellByOrdinal(cells, columnIndex, rowIndex);
                    this.printCellValue(out, html, cellInfo, cell);
                    ++columnIndex;
                }
                out.println("</tr>");
                ++rowIndex;
            }
        }
    }

    private void printCellValue(PrintWriter out, Html html, IXmlaCellInfo cellInfo, IXmlaCell cell) {
        IXmlaPropertyValue style = cell.getPropertyValue("style");
        IXmlaPropertyValue className = cell.getPropertyValue("className");
        String cssStyle = style == null ? "" : " style='" + style.asString() + "'";
        String cssClassName = className == null ? "" : " class='" + className.asString() + "'";
        out.println(" <td" + cssStyle + cssClassName + ">" + this.getFormattedValue(html, cellInfo, cell) + "</td>");
    }

    private String getMemberCaptionForHtml(IXmlaMember member) {
        StringBuilder sb = new StringBuilder();
        for (int idx = 0; idx < member.getLevelNumber(); ++idx) {
            sb.append("&nbsp;&nbsp;&nbsp;");
        }
        sb.append(member.getCaption());
        return sb.toString();
    }

    private void appendMemberCaption(StringBuilder line, IXmlaMember member) {
        for (int d = 0; d < member.getLevelNumber(); ++d) {
            line.append("  ");
        }
        line.append(member.getCaption());
    }

    private String getFormattedValue(@Nullable Html html, IXmlaCellInfo cellInfo, @Nullable IXmlaCell cell) {
        if (cell == null) {
            return "";
        }
        if (cell.isOnError()) {
            IXmlaError error = cell.getError();
            if (error == null) {
                return "ERROR:missing-error-message";
            }
            if (html != null) {
                return "#ERROR : (" + error.getCode() + ")";
            }
            return "ERROR : (" + error.getCode() + ") " + error.getDescription();
        }
        if (this.useFormattedValue) {
            for (IXmlaCellProperty iXmlaCellProperty : cellInfo.getCellProperties()) {
                IXmlaPropertyValue formattedValue;
                if (!iXmlaCellProperty.isFormattedValue() || (formattedValue = cell.getPropertyValue(XmlaCellPropertyNames.FORMATTED_VALUE.name())).isMdxNull()) continue;
                return formattedValue.asString();
            }
        }
        for (IXmlaCellProperty iXmlaCellProperty : cellInfo.getCellProperties()) {
            IXmlaPropertyValue value;
            if (!iXmlaCellProperty.isValue() || (value = cell.getPropertyValue(XmlaCellPropertyNames.VALUE.name())).isMdxNull()) continue;
            return value.asString();
        }
        return "";
    }

    private IXmlaCell getCellByOrdinal(IXmlaCellData cells, int column, int row) {
        return cells.getCell(column, row);
    }

    public static class Html {
        final String tableCss;
        final String emptyHeaderCss;
        final String headerCss;

        public Html(String tableCss, String emptyHeaderCss, String headerCss) {
            this.tableCss = tableCss;
            this.emptyHeaderCss = emptyHeaderCss;
            this.headerCss = headerCss;
        }
    }
}

