/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StreamingCallSettings;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.bigquery.storage.v1beta2.AppendRowsRequest;
import com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsRequest;
import com.google.cloud.bigquery.storage.v1beta2.BatchCommitWriteStreamsResponse;
import com.google.cloud.bigquery.storage.v1beta2.CreateWriteStreamRequest;
import com.google.cloud.bigquery.storage.v1beta2.FinalizeWriteStreamRequest;
import com.google.cloud.bigquery.storage.v1beta2.FinalizeWriteStreamResponse;
import com.google.cloud.bigquery.storage.v1beta2.FlushRowsRequest;
import com.google.cloud.bigquery.storage.v1beta2.FlushRowsResponse;
import com.google.cloud.bigquery.storage.v1beta2.GetWriteStreamRequest;
import com.google.cloud.bigquery.storage.v1beta2.WriteStream;
import com.google.cloud.bigquery.storage.v1beta2.stub.BigQueryWriteStub;
import com.google.cloud.bigquery.storage.v1beta2.stub.GrpcBigQueryWriteStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@BetaApi
@Deprecated
public class BigQueryWriteStubSettings
extends StubSettings<BigQueryWriteStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/bigquery").add((Object)"https://www.googleapis.com/auth/bigquery.insertdata").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateWriteStreamRequest, WriteStream> createWriteStreamSettings;
    private final StreamingCallSettings<AppendRowsRequest, AppendRowsResponse> appendRowsSettings;
    private final UnaryCallSettings<GetWriteStreamRequest, WriteStream> getWriteStreamSettings;
    private final UnaryCallSettings<FinalizeWriteStreamRequest, FinalizeWriteStreamResponse> finalizeWriteStreamSettings;
    private final UnaryCallSettings<BatchCommitWriteStreamsRequest, BatchCommitWriteStreamsResponse> batchCommitWriteStreamsSettings;
    private final UnaryCallSettings<FlushRowsRequest, FlushRowsResponse> flushRowsSettings;

    @Deprecated
    public UnaryCallSettings<CreateWriteStreamRequest, WriteStream> createWriteStreamSettings() {
        return this.createWriteStreamSettings;
    }

    @Deprecated
    public StreamingCallSettings<AppendRowsRequest, AppendRowsResponse> appendRowsSettings() {
        return this.appendRowsSettings;
    }

    @Deprecated
    public UnaryCallSettings<GetWriteStreamRequest, WriteStream> getWriteStreamSettings() {
        return this.getWriteStreamSettings;
    }

    @Deprecated
    public UnaryCallSettings<FinalizeWriteStreamRequest, FinalizeWriteStreamResponse> finalizeWriteStreamSettings() {
        return this.finalizeWriteStreamSettings;
    }

    @Deprecated
    public UnaryCallSettings<BatchCommitWriteStreamsRequest, BatchCommitWriteStreamsResponse> batchCommitWriteStreamsSettings() {
        return this.batchCommitWriteStreamsSettings;
    }

    @Deprecated
    public UnaryCallSettings<FlushRowsRequest, FlushRowsResponse> flushRowsSettings() {
        return this.flushRowsSettings;
    }

    public BigQueryWriteStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcBigQueryWriteStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "bigquerystorage";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "bigquerystorage.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "bigquerystorage.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return BigQueryWriteStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(BigQueryWriteStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected BigQueryWriteStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createWriteStreamSettings = settingsBuilder.createWriteStreamSettings().build();
        this.appendRowsSettings = settingsBuilder.appendRowsSettings().build();
        this.getWriteStreamSettings = settingsBuilder.getWriteStreamSettings().build();
        this.finalizeWriteStreamSettings = settingsBuilder.finalizeWriteStreamSettings().build();
        this.batchCommitWriteStreamsSettings = settingsBuilder.batchCommitWriteStreamsSettings().build();
        this.flushRowsSettings = settingsBuilder.flushRowsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<BigQueryWriteStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateWriteStreamRequest, WriteStream> createWriteStreamSettings;
        private final StreamingCallSettings.Builder<AppendRowsRequest, AppendRowsResponse> appendRowsSettings;
        private final UnaryCallSettings.Builder<GetWriteStreamRequest, WriteStream> getWriteStreamSettings;
        private final UnaryCallSettings.Builder<FinalizeWriteStreamRequest, FinalizeWriteStreamResponse> finalizeWriteStreamSettings;
        private final UnaryCallSettings.Builder<BatchCommitWriteStreamsRequest, BatchCommitWriteStreamsResponse> batchCommitWriteStreamsSettings;
        private final UnaryCallSettings.Builder<FlushRowsRequest, FlushRowsResponse> flushRowsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createWriteStreamSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.appendRowsSettings = StreamingCallSettings.newBuilder();
            this.getWriteStreamSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.finalizeWriteStreamSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchCommitWriteStreamsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.flushRowsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createWriteStreamSettings, this.getWriteStreamSettings, this.finalizeWriteStreamSettings, this.batchCommitWriteStreamsSettings, this.flushRowsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(BigQueryWriteStubSettings settings) {
            super((StubSettings)settings);
            this.createWriteStreamSettings = settings.createWriteStreamSettings.toBuilder();
            this.appendRowsSettings = settings.appendRowsSettings.toBuilder();
            this.getWriteStreamSettings = settings.getWriteStreamSettings.toBuilder();
            this.finalizeWriteStreamSettings = settings.finalizeWriteStreamSettings.toBuilder();
            this.batchCommitWriteStreamsSettings = settings.batchCommitWriteStreamsSettings.toBuilder();
            this.flushRowsSettings = settings.flushRowsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createWriteStreamSettings, this.getWriteStreamSettings, this.finalizeWriteStreamSettings, this.batchCommitWriteStreamsSettings, this.flushRowsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(BigQueryWriteStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)BigQueryWriteStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)BigQueryWriteStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(BigQueryWriteStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createWriteStreamSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_3_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_3_params"));
            builder.getWriteStreamSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_5_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_5_params"));
            builder.finalizeWriteStreamSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_5_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_5_params"));
            builder.batchCommitWriteStreamsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_5_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_5_params"));
            builder.flushRowsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_5_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_5_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        @Deprecated
        public UnaryCallSettings.Builder<CreateWriteStreamRequest, WriteStream> createWriteStreamSettings() {
            return this.createWriteStreamSettings;
        }

        @Deprecated
        public StreamingCallSettings.Builder<AppendRowsRequest, AppendRowsResponse> appendRowsSettings() {
            return this.appendRowsSettings;
        }

        @Deprecated
        public UnaryCallSettings.Builder<GetWriteStreamRequest, WriteStream> getWriteStreamSettings() {
            return this.getWriteStreamSettings;
        }

        @Deprecated
        public UnaryCallSettings.Builder<FinalizeWriteStreamRequest, FinalizeWriteStreamResponse> finalizeWriteStreamSettings() {
            return this.finalizeWriteStreamSettings;
        }

        @Deprecated
        public UnaryCallSettings.Builder<BatchCommitWriteStreamsRequest, BatchCommitWriteStreamsResponse> batchCommitWriteStreamsSettings() {
            return this.batchCommitWriteStreamsSettings;
        }

        @Deprecated
        public UnaryCallSettings.Builder<FlushRowsRequest, FlushRowsResponse> flushRowsSettings() {
            return this.flushRowsSettings;
        }

        public BigQueryWriteStubSettings build() throws IOException {
            return new BigQueryWriteStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_3_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE, StatusCode.Code.RESOURCE_EXHAUSTED})));
            definitions.put((Object)"retry_policy_4_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.RESOURCE_EXHAUSTED})));
            definitions.put((Object)"retry_policy_5_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(600000L)).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build();
            definitions.put((Object)"retry_policy_3_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(86400000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(86400000L)).setTotalTimeoutDuration(Duration.ofMillis(86400000L)).build();
            definitions.put((Object)"retry_policy_4_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(600000L)).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build();
            definitions.put((Object)"retry_policy_5_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

