/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.spi.v2;

import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.util.ObjectParser;
import com.google.api.core.InternalApi;
import com.google.api.core.InternalExtensionOnly;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.DatasetList;
import com.google.api.services.bigquery.model.DatasetReference;
import com.google.api.services.bigquery.model.GetIamPolicyRequest;
import com.google.api.services.bigquery.model.GetPolicyOptions;
import com.google.api.services.bigquery.model.GetQueryResultsResponse;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobList;
import com.google.api.services.bigquery.model.JobStatus;
import com.google.api.services.bigquery.model.ListModelsResponse;
import com.google.api.services.bigquery.model.ListRoutinesResponse;
import com.google.api.services.bigquery.model.Model;
import com.google.api.services.bigquery.model.ModelReference;
import com.google.api.services.bigquery.model.Policy;
import com.google.api.services.bigquery.model.QueryRequest;
import com.google.api.services.bigquery.model.QueryResponse;
import com.google.api.services.bigquery.model.Routine;
import com.google.api.services.bigquery.model.RoutineReference;
import com.google.api.services.bigquery.model.SetIamPolicyRequest;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableDataInsertAllRequest;
import com.google.api.services.bigquery.model.TableDataInsertAllResponse;
import com.google.api.services.bigquery.model.TableDataList;
import com.google.api.services.bigquery.model.TableList;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TestIamPermissionsRequest;
import com.google.api.services.bigquery.model.TestIamPermissionsResponse;
import com.google.cloud.ServiceOptions;
import com.google.cloud.Tuple;
import com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.spi.v2.BigQueryRpc;
import com.google.cloud.http.HttpTransportOptions;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

@InternalExtensionOnly
public class HttpBigQueryRpc
implements BigQueryRpc {
    public static final String DEFAULT_PROJECTION = "full";
    private static final String BASE_RESUMABLE_URI = "upload/bigquery/v2/projects/";
    private static final int HTTP_RESUME_INCOMPLETE = 308;
    private final BigQueryOptions options;
    private final Bigquery bigquery;
    @InternalApi(value="Visible for testing")
    static final Function<DatasetList.Datasets, Dataset> LIST_TO_DATASET = new Function<DatasetList.Datasets, Dataset>(){

        public Dataset apply(DatasetList.Datasets datasetPb) {
            return new Dataset().setDatasetReference(datasetPb.getDatasetReference()).setFriendlyName(datasetPb.getFriendlyName()).setId(datasetPb.getId()).setKind(datasetPb.getKind()).setLocation(datasetPb.getLocation()).setLabels(datasetPb.getLabels());
        }
    };

    public HttpBigQueryRpc(BigQueryOptions options) {
        HttpTransportOptions transportOptions = (HttpTransportOptions)options.getTransportOptions();
        HttpTransport transport = transportOptions.getHttpTransportFactory().create();
        HttpRequestInitializer initializer = transportOptions.getHttpRequestInitializer((ServiceOptions)options);
        this.options = options;
        this.bigquery = new Bigquery.Builder(transport, (JsonFactory)new GsonFactory(), initializer).setRootUrl(options.getResolvedApiaryHost("bigquery")).setApplicationName(options.getApplicationName()).build();
    }

    private static BigQueryException translate(IOException exception) {
        return new BigQueryException(exception);
    }

    private void validateRPC() throws BigQueryException, IOException {
        if (!this.options.hasValidUniverseDomain()) {
            String errorMessage = String.format("The configured universe domain %s does not match the universe domain found in the credentials %s. If you haven't configured the universe domain explicitly, `googleapis.com` is the default.", this.options.getUniverseDomain(), this.options.getCredentials().getUniverseDomain());
            throw new BigQueryException(401, errorMessage);
        }
    }

    @Override
    public Dataset getDataset(String projectId, String datasetId, Map<BigQueryRpc.Option, ?> options) {
        try {
            return this.getDatasetSkipExceptionTranslation(projectId, datasetId, options);
        }
        catch (IOException ex) {
            BigQueryException serviceException = HttpBigQueryRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                return null;
            }
            throw serviceException;
        }
    }

    @InternalApi(value="internal to java-bigquery")
    public Dataset getDatasetSkipExceptionTranslation(String projectId, String datasetId, Map<BigQueryRpc.Option, ?> options) throws IOException {
        this.validateRPC();
        Bigquery.Datasets.Get bqGetRequest = this.bigquery.datasets().get(projectId, datasetId).setFields(BigQueryRpc.Option.FIELDS.getString(options)).setPrettyPrint(Boolean.valueOf(false));
        if (options.containsKey((Object)BigQueryRpc.Option.ACCESS_POLICY_VERSION)) {
            bqGetRequest.setAccessPolicyVersion((Integer)options.get((Object)BigQueryRpc.Option.ACCESS_POLICY_VERSION));
        }
        if (options.containsKey((Object)BigQueryRpc.Option.DATASET_VIEW)) {
            bqGetRequest.setDatasetView(options.get((Object)BigQueryRpc.Option.DATASET_VIEW).toString());
        }
        bqGetRequest.getRequestHeaders().set("x-goog-otel-enabled", (Object)this.options.isOpenTelemetryTracingEnabled());
        Span getDataset = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            getDataset = this.options.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQueryRpc.getDataset").setSpanKind(SpanKind.CLIENT).setAttribute("bq.rpc.service", "DatasetService").setAttribute("bq.rpc.method", "GetDataset").setAttribute("bq.rpc.system", "http").setAllAttributes(HttpBigQueryRpc.otelAttributesFromOptions(options)).startSpan();
        }
        Dataset dataset = (Dataset)bqGetRequest.execute();
        if (getDataset != null) {
            getDataset.setAttribute("bq.rpc.response.dataset.id", dataset.getId());
            getDataset.end();
        }
        return dataset;
    }

    @Override
    public Tuple<String, Iterable<Dataset>> listDatasets(String projectId, Map<BigQueryRpc.Option, ?> options) {
        try {
            return this.listDatasetsSkipExceptionTranslation(projectId, options);
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @InternalApi(value="internal to java-bigquery")
    public Tuple<String, Iterable<Dataset>> listDatasetsSkipExceptionTranslation(String projectId, Map<BigQueryRpc.Option, ?> options) throws IOException {
        this.validateRPC();
        Bigquery.Datasets.List datasetsListRequest = this.bigquery.datasets().list(projectId).setPrettyPrint(Boolean.valueOf(false)).setAll(BigQueryRpc.Option.ALL_DATASETS.getBoolean(options)).setFilter(BigQueryRpc.Option.LABEL_FILTER.getString(options)).setMaxResults(BigQueryRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(BigQueryRpc.Option.PAGE_TOKEN.getString(options));
        datasetsListRequest.getRequestHeaders().set("x-goog-otel-enabled", (Object)this.options.isOpenTelemetryTracingEnabled());
        Span listDatasets = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            listDatasets = this.options.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQueryRpc.listDatasets").setSpanKind(SpanKind.CLIENT).setAttribute("bq.rpc.service", "DatasetService").setAttribute("bq.rpc.method", "ListDatasets").setAttribute("bq.rpc.system", "http").setAttribute("bq.rpc.page_token", datasetsListRequest.getPageToken()).setAllAttributes(HttpBigQueryRpc.otelAttributesFromOptions(options)).startSpan();
        }
        DatasetList datasetsList = (DatasetList)datasetsListRequest.execute();
        List datasets = datasetsList.getDatasets();
        if (listDatasets != null) {
            listDatasets.setAttribute("bq.rpc.next_page_token", datasetsList.getNextPageToken());
            listDatasets.end();
        }
        return Tuple.of((Object)datasetsList.getNextPageToken(), (Object)Iterables.transform((Iterable)(datasets != null ? datasets : ImmutableList.of()), LIST_TO_DATASET));
    }

    @Override
    public Dataset create(Dataset dataset, Map<BigQueryRpc.Option, ?> options) {
        try {
            return this.createSkipExceptionTranslation(dataset, options);
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @InternalApi(value="internal to java-bigquery")
    public Dataset createSkipExceptionTranslation(Dataset dataset, Map<BigQueryRpc.Option, ?> options) throws IOException {
        this.validateRPC();
        Bigquery.Datasets.Insert bqCreateRequest = this.bigquery.datasets().insert(dataset.getDatasetReference().getProjectId(), dataset).setPrettyPrint(Boolean.valueOf(false)).setFields(BigQueryRpc.Option.FIELDS.getString(options));
        if (options.containsKey((Object)BigQueryRpc.Option.ACCESS_POLICY_VERSION)) {
            bqCreateRequest.setAccessPolicyVersion((Integer)options.get((Object)BigQueryRpc.Option.ACCESS_POLICY_VERSION));
        }
        bqCreateRequest.getRequestHeaders().set("x-goog-otel-enabled", (Object)this.options.isOpenTelemetryTracingEnabled());
        Span createDataset = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            createDataset = this.options.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQueryRpc.createDataset").setSpanKind(SpanKind.CLIENT).setAttribute("bq.rpc.service", "DatasetService").setAttribute("bq.rpc.method", "InsertDataset").setAttribute("bq.rpc.system", "http").setAllAttributes(HttpBigQueryRpc.otelAttributesFromOptions(options)).startSpan();
        }
        Dataset datasetResponse = (Dataset)bqCreateRequest.execute();
        if (createDataset != null) {
            createDataset.setAttribute("bq.rpc.response.dataset.id", datasetResponse.getId());
            createDataset.end();
        }
        return datasetResponse;
    }

    @Override
    public Table create(Table table, Map<BigQueryRpc.Option, ?> options) {
        try {
            return this.createSkipExceptionTranslation(table, options);
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @InternalApi(value="internal to java-bigquery")
    public Table createSkipExceptionTranslation(Table table, Map<BigQueryRpc.Option, ?> options) throws IOException {
        this.validateRPC();
        table.setType(null);
        TableReference reference = table.getTableReference();
        Bigquery.Tables.Insert bqCreateRequest = this.bigquery.tables().insert(reference.getProjectId(), reference.getDatasetId(), table).setPrettyPrint(Boolean.valueOf(false)).setFields(BigQueryRpc.Option.FIELDS.getString(options));
        bqCreateRequest.getRequestHeaders().set("x-goog-otel-enabled", (Object)this.options.isOpenTelemetryTracingEnabled());
        Span createTable = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            createTable = this.options.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQueryRpc.createTable").setSpanKind(SpanKind.CLIENT).setAttribute("bq.rpc.service", "TableService").setAttribute("bq.rpc.method", "InsertTable").setAttribute("bq.rpc.system", "http").setAllAttributes(HttpBigQueryRpc.otelAttributesFromOptions(options)).startSpan();
        }
        Table tableResponse = (Table)bqCreateRequest.execute();
        if (createTable != null) {
            createTable.setAttribute("bq.rpc.response.table.id", tableResponse.getId());
            createTable.end();
        }
        return tableResponse;
    }

    @Override
    public Routine create(Routine routine, Map<BigQueryRpc.Option, ?> options) {
        try {
            return this.createSkipExceptionTranslation(routine, options);
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @InternalApi(value="internal to java-bigquery")
    public Routine createSkipExceptionTranslation(Routine routine, Map<BigQueryRpc.Option, ?> options) throws IOException {
        this.validateRPC();
        RoutineReference reference = routine.getRoutineReference();
        Bigquery.Routines.Insert bqCreateRequest = this.bigquery.routines().insert(reference.getProjectId(), reference.getDatasetId(), routine).setPrettyPrint(Boolean.valueOf(false)).setFields(BigQueryRpc.Option.FIELDS.getString(options));
        bqCreateRequest.getRequestHeaders().set("x-goog-otel-enabled", (Object)this.options.isOpenTelemetryTracingEnabled());
        Span createRoutine = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            createRoutine = this.options.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQueryRpc.createRoutine").setSpanKind(SpanKind.CLIENT).setAttribute("bq.rpc.service", "RoutineService").setAttribute("bq.rpc.method", "InsertRoutine").setAttribute("bq.rpc.system", "http").setAllAttributes(HttpBigQueryRpc.otelAttributesFromOptions(options)).startSpan();
        }
        Routine routineResponse = (Routine)bqCreateRequest.execute();
        if (createRoutine != null) {
            createRoutine.setAttribute("bq.rpc.response.routine.id", routineResponse.getRoutineReference().getRoutineId());
            createRoutine.end();
        }
        return routineResponse;
    }

    @Override
    public Job create(Job job, Map<BigQueryRpc.Option, ?> options) {
        try {
            return this.createSkipExceptionTranslation(job, options);
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @InternalApi(value="internal to java-bigquery")
    public Job createSkipExceptionTranslation(Job job, Map<BigQueryRpc.Option, ?> options) throws IOException {
        this.validateRPC();
        String projectId = job.getJobReference() != null ? job.getJobReference().getProjectId() : this.options.getProjectId();
        Bigquery.Jobs.Insert bqCreateRequest = this.bigquery.jobs().insert(projectId, job).setPrettyPrint(Boolean.valueOf(false)).setFields(BigQueryRpc.Option.FIELDS.getString(options));
        bqCreateRequest.getRequestHeaders().set("x-goog-otel-enabled", (Object)this.options.isOpenTelemetryTracingEnabled());
        Span createJob = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            createJob = this.options.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQueryRpc.createJob").setSpanKind(SpanKind.CLIENT).setAttribute("bq.rpc.service", "JobService").setAttribute("bq.rpc.method", "InsertJob").setAttribute("bq.rpc.system", "http").setAllAttributes(HttpBigQueryRpc.otelAttributesFromOptions(options)).startSpan();
        }
        Job jobResponse = (Job)bqCreateRequest.execute();
        if (createJob != null) {
            createJob.setAttribute("bq.rpc.response.job.id", jobResponse.getId());
            createJob.setAttribute("bq.rpc.response.job.status.state", jobResponse.getStatus().getState());
            createJob.end();
        }
        return jobResponse;
    }

    @Override
    public Job createJobForQuery(Job job) {
        try {
            return this.createJobForQuerySkipExceptionTranslation(job);
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @InternalApi(value="internal to java-bigquery")
    public Job createJobForQuerySkipExceptionTranslation(Job job) throws IOException {
        this.validateRPC();
        String projectId = job.getJobReference() != null ? job.getJobReference().getProjectId() : this.options.getProjectId();
        Bigquery.Jobs.Insert bqCreateRequest = this.bigquery.jobs().insert(projectId, job).setPrettyPrint(Boolean.valueOf(false));
        bqCreateRequest.getRequestHeaders().set("x-goog-otel-enabled", (Object)this.options.isOpenTelemetryTracingEnabled());
        Span createJob = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            createJob = this.options.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQueryRpc.createJobForQuery").setSpanKind(SpanKind.CLIENT).setAttribute("bq.rpc.service", "JobService").setAttribute("bq.rpc.method", "InsertJob").setAttribute("bq.rpc.system", "http").startSpan();
        }
        Job jobResponse = (Job)bqCreateRequest.execute();
        if (createJob != null) {
            createJob.setAttribute("bq.rpc.response.job.id", jobResponse.getId());
            createJob.setAttribute("bq.rpc.response.job.status.state", jobResponse.getStatus().getState());
            createJob.end();
        }
        return jobResponse;
    }

    @Override
    public boolean deleteDataset(String projectId, String datasetId, Map<BigQueryRpc.Option, ?> options) {
        try {
            return this.deleteDatasetSkipExceptionTranslation(projectId, datasetId, options);
        }
        catch (IOException ex) {
            BigQueryException serviceException = HttpBigQueryRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                return false;
            }
            throw serviceException;
        }
    }

    @InternalApi(value="internal to java-bigquery")
    public boolean deleteDatasetSkipExceptionTranslation(String projectId, String datasetId, Map<BigQueryRpc.Option, ?> options) throws IOException {
        this.validateRPC();
        Bigquery.Datasets.Delete bqDeleteRequest = this.bigquery.datasets().delete(projectId, datasetId).setPrettyPrint(Boolean.valueOf(false)).setDeleteContents(BigQueryRpc.Option.DELETE_CONTENTS.getBoolean(options));
        bqDeleteRequest.getRequestHeaders().set("x-goog-otel-enabled", (Object)this.options.isOpenTelemetryTracingEnabled());
        Span deleteDataset = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            deleteDataset = this.options.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQueryRpc.deleteDataset").setSpanKind(SpanKind.CLIENT).setAttribute("bq.rpc.service", "DatasetService").setAttribute("bq.rpc.method", "DeleteDataset").setAttribute("bq.rpc.system", "http").setAllAttributes(HttpBigQueryRpc.otelAttributesFromOptions(options)).startSpan();
        }
        bqDeleteRequest.execute();
        if (deleteDataset != null) {
            deleteDataset.end();
        }
        return true;
    }

    @Override
    public Dataset patch(Dataset dataset, Map<BigQueryRpc.Option, ?> options) {
        try {
            return this.patchSkipExceptionTranslation(dataset, options);
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @InternalApi(value="internal to java-bigquery")
    public Dataset patchSkipExceptionTranslation(Dataset dataset, Map<BigQueryRpc.Option, ?> options) throws IOException {
        this.validateRPC();
        DatasetReference reference = dataset.getDatasetReference();
        Bigquery.Datasets.Patch bqPatchRequest = this.bigquery.datasets().patch(reference.getProjectId(), reference.getDatasetId(), dataset).setPrettyPrint(Boolean.valueOf(false)).setFields(BigQueryRpc.Option.FIELDS.getString(options));
        if (options.containsKey((Object)BigQueryRpc.Option.ACCESS_POLICY_VERSION)) {
            bqPatchRequest.setAccessPolicyVersion((Integer)options.get((Object)BigQueryRpc.Option.ACCESS_POLICY_VERSION));
        }
        if (options.containsKey((Object)BigQueryRpc.Option.DATASET_UPDATE_MODE)) {
            bqPatchRequest.setUpdateMode(options.get((Object)BigQueryRpc.Option.DATASET_UPDATE_MODE).toString());
        }
        bqPatchRequest.getRequestHeaders().set("x-goog-otel-enabled", (Object)this.options.isOpenTelemetryTracingEnabled());
        Span patchDataset = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            patchDataset = this.options.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQueryRpc.patchDataset").setSpanKind(SpanKind.CLIENT).setAttribute("bq.rpc.service", "DatasetService").setAttribute("bq.rpc.method", "PatchDataset").setAttribute("bq.rpc.system", "http").setAllAttributes(HttpBigQueryRpc.otelAttributesFromOptions(options)).startSpan();
        }
        Dataset datasetResponse = (Dataset)bqPatchRequest.execute();
        if (patchDataset != null) {
            patchDataset.setAttribute("bq.rpc.response.dataset.id", datasetResponse.getId());
            patchDataset.end();
        }
        return datasetResponse;
    }

    @Override
    public Table patch(Table table, Map<BigQueryRpc.Option, ?> options) {
        try {
            return this.patchSkipExceptionTranslation(table, options);
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @InternalApi(value="internal to java-bigquery")
    public Table patchSkipExceptionTranslation(Table table, Map<BigQueryRpc.Option, ?> options) throws IOException {
        this.validateRPC();
        table.setType(null);
        TableReference reference = table.getTableReference();
        Bigquery.Tables.Patch bqPatchRequest = this.bigquery.tables().patch(reference.getProjectId(), reference.getDatasetId(), reference.getTableId(), table).setPrettyPrint(Boolean.valueOf(false)).setFields(BigQueryRpc.Option.FIELDS.getString(options)).setAutodetectSchema(BigQueryRpc.Option.AUTODETECT_SCHEMA.getBoolean(options));
        bqPatchRequest.getRequestHeaders().set("x-goog-otel-enabled", (Object)this.options.isOpenTelemetryTracingEnabled());
        Span patchTable = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            patchTable = this.options.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQueryRpc.patchTable").setSpanKind(SpanKind.CLIENT).setAttribute("bq.rpc.service", "TableService").setAttribute("bq.rpc.method", "PatchTable").setAttribute("bq.rpc.system", "http").setAllAttributes(HttpBigQueryRpc.otelAttributesFromOptions(options)).startSpan();
        }
        Table tableResponse = (Table)bqPatchRequest.execute();
        if (patchTable != null) {
            patchTable.setAttribute("bq.rpc.response.table.id", tableResponse.getId());
            patchTable.end();
        }
        return tableResponse;
    }

    @Override
    public Table getTable(String projectId, String datasetId, String tableId, Map<BigQueryRpc.Option, ?> options) {
        try {
            return this.getTableSkipExceptionTranslation(projectId, datasetId, tableId, options);
        }
        catch (IOException ex) {
            BigQueryException serviceException = HttpBigQueryRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                return null;
            }
            throw serviceException;
        }
    }

    @InternalApi(value="internal to java-bigquery")
    public Table getTableSkipExceptionTranslation(String projectId, String datasetId, String tableId, Map<BigQueryRpc.Option, ?> options) throws IOException {
        this.validateRPC();
        Bigquery.Tables.Get bqGetRequest = this.bigquery.tables().get(projectId, datasetId, tableId).setPrettyPrint(Boolean.valueOf(false)).setFields(BigQueryRpc.Option.FIELDS.getString(options)).setView(this.getTableMetadataOption(options));
        bqGetRequest.getRequestHeaders().set("x-goog-otel-enabled", (Object)this.options.isOpenTelemetryTracingEnabled());
        Span getTable = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            getTable = this.options.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQueryRpc.getTable").setSpanKind(SpanKind.CLIENT).setAttribute("bq.rpc.service", "TableService").setAttribute("bq.rpc.method", "GetTable").setAttribute("bq.rpc.system", "http").setAllAttributes(HttpBigQueryRpc.otelAttributesFromOptions(options)).startSpan();
        }
        Table tableResponse = (Table)bqGetRequest.execute();
        if (getTable != null) {
            getTable.setAttribute("bq.rpc.response.table.id", tableResponse.getId());
            getTable.end();
        }
        return tableResponse;
    }

    private String getTableMetadataOption(Map<BigQueryRpc.Option, ?> options) {
        if (options.containsKey((Object)BigQueryRpc.Option.TABLE_METADATA_VIEW)) {
            return options.get((Object)BigQueryRpc.Option.TABLE_METADATA_VIEW).toString();
        }
        return "STORAGE_STATS";
    }

    @Override
    public Tuple<String, Iterable<Table>> listTables(String projectId, String datasetId, Map<BigQueryRpc.Option, ?> options) {
        try {
            return this.listTablesSkipExceptionTranslation(projectId, datasetId, options);
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @InternalApi(value="internal to java-bigquery")
    public Tuple<String, Iterable<Table>> listTablesSkipExceptionTranslation(String projectId, String datasetId, Map<BigQueryRpc.Option, ?> options) throws IOException {
        this.validateRPC();
        Bigquery.Tables.List tableListRequest = this.bigquery.tables().list(projectId, datasetId).setPrettyPrint(Boolean.valueOf(false)).setMaxResults(BigQueryRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(BigQueryRpc.Option.PAGE_TOKEN.getString(options));
        tableListRequest.getRequestHeaders().set("x-goog-otel-enabled", (Object)this.options.isOpenTelemetryTracingEnabled());
        Span listTables = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            listTables = this.options.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQueryRpc.listTables").setSpanKind(SpanKind.CLIENT).setAttribute("bq.rpc.service", "TableService").setAttribute("bq.rpc.method", "ListTables").setAttribute("bq.rpc.system", "http").setAttribute("bq.rpc.page_token", tableListRequest.getPageToken()).setAllAttributes(HttpBigQueryRpc.otelAttributesFromOptions(options)).startSpan();
        }
        TableList tableResponse = (TableList)tableListRequest.execute();
        if (listTables != null) {
            listTables.setAttribute("bq.rpc.next_page_token", tableResponse.getNextPageToken());
            listTables.end();
        }
        List tables = tableResponse.getTables();
        return Tuple.of((Object)tableResponse.getNextPageToken(), (Object)Iterables.transform((Iterable)(tables != null ? tables : ImmutableList.of()), (Function)new Function<TableList.Tables, Table>(){

            public Table apply(TableList.Tables tablePb) {
                return new Table().setFriendlyName(tablePb.getFriendlyName()).setId(tablePb.getId()).setKind(tablePb.getKind()).setTableReference(tablePb.getTableReference()).setType(tablePb.getType()).setCreationTime(tablePb.getCreationTime()).setTimePartitioning(tablePb.getTimePartitioning()).setRangePartitioning(tablePb.getRangePartitioning()).setClustering(tablePb.getClustering()).setLabels(tablePb.getLabels());
            }
        }));
    }

    @Override
    public boolean deleteTable(String projectId, String datasetId, String tableId) {
        try {
            return this.deleteTableSkipExceptionTranslation(projectId, datasetId, tableId);
        }
        catch (IOException ex) {
            BigQueryException serviceException = HttpBigQueryRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                return false;
            }
            throw serviceException;
        }
    }

    @InternalApi(value="internal to java-bigquery")
    public boolean deleteTableSkipExceptionTranslation(String projectId, String datasetId, String tableId) throws IOException {
        this.validateRPC();
        Bigquery.Tables.Delete bqDeleteRequest = this.bigquery.tables().delete(projectId, datasetId, tableId);
        bqDeleteRequest.getRequestHeaders().set("x-goog-otel-enabled", (Object)this.options.isOpenTelemetryTracingEnabled());
        Span deleteTable = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            deleteTable = this.options.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQueryRpc.deleteTable").setSpanKind(SpanKind.CLIENT).setAttribute("bq.rpc.service", "TableService").setAttribute("bq.rpc.method", "DeleteTable").setAttribute("bq.rpc.system", "http").startSpan();
        }
        bqDeleteRequest.execute();
        if (deleteTable != null) {
            deleteTable.end();
        }
        return true;
    }

    @Override
    public Model patch(Model model, Map<BigQueryRpc.Option, ?> options) {
        try {
            return this.patchSkipExceptionTranslation(model, options);
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @InternalApi(value="internal to java-bigquery")
    public Model patchSkipExceptionTranslation(Model model, Map<BigQueryRpc.Option, ?> options) throws IOException {
        this.validateRPC();
        ModelReference reference = model.getModelReference();
        Bigquery.Models.Patch bqPatchRequest = this.bigquery.models().patch(reference.getProjectId(), reference.getDatasetId(), reference.getModelId(), model).setPrettyPrint(Boolean.valueOf(false)).setFields(BigQueryRpc.Option.FIELDS.getString(options));
        bqPatchRequest.getRequestHeaders().set("x-goog-otel-enabled", (Object)this.options.isOpenTelemetryTracingEnabled());
        Span patchModel = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            patchModel = this.options.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQueryRpc.patchModel").setSpanKind(SpanKind.CLIENT).setAttribute("bq.rpc.service", "ModelService").setAttribute("bq.rpc.method", "PatchModel").setAttribute("bq.rpc.system", "http").setAllAttributes(HttpBigQueryRpc.otelAttributesFromOptions(options)).startSpan();
        }
        Model modelResponse = (Model)bqPatchRequest.execute();
        if (patchModel != null) {
            patchModel.setAttribute("bq.rpc.response.model.id", modelResponse.getModelReference().getModelId());
            patchModel.end();
        }
        return modelResponse;
    }

    @Override
    public Model getModel(String projectId, String datasetId, String modelId, Map<BigQueryRpc.Option, ?> options) {
        try {
            return this.getModelSkipExceptionTranslation(projectId, datasetId, modelId, options);
        }
        catch (IOException ex) {
            BigQueryException serviceException = HttpBigQueryRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                return null;
            }
            throw serviceException;
        }
    }

    @InternalApi(value="internal to java-bigquery")
    public Model getModelSkipExceptionTranslation(String projectId, String datasetId, String modelId, Map<BigQueryRpc.Option, ?> options) throws IOException {
        this.validateRPC();
        Bigquery.Models.Get bqGetRequest = this.bigquery.models().get(projectId, datasetId, modelId).setPrettyPrint(Boolean.valueOf(false)).setFields(BigQueryRpc.Option.FIELDS.getString(options));
        bqGetRequest.getRequestHeaders().set("x-goog-otel-enabled", (Object)this.options.isOpenTelemetryTracingEnabled());
        Span getModel = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            getModel = this.options.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQueryRpc.getModel").setSpanKind(SpanKind.CLIENT).setAttribute("bq.rpc.service", "ModelService").setAttribute("bq.rpc.method", "GetModel").setAttribute("bq.rpc.system", "http").setAllAttributes(HttpBigQueryRpc.otelAttributesFromOptions(options)).startSpan();
        }
        Model modelResponse = (Model)bqGetRequest.execute();
        if (getModel != null) {
            getModel.setAttribute("bq.rpc.response.model.id", modelResponse.getModelReference().getModelId());
            getModel.end();
        }
        return modelResponse;
    }

    @Override
    public Tuple<String, Iterable<Model>> listModels(String projectId, String datasetId, Map<BigQueryRpc.Option, ?> options) {
        try {
            return this.listModelsSkipExceptionTranslation(projectId, datasetId, options);
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @InternalApi(value="internal to java-bigquery")
    public Tuple<String, Iterable<Model>> listModelsSkipExceptionTranslation(String projectId, String datasetId, Map<BigQueryRpc.Option, ?> options) throws IOException {
        this.validateRPC();
        Bigquery.Models.List modelListRequest = this.bigquery.models().list(projectId, datasetId).setPrettyPrint(Boolean.valueOf(false)).setMaxResults(BigQueryRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(BigQueryRpc.Option.PAGE_TOKEN.getString(options));
        modelListRequest.getRequestHeaders().set("x-goog-otel-enabled", (Object)this.options.isOpenTelemetryTracingEnabled());
        Span listModels = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            listModels = this.options.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQueryRpc.listModels").setSpanKind(SpanKind.CLIENT).setAttribute("bq.rpc.service", "ModelService").setAttribute("bq.rpc.method", "ListModels").setAttribute("bq.rpc.system", "http").setAttribute("bq.rpc.page_token", modelListRequest.getPageToken()).setAllAttributes(HttpBigQueryRpc.otelAttributesFromOptions(options)).startSpan();
        }
        ListModelsResponse modelResponse = (ListModelsResponse)modelListRequest.execute();
        if (listModels != null) {
            listModels.setAttribute("bq.rpc.next_page_token", modelResponse.getNextPageToken());
            listModels.end();
        }
        Object models = modelResponse.getModels() != null ? modelResponse.getModels() : ImmutableList.of();
        return Tuple.of((Object)modelResponse.getNextPageToken(), (Object)models);
    }

    @Override
    public boolean deleteModel(String projectId, String datasetId, String modelId) {
        try {
            return this.deleteModelSkipExceptionTranslation(projectId, datasetId, modelId);
        }
        catch (IOException ex) {
            BigQueryException serviceException = HttpBigQueryRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                return false;
            }
            throw serviceException;
        }
    }

    @InternalApi(value="internal to java-bigquery")
    public boolean deleteModelSkipExceptionTranslation(String projectId, String datasetId, String modelId) throws IOException {
        this.validateRPC();
        Bigquery.Models.Delete bqDeleteRequest = this.bigquery.models().delete(projectId, datasetId, modelId);
        bqDeleteRequest.getRequestHeaders().set("x-goog-otel-enabled", (Object)this.options.isOpenTelemetryTracingEnabled());
        Span deleteModels = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            deleteModels = this.options.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQueryRpc.deleteModel").setSpanKind(SpanKind.CLIENT).setAttribute("bq.rpc.service", "ModelService").setAttribute("bq.rpc.method", "DeleteModel").setAttribute("bq.rpc.system", "http").startSpan();
        }
        bqDeleteRequest.execute();
        if (deleteModels != null) {
            deleteModels.end();
        }
        return true;
    }

    @Override
    public Routine update(Routine routine, Map<BigQueryRpc.Option, ?> options) {
        try {
            return this.updateSkipExceptionTranslation(routine, options);
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @InternalApi(value="internal to java-bigquery")
    public Routine updateSkipExceptionTranslation(Routine routine, Map<BigQueryRpc.Option, ?> options) throws IOException {
        this.validateRPC();
        RoutineReference reference = routine.getRoutineReference();
        Bigquery.Routines.Update bqUpdateRequest = this.bigquery.routines().update(reference.getProjectId(), reference.getDatasetId(), reference.getRoutineId(), routine).setPrettyPrint(Boolean.valueOf(false)).setFields(BigQueryRpc.Option.FIELDS.getString(options));
        bqUpdateRequest.getRequestHeaders().set("x-goog-otel-enabled", (Object)this.options.isOpenTelemetryTracingEnabled());
        Span updateRoutine = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            updateRoutine = this.options.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQueryRpc.updateRoutine").setSpanKind(SpanKind.CLIENT).setAttribute("bq.rpc.service", "RoutineService").setAttribute("bq.rpc.method", "UpdateRoutine").setAttribute("bq.rpc.system", "http").setAllAttributes(HttpBigQueryRpc.otelAttributesFromOptions(options)).startSpan();
        }
        Routine routineResponse = (Routine)bqUpdateRequest.execute();
        if (updateRoutine != null) {
            updateRoutine.setAttribute("bq.rpc.response.routine.id", routineResponse.getRoutineReference().getRoutineId());
            updateRoutine.end();
        }
        return routineResponse;
    }

    @Override
    public Routine getRoutine(String projectId, String datasetId, String routineId, Map<BigQueryRpc.Option, ?> options) {
        try {
            return this.getRoutineSkipExceptionTranslation(projectId, datasetId, routineId, options);
        }
        catch (IOException ex) {
            BigQueryException serviceException = HttpBigQueryRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                return null;
            }
            throw serviceException;
        }
    }

    @InternalApi(value="internal to java-bigquery")
    public Routine getRoutineSkipExceptionTranslation(String projectId, String datasetId, String routineId, Map<BigQueryRpc.Option, ?> options) throws IOException {
        this.validateRPC();
        Bigquery.Routines.Get bqGetRequest = this.bigquery.routines().get(projectId, datasetId, routineId).setPrettyPrint(Boolean.valueOf(false)).setFields(BigQueryRpc.Option.FIELDS.getString(options));
        bqGetRequest.getRequestHeaders().set("x-goog-otel-enabled", (Object)this.options.isOpenTelemetryTracingEnabled());
        Span getRoutine = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            getRoutine = this.options.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQueryRpc.getRoutine").setSpanKind(SpanKind.CLIENT).setAttribute("bq.rpc.service", "RoutineService").setAttribute("bq.rpc.method", "GetRoutine").setAttribute("bq.rpc.system", "http").setAllAttributes(HttpBigQueryRpc.otelAttributesFromOptions(options)).startSpan();
        }
        Routine routineResponse = (Routine)bqGetRequest.execute();
        if (getRoutine != null) {
            getRoutine.setAttribute("bq.rpc.response.routine.id", routineResponse.getRoutineReference().getRoutineId());
            getRoutine.end();
        }
        return routineResponse;
    }

    @Override
    public Tuple<String, Iterable<Routine>> listRoutines(String projectId, String datasetId, Map<BigQueryRpc.Option, ?> options) {
        try {
            return this.listRoutinesSkipExceptionTranslation(projectId, datasetId, options);
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @InternalApi(value="internal to java-bigquery")
    public Tuple<String, Iterable<Routine>> listRoutinesSkipExceptionTranslation(String projectId, String datasetId, Map<BigQueryRpc.Option, ?> options) throws IOException {
        this.validateRPC();
        Bigquery.Routines.List routineListRequest = this.bigquery.routines().list(projectId, datasetId).setPrettyPrint(Boolean.valueOf(false)).setMaxResults(BigQueryRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(BigQueryRpc.Option.PAGE_TOKEN.getString(options));
        routineListRequest.getRequestHeaders().set("x-goog-otel-enabled", (Object)this.options.isOpenTelemetryTracingEnabled());
        Span listRoutines = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            listRoutines = this.options.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQueryRpc.listRoutines").setSpanKind(SpanKind.CLIENT).setAttribute("bq.rpc.service", "RoutineService").setAttribute("bq.rpc.method", "ListRoutines").setAttribute("bq.rpc.system", "http").setAttribute("bq.rpc.page_token", routineListRequest.getPageToken()).setAllAttributes(HttpBigQueryRpc.otelAttributesFromOptions(options)).startSpan();
        }
        ListRoutinesResponse routineResponse = (ListRoutinesResponse)routineListRequest.execute();
        if (listRoutines != null) {
            listRoutines.setAttribute("bq.rpc.next_page_token", routineResponse.getNextPageToken());
            listRoutines.end();
        }
        Object routines = routineResponse.getRoutines() != null ? routineResponse.getRoutines() : ImmutableList.of();
        return Tuple.of((Object)routineResponse.getNextPageToken(), (Object)routines);
    }

    @Override
    public boolean deleteRoutine(String projectId, String datasetId, String routineId) {
        try {
            return this.deleteRoutineSkipExceptionTranslation(projectId, datasetId, routineId);
        }
        catch (IOException ex) {
            BigQueryException serviceException = HttpBigQueryRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                return false;
            }
            throw serviceException;
        }
    }

    @InternalApi(value="internal to java-bigquery")
    public boolean deleteRoutineSkipExceptionTranslation(String projectId, String datasetId, String routineId) throws IOException {
        this.validateRPC();
        Bigquery.Routines.Delete bqDeleteRequest = this.bigquery.routines().delete(projectId, datasetId, routineId);
        bqDeleteRequest.getRequestHeaders().set("x-goog-otel-enabled", (Object)this.options.isOpenTelemetryTracingEnabled());
        Span deleteRoutine = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            deleteRoutine = this.options.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQueryRpc.listRoutines").setSpanKind(SpanKind.CLIENT).setAttribute("bq.rpc.service", "RoutineService").setAttribute("bq.rpc.method", "ListRoutines").setAttribute("bq.rpc.system", "http").startSpan();
        }
        bqDeleteRequest.execute();
        if (deleteRoutine != null) {
            deleteRoutine.end();
        }
        return true;
    }

    @Override
    public TableDataInsertAllResponse insertAll(String projectId, String datasetId, String tableId, TableDataInsertAllRequest request) {
        try {
            return this.insertAllSkipExceptionTranslation(projectId, datasetId, tableId, request);
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @InternalApi(value="internal to java-bigquery")
    public TableDataInsertAllResponse insertAllSkipExceptionTranslation(String projectId, String datasetId, String tableId, TableDataInsertAllRequest request) throws IOException {
        this.validateRPC();
        Bigquery.Tabledata.InsertAll insertAllRequest = this.bigquery.tabledata().insertAll(projectId, datasetId, tableId, request).setPrettyPrint(Boolean.valueOf(false));
        insertAllRequest.getRequestHeaders().set("x-goog-otel-enabled", (Object)this.options.isOpenTelemetryTracingEnabled());
        Span insertAll = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            insertAll = this.options.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQueryRpc.insertAll").setSpanKind(SpanKind.CLIENT).setAttribute("bq.rpc.service", "TableDataService").setAttribute("bq.rpc.method", "InsertAll").setAttribute("bq.rpc.system", "http").startSpan();
        }
        TableDataInsertAllResponse insertAllResponse = (TableDataInsertAllResponse)insertAllRequest.execute();
        if (insertAll != null) {
            insertAll.end();
        }
        return insertAllResponse;
    }

    @Override
    public TableDataList listTableData(String projectId, String datasetId, String tableId, Map<BigQueryRpc.Option, ?> options) {
        try {
            return this.listTableDataSkipExceptionTranslation(projectId, datasetId, tableId, options);
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @InternalApi(value="internal to java-bigquery")
    public TableDataList listTableDataSkipExceptionTranslation(String projectId, String datasetId, String tableId, Map<BigQueryRpc.Option, ?> options) throws IOException {
        this.validateRPC();
        Bigquery.Tabledata.List bqListRequest = this.bigquery.tabledata().list(projectId, datasetId, tableId).setPrettyPrint(Boolean.valueOf(false)).setMaxResults(BigQueryRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(BigQueryRpc.Option.PAGE_TOKEN.getString(options)).setStartIndex(BigQueryRpc.Option.START_INDEX.getLong(options) != null ? BigInteger.valueOf(BigQueryRpc.Option.START_INDEX.getLong(options)) : null);
        bqListRequest.getRequestHeaders().set("x-goog-otel-enabled", (Object)this.options.isOpenTelemetryTracingEnabled());
        Span listTableData = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            listTableData = this.options.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQueryRpc.listTableData").setSpanKind(SpanKind.CLIENT).setAttribute("bq.rpc.service", "TableDataService").setAttribute("bq.rpc.method", "List").setAttribute("bq.rpc.system", "http").setAttribute("bq.rpc.page_token", bqListRequest.getPageToken()).setAllAttributes(HttpBigQueryRpc.otelAttributesFromOptions(options)).startSpan();
        }
        TableDataList bqListResponse = (TableDataList)bqListRequest.execute();
        if (listTableData != null) {
            listTableData.end();
        }
        return bqListResponse;
    }

    @Override
    public TableDataList listTableDataWithRowLimit(String projectId, String datasetId, String tableId, Integer maxResultPerPage, String pageToken) {
        try {
            return this.listTableDataWithRowLimitSkipExceptionTranslation(projectId, datasetId, tableId, maxResultPerPage, pageToken);
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @InternalApi(value="internal to java-bigquery")
    public TableDataList listTableDataWithRowLimitSkipExceptionTranslation(String projectId, String datasetId, String tableId, Integer maxResultPerPage, String pageToken) throws IOException {
        this.validateRPC();
        Bigquery.Tabledata.List bqListRequest = this.bigquery.tabledata().list(projectId, datasetId, tableId).setPrettyPrint(Boolean.valueOf(false)).setMaxResults(Long.valueOf(maxResultPerPage.intValue())).setPageToken(pageToken);
        bqListRequest.getRequestHeaders().set("x-goog-otel-enabled", (Object)this.options.isOpenTelemetryTracingEnabled());
        Span listTableData = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            listTableData = this.options.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQueryRpc.listTableDataWithRowLimit").setSpanKind(SpanKind.CLIENT).setAttribute("bq.rpc.service", "TableDataService").setAttribute("bq.rpc.method", "List").setAttribute("bq.rpc.system", "http").setAttribute("bq.rpc.page_token", bqListRequest.getPageToken()).startSpan();
        }
        TableDataList bqListResponse = (TableDataList)bqListRequest.execute();
        if (listTableData != null) {
            listTableData.end();
        }
        return bqListResponse;
    }

    @Override
    public Job getJob(String projectId, String jobId, String location, Map<BigQueryRpc.Option, ?> options) {
        try {
            return this.getJobSkipExceptionTranslation(projectId, jobId, location, options);
        }
        catch (IOException ex) {
            BigQueryException serviceException = HttpBigQueryRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                return null;
            }
            throw serviceException;
        }
    }

    @InternalApi(value="internal to java-bigquery")
    public Job getJobSkipExceptionTranslation(String projectId, String jobId, String location, Map<BigQueryRpc.Option, ?> options) throws IOException {
        this.validateRPC();
        Bigquery.Jobs.Get bqGetRequest = this.bigquery.jobs().get(projectId, jobId).setPrettyPrint(Boolean.valueOf(false)).setLocation(location).setFields(BigQueryRpc.Option.FIELDS.getString(options));
        bqGetRequest.getRequestHeaders().set("x-goog-otel-enabled", (Object)this.options.isOpenTelemetryTracingEnabled());
        Span getJob = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            getJob = this.options.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQueryRpc.getJob").setSpanKind(SpanKind.CLIENT).setAttribute("bq.rpc.service", "JobService").setAttribute("bq.rpc.method", "GetJob").setAttribute("bq.rpc.system", "http").setAllAttributes(HttpBigQueryRpc.otelAttributesFromOptions(options)).startSpan();
        }
        Job jobResponse = (Job)bqGetRequest.execute();
        if (getJob != null) {
            getJob.setAttribute("bq.rpc.response.job.id", jobResponse.getId());
            getJob.setAttribute("bq.rpc.response.job.status.state", jobResponse.getStatus().getState());
            getJob.end();
        }
        return jobResponse;
    }

    @Override
    public Job getQueryJob(String projectId, String jobId, String location) {
        try {
            return this.getQueryJobSkipExceptionTranslation(projectId, jobId, location);
        }
        catch (IOException ex) {
            BigQueryException serviceException = HttpBigQueryRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                return null;
            }
            throw serviceException;
        }
    }

    @InternalApi(value="internal to java-bigquery")
    public Job getQueryJobSkipExceptionTranslation(String projectId, String jobId, String location) throws IOException {
        this.validateRPC();
        Bigquery.Jobs.Get bqGetRequest = this.bigquery.jobs().get(projectId, jobId).setPrettyPrint(Boolean.valueOf(false)).setLocation(location);
        bqGetRequest.getRequestHeaders().set("x-goog-otel-enabled", (Object)this.options.isOpenTelemetryTracingEnabled());
        Span getJob = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            getJob = this.options.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQueryRpc.getQueryJob").setSpanKind(SpanKind.CLIENT).setAttribute("bq.rpc.service", "JobService").setAttribute("bq.rpc.method", "GetJob").setAttribute("bq.rpc.system", "http").startSpan();
        }
        Job jobResponse = (Job)bqGetRequest.execute();
        if (getJob != null) {
            getJob.setAttribute("bq.rpc.response.job.id", jobResponse.getId());
            getJob.setAttribute("bq.rpc.response.job.status.state", jobResponse.getStatus().getState());
            getJob.end();
        }
        return jobResponse;
    }

    @Override
    public Tuple<String, Iterable<Job>> listJobs(String projectId, Map<BigQueryRpc.Option, ?> options) {
        try {
            return this.listJobsSkipExceptionTranslation(projectId, options);
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @InternalApi(value="internal to java-bigquery")
    public Tuple<String, Iterable<Job>> listJobsSkipExceptionTranslation(String projectId, Map<BigQueryRpc.Option, ?> options) throws IOException {
        this.validateRPC();
        Bigquery.Jobs.List listJobsRequest = this.bigquery.jobs().list(projectId).setPrettyPrint(Boolean.valueOf(false)).setAllUsers(BigQueryRpc.Option.ALL_USERS.getBoolean(options)).setFields(BigQueryRpc.Option.FIELDS.getString(options)).setStateFilter((List)BigQueryRpc.Option.STATE_FILTER.get(options)).setMaxResults(BigQueryRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(BigQueryRpc.Option.PAGE_TOKEN.getString(options)).setProjection(DEFAULT_PROJECTION).setParentJobId(BigQueryRpc.Option.PARENT_JOB_ID.getString(options));
        if (BigQueryRpc.Option.MIN_CREATION_TIME.getLong(options) != null) {
            listJobsRequest.setMinCreationTime(BigInteger.valueOf(BigQueryRpc.Option.MIN_CREATION_TIME.getLong(options)));
        }
        if (BigQueryRpc.Option.MAX_CREATION_TIME.getLong(options) != null) {
            listJobsRequest.setMaxCreationTime(BigInteger.valueOf(BigQueryRpc.Option.MAX_CREATION_TIME.getLong(options)));
        }
        listJobsRequest.getRequestHeaders().set("x-goog-otel-enabled", (Object)this.options.isOpenTelemetryTracingEnabled());
        Span listJobs = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            listJobs = this.options.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQueryRpc.listJobs").setSpanKind(SpanKind.CLIENT).setAttribute("bq.rpc.service", "JobService").setAttribute("bq.rpc.method", "ListJobs").setAttribute("bq.rpc.system", "http").setAttribute("bq.rpc.page_token", listJobsRequest.getPageToken()).setAllAttributes(HttpBigQueryRpc.otelAttributesFromOptions(options)).startSpan();
        }
        JobList jobsList = (JobList)listJobsRequest.execute();
        if (listJobs != null) {
            listJobs.setAttribute("bq.rpc.next_page_token", jobsList.getNextPageToken());
            listJobs.end();
        }
        List jobs = jobsList.getJobs();
        return Tuple.of((Object)jobsList.getNextPageToken(), (Object)Iterables.transform((Iterable)(jobs != null ? jobs : ImmutableList.of()), (Function)new Function<JobList.Jobs, Job>(){

            public Job apply(JobList.Jobs jobPb) {
                JobStatus statusPb;
                JobStatus jobStatus = statusPb = jobPb.getStatus() != null ? jobPb.getStatus() : new JobStatus();
                if (statusPb.getState() == null) {
                    statusPb.setState(jobPb.getState());
                }
                if (statusPb.getErrorResult() == null) {
                    statusPb.setErrorResult(jobPb.getErrorResult());
                }
                return new Job().setConfiguration(jobPb.getConfiguration()).setId(jobPb.getId()).setJobReference(jobPb.getJobReference()).setKind(jobPb.getKind()).setStatistics(jobPb.getStatistics()).setStatus(statusPb).setUserEmail(jobPb.getUserEmail());
            }
        }));
    }

    @Override
    public boolean cancel(String projectId, String jobId, String location) {
        try {
            return this.cancelSkipExceptionTranslation(projectId, jobId, location);
        }
        catch (IOException ex) {
            BigQueryException serviceException = HttpBigQueryRpc.translate(ex);
            if (serviceException.getCode() == 404) {
                return false;
            }
            throw serviceException;
        }
    }

    @InternalApi(value="internal to java-bigquery")
    public boolean cancelSkipExceptionTranslation(String projectId, String jobId, String location) throws IOException {
        this.validateRPC();
        Bigquery.Jobs.Cancel bqCancelRequest = this.bigquery.jobs().cancel(projectId, jobId).setLocation(location).setPrettyPrint(Boolean.valueOf(false));
        bqCancelRequest.getRequestHeaders().set("x-goog-otel-enabled", (Object)this.options.isOpenTelemetryTracingEnabled());
        Span cancelJob = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            cancelJob = this.options.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQueryRpc.cancelJob").setSpanKind(SpanKind.CLIENT).setAttribute("bq.rpc.service", "JobService").setAttribute("bq.rpc.method", "CancelJob").setAttribute("bq.rpc.system", "http").startSpan();
        }
        bqCancelRequest.execute();
        if (cancelJob != null) {
            cancelJob.end();
        }
        return true;
    }

    @Override
    public boolean deleteJob(String projectId, String jobName, String location) {
        try {
            return this.deleteJobSkipExceptionTranslation(projectId, jobName, location);
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @InternalApi(value="internal to java-bigquery")
    public boolean deleteJobSkipExceptionTranslation(String projectId, String jobName, String location) throws IOException {
        this.validateRPC();
        Bigquery.Jobs.Delete bqDeleteRequest = this.bigquery.jobs().delete(projectId, jobName).setLocation(location).setPrettyPrint(Boolean.valueOf(false));
        bqDeleteRequest.getRequestHeaders().set("x-goog-otel-enabled", (Object)this.options.isOpenTelemetryTracingEnabled());
        Span deleteJob = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            deleteJob = this.options.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQueryRpc.deleteJob").setSpanKind(SpanKind.CLIENT).setAttribute("bq.rpc.service", "JobService").setAttribute("bq.rpc.method", "DeleteJob").setAttribute("bq.rpc.system", "http").startSpan();
        }
        bqDeleteRequest.execute();
        if (deleteJob != null) {
            deleteJob.end();
        }
        return true;
    }

    @Override
    public GetQueryResultsResponse getQueryResults(String projectId, String jobId, String location, Map<BigQueryRpc.Option, ?> options) {
        try {
            return this.getQueryResultsSkipExceptionTranslation(projectId, jobId, location, options);
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @InternalApi(value="internal to java-bigquery")
    public GetQueryResultsResponse getQueryResultsSkipExceptionTranslation(String projectId, String jobId, String location, Map<BigQueryRpc.Option, ?> options) throws IOException {
        this.validateRPC();
        Bigquery.Jobs.GetQueryResults queryRequest = this.bigquery.jobs().getQueryResults(projectId, jobId).setPrettyPrint(Boolean.valueOf(false)).setLocation(location).setMaxResults(BigQueryRpc.Option.MAX_RESULTS.getLong(options)).setPageToken(BigQueryRpc.Option.PAGE_TOKEN.getString(options)).setStartIndex(BigQueryRpc.Option.START_INDEX.getLong(options) != null ? BigInteger.valueOf(BigQueryRpc.Option.START_INDEX.getLong(options)) : null).setTimeoutMs(BigQueryRpc.Option.TIMEOUT.getLong(options));
        queryRequest.getRequestHeaders().set("x-goog-otel-enabled", (Object)this.options.isOpenTelemetryTracingEnabled());
        Span getQueryResults = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            getQueryResults = this.options.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQueryRpc.getQueryResults").setSpanKind(SpanKind.CLIENT).setAttribute("bq.rpc.service", "JobService").setAttribute("bq.rpc.method", "GetQueryResults").setAttribute("bq.rpc.system", "http").setAttribute("bq.rpc.page_token", queryRequest.getPageToken()).setAllAttributes(HttpBigQueryRpc.otelAttributesFromOptions(options)).startSpan();
        }
        GetQueryResultsResponse queryResponse = (GetQueryResultsResponse)queryRequest.execute();
        if (getQueryResults != null) {
            getQueryResults.end();
        }
        return queryResponse;
    }

    @Override
    public GetQueryResultsResponse getQueryResultsWithRowLimit(String projectId, String jobId, String location, Integer maxResultPerPage, Long timeoutMs) {
        try {
            return this.getQueryResultsWithRowLimitSkipExceptionTranslation(projectId, jobId, location, maxResultPerPage, timeoutMs);
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @InternalApi(value="internal to java-bigquery")
    public GetQueryResultsResponse getQueryResultsWithRowLimitSkipExceptionTranslation(String projectId, String jobId, String location, Integer maxResultPerPage, Long timeoutMs) throws IOException {
        this.validateRPC();
        Bigquery.Jobs.GetQueryResults queryRequest = this.bigquery.jobs().getQueryResults(projectId, jobId).setPrettyPrint(Boolean.valueOf(false)).setLocation(location).setMaxResults(Long.valueOf(maxResultPerPage.intValue())).setTimeoutMs(timeoutMs);
        queryRequest.getRequestHeaders().set("x-goog-otel-enabled", (Object)this.options.isOpenTelemetryTracingEnabled());
        Span getQueryResults = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            getQueryResults = this.options.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQueryRpc.getQueryResultsWithRowLimit").setSpanKind(SpanKind.CLIENT).setAttribute("bq.rpc.service", "JobService").setAttribute("bq.rpc.method", "GetQueryResults").setAttribute("bq.rpc.system", "http").setAttribute("bq.rpc.page_token", queryRequest.getPageToken()).startSpan();
        }
        GetQueryResultsResponse queryResponse = (GetQueryResultsResponse)queryRequest.execute();
        if (getQueryResults != null) {
            getQueryResults.end();
        }
        return queryResponse;
    }

    @Override
    public QueryResponse queryRpc(String projectId, QueryRequest content) {
        try {
            return this.queryRpcSkipExceptionTranslation(projectId, content);
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @InternalApi(value="internal to java-bigquery")
    public QueryResponse queryRpcSkipExceptionTranslation(String projectId, QueryRequest content) throws IOException {
        this.validateRPC();
        Bigquery.Jobs.Query queryRequest = this.bigquery.jobs().query(projectId, content);
        queryRequest.getRequestHeaders().set("x-goog-otel-enabled", (Object)this.options.isOpenTelemetryTracingEnabled());
        Span getQueryResults = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            getQueryResults = this.options.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQueryRpc.queryRpc").setSpanKind(SpanKind.CLIENT).setAttribute("bq.rpc.service", "JobService").setAttribute("bq.rpc.method", "Query").setAttribute("bq.rpc.system", "http").startSpan();
        }
        QueryResponse queryResponse = (QueryResponse)queryRequest.execute();
        if (getQueryResults != null) {
            getQueryResults.end();
        }
        return queryResponse;
    }

    @Override
    public String open(Job loadJob) {
        try {
            return this.openSkipExceptionTranslation(loadJob);
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @InternalApi(value="internal to java-bigquery")
    public String openSkipExceptionTranslation(Job loadJob) throws IOException {
        String builder = this.options.getResolvedApiaryHost("bigquery");
        if (!builder.endsWith("/")) {
            builder = builder + "/";
        }
        builder = builder + BASE_RESUMABLE_URI + this.options.getProjectId() + "/jobs";
        GenericUrl url = new GenericUrl(builder);
        url.set("uploadType", (Object)"resumable");
        JsonFactory jsonFactory = this.bigquery.getJsonFactory();
        HttpRequestFactory requestFactory = this.bigquery.getRequestFactory();
        HttpRequest httpRequest = requestFactory.buildPostRequest(url, (HttpContent)new JsonHttpContent(jsonFactory, (Object)loadJob));
        httpRequest.getHeaders().set("X-Upload-Content-Value", (Object)"application/octet-stream");
        HttpResponse response = httpRequest.execute();
        return response.getHeaders().getLocation();
    }

    @Override
    public Job write(String uploadId, byte[] toWrite, int toWriteOffset, long destOffset, int length, boolean last) {
        try {
            return this.writeSkipExceptionTranslation(uploadId, toWrite, toWriteOffset, destOffset, length, last);
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @InternalApi(value="internal to java-bigquery")
    public Job writeSkipExceptionTranslation(String uploadId, byte[] toWrite, int toWriteOffset, long destOffset, int length, boolean last) throws IOException {
        String message;
        int code;
        if (length == 0) {
            return null;
        }
        GenericUrl url = new GenericUrl(uploadId);
        HttpRequest httpRequest = this.bigquery.getRequestFactory().buildPutRequest(url, (HttpContent)new ByteArrayContent(null, toWrite, toWriteOffset, length));
        httpRequest.setParser((ObjectParser)this.bigquery.getObjectParser());
        long limit = destOffset + (long)length;
        StringBuilder range = new StringBuilder("bytes ");
        range.append(destOffset).append('-').append(limit - 1L).append('/');
        if (last) {
            range.append(limit);
        } else {
            range.append('*');
        }
        httpRequest.getHeaders().setContentRange(range.toString());
        HttpResponseException exception = null;
        HttpResponse response = null;
        try {
            response = httpRequest.execute();
            code = response.getStatusCode();
            message = response.getStatusMessage();
        }
        catch (HttpResponseException ex) {
            exception = ex;
            code = ex.getStatusCode();
            message = ex.getStatusMessage();
        }
        if (!last && code != 308 || last && code != 200 && code != 201) {
            if (exception != null) {
                throw exception;
            }
            throw new BigQueryException(code, message);
        }
        return last && response != null ? (Job)response.parseAs(Job.class) : null;
    }

    @Override
    public Policy getIamPolicy(String resourceId, Map<BigQueryRpc.Option, ?> options) {
        try {
            return this.getIamPolicySkipExceptionTranslation(resourceId, options);
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @InternalApi(value="internal to java-bigquery")
    public Policy getIamPolicySkipExceptionTranslation(String resourceId, Map<BigQueryRpc.Option, ?> options) throws IOException {
        this.validateRPC();
        GetIamPolicyRequest policyRequest = new GetIamPolicyRequest();
        if (null != BigQueryRpc.Option.REQUESTED_POLICY_VERSION.getLong(options)) {
            policyRequest = policyRequest.setOptions(new GetPolicyOptions().setRequestedPolicyVersion(Integer.valueOf(BigQueryRpc.Option.REQUESTED_POLICY_VERSION.getLong(options).intValue())));
        }
        Bigquery.Tables.GetIamPolicy bqGetRequest = this.bigquery.tables().getIamPolicy(resourceId, policyRequest).setPrettyPrint(Boolean.valueOf(false));
        bqGetRequest.getRequestHeaders().set("x-goog-otel-enabled", (Object)this.options.isOpenTelemetryTracingEnabled());
        Span getIamPolicy = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            getIamPolicy = this.options.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQueryRpc.getIamPolicy").setSpanKind(SpanKind.CLIENT).setAttribute("bq.rpc.service", "TableService").setAttribute("bq.rpc.method", "GetIamPolicy").setAttribute("bq.rpc.system", "http").setAllAttributes(HttpBigQueryRpc.otelAttributesFromOptions(options)).startSpan();
        }
        Policy bqGetResponse = (Policy)bqGetRequest.execute();
        if (getIamPolicy != null) {
            getIamPolicy.end();
        }
        return bqGetResponse;
    }

    @Override
    public Policy setIamPolicy(String resourceId, Policy policy, Map<BigQueryRpc.Option, ?> options) {
        try {
            return this.setIamPolicySkipExceptionTranslation(resourceId, policy, options);
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    @InternalApi(value="internal to java-bigquery")
    public Policy setIamPolicySkipExceptionTranslation(String resourceId, Policy policy, Map<BigQueryRpc.Option, ?> options) throws IOException {
        this.validateRPC();
        SetIamPolicyRequest policyRequest = new SetIamPolicyRequest().setPolicy(policy);
        Bigquery.Tables.SetIamPolicy bqSetRequest = this.bigquery.tables().setIamPolicy(resourceId, policyRequest).setPrettyPrint(Boolean.valueOf(false));
        bqSetRequest.getRequestHeaders().set("x-goog-otel-enabled", (Object)this.options.isOpenTelemetryTracingEnabled());
        Span setIamPolicy = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            setIamPolicy = this.options.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQueryRpc.setIamPolicy").setSpanKind(SpanKind.CLIENT).setAttribute("bq.rpc.service", "TableService").setAttribute("bq.rpc.method", "SetIamPolicy").setAttribute("bq.rpc.system", "http").setAllAttributes(HttpBigQueryRpc.otelAttributesFromOptions(options)).startSpan();
        }
        Policy bqSetResponse = (Policy)bqSetRequest.execute();
        if (setIamPolicy != null) {
            setIamPolicy.end();
        }
        return bqSetResponse;
    }

    @Override
    public TestIamPermissionsResponse testIamPermissions(String resourceId, List<String> permissions, Map<BigQueryRpc.Option, ?> options) {
        try {
            return this.testIamPermissionsSkipExceptionTranslation(resourceId, permissions, options);
        }
        catch (IOException ex) {
            throw HttpBigQueryRpc.translate(ex);
        }
    }

    public TestIamPermissionsResponse testIamPermissionsSkipExceptionTranslation(String resourceId, List<String> permissions, Map<BigQueryRpc.Option, ?> options) throws IOException {
        this.validateRPC();
        TestIamPermissionsRequest permissionsRequest = new TestIamPermissionsRequest().setPermissions(permissions);
        Bigquery.Tables.TestIamPermissions bqTestRequest = this.bigquery.tables().testIamPermissions(resourceId, permissionsRequest).setPrettyPrint(Boolean.valueOf(false));
        bqTestRequest.getRequestHeaders().set("x-goog-otel-enabled", (Object)this.options.isOpenTelemetryTracingEnabled());
        Span testIamPermissions = null;
        if (this.options.isOpenTelemetryTracingEnabled() && this.options.getOpenTelemetryTracer() != null) {
            testIamPermissions = this.options.getOpenTelemetryTracer().spanBuilder("com.google.cloud.bigquery.BigQueryRpc.setIamPolicy").setSpanKind(SpanKind.CLIENT).setAttribute("bq.rpc.service", "TableService").setAttribute("bq.rpc.method", "SetIamPolicy").setAttribute("bq.rpc.system", "http").setAllAttributes(HttpBigQueryRpc.otelAttributesFromOptions(options)).startSpan();
        }
        TestIamPermissionsResponse bqTestResponse = (TestIamPermissionsResponse)bqTestRequest.execute();
        if (testIamPermissions != null) {
            testIamPermissions.end();
        }
        return bqTestResponse;
    }

    private static Attributes otelAttributesFromOptions(Map<BigQueryRpc.Option, ?> options) {
        Attributes attributes = Attributes.builder().build();
        for (Map.Entry<BigQueryRpc.Option, ?> entry : options.entrySet()) {
            attributes.toBuilder().put(entry.getKey().toString(), entry.getValue().toString());
        }
        return attributes;
    }
}

