/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.client.util.Data;
import com.google.api.services.bigquery.model.Routine;
import com.google.cloud.bigquery.RemoteFunctionOptions;
import com.google.cloud.bigquery.RoutineArgument;
import com.google.cloud.bigquery.RoutineId;
import com.google.cloud.bigquery.StandardSQLDataType;
import com.google.cloud.bigquery.StandardSQLTableType;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import io.opentelemetry.api.common.Attributes;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class RoutineInfo
implements Serializable {
    static final Function<Routine, RoutineInfo> FROM_PB_FUNCTION = new Function<Routine, RoutineInfo>(){

        public RoutineInfo apply(Routine pb) {
            return RoutineInfo.fromPb(pb);
        }
    };
    static final Function<RoutineInfo, Routine> TO_PB_FUNCTION = new Function<RoutineInfo, Routine>(){

        public Routine apply(RoutineInfo routineInfo) {
            return routineInfo.toPb();
        }
    };
    private final RoutineId routineId;
    private final String etag;
    private final String routineType;
    private final Long creationTime;
    private final String description;
    private final String determinismLevel;
    private final Long lastModifiedTime;
    private final String language;
    private final List<RoutineArgument> argumentList;
    private final StandardSQLDataType returnType;
    private final StandardSQLTableType returnTableType;
    private final List<String> importedLibrariesList;
    private final String body;
    private final RemoteFunctionOptions remoteFunctionOptions;
    private final String dataGovernanceType;

    RoutineInfo(BuilderImpl builder) {
        this.routineId = (RoutineId)Preconditions.checkNotNull((Object)builder.routineId);
        this.etag = builder.etag;
        this.routineType = builder.routineType;
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.determinismLevel = builder.determinismLevel;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.language = builder.language;
        this.argumentList = builder.argumentList;
        this.returnType = builder.returnType;
        this.returnTableType = builder.returnTableType;
        this.importedLibrariesList = builder.importedLibrariesList;
        this.body = builder.body;
        this.remoteFunctionOptions = builder.remoteFunctionOptions;
        this.dataGovernanceType = builder.dataGovernanceType;
    }

    public RoutineId getRoutineId() {
        return this.routineId;
    }

    public String getEtag() {
        return this.etag;
    }

    public String getRoutineType() {
        return this.routineType;
    }

    public Long getCreationTime() {
        return this.creationTime;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDeterminismLevel() {
        return this.determinismLevel;
    }

    public Long getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public String getLanguage() {
        return this.language;
    }

    public List<RoutineArgument> getArguments() {
        return this.argumentList;
    }

    public StandardSQLDataType getReturnType() {
        return this.returnType;
    }

    public StandardSQLTableType getReturnTableType() {
        return this.returnTableType;
    }

    public List<String> getImportedLibraries() {
        return this.importedLibrariesList;
    }

    public String getBody() {
        return this.body;
    }

    public RemoteFunctionOptions getRemoteFunctionOptions() {
        return this.remoteFunctionOptions;
    }

    public String getDataGovernanceType() {
        return this.dataGovernanceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("routineId", (Object)this.routineId).add("etag", (Object)this.etag).add("routineType", (Object)this.routineType).add("creationTime", (Object)this.creationTime).add("description", (Object)this.description).add("determinismLevel", (Object)this.determinismLevel).add("lastModifiedTime", (Object)this.lastModifiedTime).add("language", (Object)this.language).add("arguments", this.argumentList).add("returnType", (Object)this.returnType).add("returnTableType", (Object)this.returnTableType).add("importedLibrariesList", this.importedLibrariesList).add("body", (Object)this.body).add("remoteFunctionOptions", (Object)this.remoteFunctionOptions).add("dataGovernanceType", (Object)this.dataGovernanceType).toString();
    }

    public int hashCode() {
        return Objects.hash(this.routineId, this.etag, this.routineType, this.creationTime, this.description, this.determinismLevel, this.lastModifiedTime, this.language, this.argumentList, this.returnType, this.returnTableType, this.importedLibrariesList, this.body, this.remoteFunctionOptions, this.dataGovernanceType);
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(RoutineInfo.class) && Objects.equals(this.toPb(), ((RoutineInfo)obj).toPb());
    }

    public static Builder newBuilder(RoutineId routineId) {
        return new BuilderImpl().setRoutineId(routineId);
    }

    public static RoutineInfo of(RoutineId routineId) {
        return RoutineInfo.newBuilder(routineId).build();
    }

    RoutineInfo setProjectId(String projectId) {
        if (Strings.isNullOrEmpty((String)this.getRoutineId().getProject())) {
            return this.toBuilder().setRoutineId(this.getRoutineId().setProjectId(projectId)).build();
        }
        return this;
    }

    Routine toPb() {
        Routine routinePb = new Routine().setEtag(this.getEtag()).setRoutineType(this.getRoutineType()).setDefinitionBody(this.getBody()).setCreationTime(this.getCreationTime()).setDescription(this.getDescription()).setDeterminismLevel(this.getDeterminismLevel()).setLastModifiedTime(this.getLastModifiedTime()).setLanguage(this.getLanguage()).setDataGovernanceType(this.getDataGovernanceType());
        if (this.getRoutineId() != null) {
            routinePb.setRoutineReference(this.getRoutineId().toPb());
        }
        if (this.getArguments() != null) {
            routinePb.setArguments(Lists.transform(this.getArguments(), RoutineArgument.TO_PB_FUNCTION));
        }
        if (this.getReturnType() != null) {
            routinePb.setReturnType(this.getReturnType().toPb());
        }
        if (this.getReturnTableType() != null) {
            routinePb.setReturnTableType(this.getReturnTableType().toPb());
        }
        if (this.getRemoteFunctionOptions() != null) {
            routinePb.setRemoteFunctionOptions(this.getRemoteFunctionOptions().toPb());
        }
        if (this.getImportedLibraries() != null) {
            routinePb.setImportedLibraries(this.getImportedLibraries());
        }
        return routinePb;
    }

    static RoutineInfo fromPb(Routine routinePb) {
        return new BuilderImpl(routinePb).build();
    }

    private static String getFieldAsString(Object field) {
        return field == null ? "null" : field.toString();
    }

    protected Attributes getOtelAttributes() {
        return Attributes.builder().putAll(this.getRoutineId().getOtelAttributes()).put("bq.routine.type", RoutineInfo.getFieldAsString(this.getRoutineType())).put("bq.routine.creation_time", RoutineInfo.getFieldAsString(this.getCreationTime())).put("bq.routine.last_modified_time", RoutineInfo.getFieldAsString(this.getLastModifiedTime())).build();
    }

    static class BuilderImpl
    extends Builder {
        private RoutineId routineId;
        private String etag;
        private String routineType;
        private Long creationTime;
        private String description;
        private String determinismLevel;
        private Long lastModifiedTime;
        private String language;
        private List<RoutineArgument> argumentList;
        private StandardSQLDataType returnType;
        private StandardSQLTableType returnTableType;
        private List<String> importedLibrariesList;
        private String body;
        private RemoteFunctionOptions remoteFunctionOptions;
        private String dataGovernanceType;

        BuilderImpl() {
        }

        BuilderImpl(RoutineInfo routineInfo) {
            this.routineId = routineInfo.routineId;
            this.etag = routineInfo.etag;
            this.routineType = routineInfo.routineType;
            this.creationTime = routineInfo.creationTime;
            this.description = routineInfo.description;
            this.determinismLevel = routineInfo.determinismLevel;
            this.lastModifiedTime = routineInfo.lastModifiedTime;
            this.language = routineInfo.language;
            this.argumentList = routineInfo.argumentList;
            this.returnType = routineInfo.returnType;
            this.returnTableType = routineInfo.returnTableType;
            this.importedLibrariesList = routineInfo.importedLibrariesList;
            this.body = routineInfo.body;
            this.remoteFunctionOptions = routineInfo.remoteFunctionOptions;
            this.dataGovernanceType = routineInfo.dataGovernanceType;
        }

        BuilderImpl(Routine routinePb) {
            this.routineId = RoutineId.fromPb(routinePb.getRoutineReference());
            this.etag = routinePb.getEtag();
            this.routineType = routinePb.getRoutineType();
            this.creationTime = routinePb.getCreationTime();
            this.description = routinePb.getDescription();
            this.determinismLevel = routinePb.getDeterminismLevel();
            this.lastModifiedTime = routinePb.getLastModifiedTime();
            this.language = routinePb.getLanguage();
            if (routinePb.getArguments() != null) {
                this.argumentList = Lists.transform((List)routinePb.getArguments(), RoutineArgument.FROM_PB_FUNCTION);
            }
            if (routinePb.getReturnType() != null) {
                this.returnType = StandardSQLDataType.fromPb(routinePb.getReturnType());
            }
            if (routinePb.getReturnTableType() != null) {
                this.returnTableType = StandardSQLTableType.fromPb(routinePb.getReturnTableType());
            }
            this.importedLibrariesList = routinePb.getImportedLibraries() == null ? Collections.emptyList() : routinePb.getImportedLibraries();
            this.body = routinePb.getDefinitionBody();
            if (routinePb.getRemoteFunctionOptions() != null) {
                this.remoteFunctionOptions = RemoteFunctionOptions.fromPb(routinePb.getRemoteFunctionOptions());
            }
            this.dataGovernanceType = routinePb.getDataGovernanceType();
        }

        @Override
        Builder setRoutineId(RoutineId id) {
            this.routineId = id;
            return this;
        }

        @Override
        Builder setEtag(String etag) {
            this.etag = etag;
            return this;
        }

        @Override
        public Builder setRoutineType(String routineType) {
            this.routineType = routineType;
            return this;
        }

        @Override
        Builder setCreationTime(Long creationMillis) {
            this.creationTime = creationMillis;
            return this;
        }

        @Override
        public Builder setDescription(String description) {
            this.description = (String)MoreObjects.firstNonNull((Object)description, (Object)((String)Data.nullOf(String.class)));
            return this;
        }

        @Override
        public Builder setDeterminismLevel(String determinismLevel) {
            this.determinismLevel = determinismLevel;
            return this;
        }

        @Override
        Builder setLastModifiedTime(Long lastModifiedMillis) {
            this.lastModifiedTime = lastModifiedMillis;
            return this;
        }

        @Override
        public Builder setLanguage(String language) {
            this.language = language;
            return this;
        }

        @Override
        public Builder setArguments(List<RoutineArgument> argumentList) {
            this.argumentList = argumentList;
            return this;
        }

        @Override
        public Builder setReturnType(StandardSQLDataType returnType) {
            this.returnType = returnType;
            return this;
        }

        @Override
        public Builder setReturnTableType(StandardSQLTableType returnTableType) {
            this.returnTableType = returnTableType;
            return this;
        }

        @Override
        public Builder setImportedLibraries(List<String> importedLibrariesList) {
            this.importedLibrariesList = importedLibrariesList;
            return this;
        }

        @Override
        public Builder setBody(String body) {
            this.body = body;
            return this;
        }

        @Override
        public Builder setRemoteFunctionOptions(RemoteFunctionOptions remoteFunctionOptions) {
            this.remoteFunctionOptions = remoteFunctionOptions;
            return this;
        }

        @Override
        public Builder setDataGovernanceType(String dataGovernanceType) {
            this.dataGovernanceType = dataGovernanceType;
            return this;
        }

        @Override
        public RoutineInfo build() {
            return new RoutineInfo(this);
        }
    }

    public static abstract class Builder {
        abstract Builder setRoutineId(RoutineId var1);

        abstract Builder setEtag(String var1);

        public abstract Builder setRoutineType(String var1);

        abstract Builder setCreationTime(Long var1);

        abstract Builder setDescription(String var1);

        abstract Builder setLastModifiedTime(Long var1);

        public abstract Builder setDeterminismLevel(String var1);

        public abstract Builder setLanguage(String var1);

        public abstract Builder setArguments(List<RoutineArgument> var1);

        public abstract Builder setReturnType(StandardSQLDataType var1);

        public abstract Builder setReturnTableType(StandardSQLTableType var1);

        public abstract Builder setImportedLibraries(List<String> var1);

        public abstract Builder setBody(String var1);

        public abstract Builder setRemoteFunctionOptions(RemoteFunctionOptions var1);

        public abstract Builder setDataGovernanceType(String var1);

        public abstract RoutineInfo build();
    }
}

