/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.tableAggregator;

import crazydev.iccube.cluster.node.facts.IFactTableContext;
import crazydev.iccube.olap.entity.OlapEmptyEntity;
import crazydev.iccube.olap.entity.member.IOlapMember;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.facts.aggregation.table.IOlapFactTableAggregator;
import crazydev.iccube.olap.eval.facts.aggregation.table.IOlapFactTableAggregatorFactory;
import crazydev.iccube.olap.eval.facts.aggregation.table.IOlapFactsTableRow;
import crazydev.iccube.olap.facts.column.aggregator.ISumAggregator;
import java.util.HashMap;
import java.util.Objects;

public class AggrEventValues
implements IOlapFactTableAggregatorFactory {
    public IOlapFactTableAggregator newInstance() {
        return new IOlapFactTableAggregator(this){
            private HashMap<Comparable, String> toCurrName;
            private Integer curreColIdx;
            private Integer valueColIdx;
            private ISumAggregator sum;
            private boolean isNull;
            private Object eventCurr;
            {
                Objects.requireNonNull(this$0);
            }

            public String getName() {
                return "AggrEventValues";
            }

            public void init(IFactTableContext context, String measureName, String factColumnName) {
                this.sum = context.hpAggregator();
                this.isNull = false;
                this.eventCurr = null;
                this.valueColIdx = context.getFromColumnName(factColumnName);
                this.curreColIdx = context.getFromColumnName("EVENT_CURRENCY_ID");
                IOlapMember m = context.getContextMember("date");
                this.toCurrName = new HashMap();
                context.forEachMember("Currency (Event)", member -> {
                    Comparable id = member.getKeyValue();
                    String name = member.getNameX();
                    if (id != null) {
                        this.toCurrName.put(id, name);
                    }
                });
            }

            public boolean onRow(int rowNumber, IOlapFactsTableRow row) {
                if (this.isNull) {
                    return false;
                }
                Double value = row.getAsDouble(this.valueColIdx.intValue());
                if (value == null) {
                    return true;
                }
                Comparable curr = row.getValue(this.curreColIdx.intValue());
                if (this.eventCurr == null) {
                    this.eventCurr = curr;
                } else if (!this.eventCurr.equals(curr)) {
                    this.isNull = true;
                    return false;
                }
                this.sum.aggregate(value.doubleValue());
                return true;
            }

            public OlapScalarEntity asScalarEntity() {
                if (this.eventCurr == null || this.isNull || this.sum.isEmpty()) {
                    return OlapEmptyEntity.INSTANCE;
                }
                String currName = this.toCurrName.get(this.eventCurr);
                return this.asNumericEntityWithUnit(this.sum.aggregation(), currName, false);
            }
        };
    }
}

