/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.timedimension;

import crazydev.iccube.enums.OlapLevelType;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.plugin.olapfunctions.timedimension.OlapTimeDimensionWith;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class OlapTimeDimensionWithDayOfYear
extends OlapTimeDimensionWith {
    public static final String NAME = "WithDayOfYear";

    public OlapTimeDimensionWithDayOfYear() {
        super(NAME);
    }

    @Override
    int minValue() {
        return 1;
    }

    @Override
    int maxValue() {
        return 366;
    }

    @Override
    protected LocalDateTime apply(LocalDateTime time, OlapNumericEntity[] parameters) {
        int dayOfYear = Math.min(time.dayOfYear().getMaximumValue(), this.firstAsInteger(parameters));
        return time.withDayOfYear(dayOfYear);
    }

    @Override
    protected LocalDate apply(LocalDate time, OlapNumericEntity[] parameters) {
        int dayOfYear = Math.min(time.dayOfYear().getMaximumValue(), this.firstAsInteger(parameters));
        return time.withDayOfYear(dayOfYear);
    }

    @Override
    protected OlapLevelType getLevelChanged() {
        return OlapLevelType.DAY;
    }
}

