/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.timedimension;

import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.OlapEntity;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import java.io.Serializable;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public abstract class OlapTimeDimensionGet
extends OlapFunction {
    public OlapTimeDimensionGet(String name) {
        super("dtGet" + name, new OlapFunctionArgs(1));
    }

    public OlapEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        int getValue;
        OlapMember member = args.toMember(context, 0, true, true);
        if (member == null || member.isAll()) {
            return OlapTimeDimensionGet.asNull();
        }
        Comparable dateTime = member.getKeyValue();
        if (dateTime instanceof LocalDate) {
            LocalDate date = (LocalDate)dateTime;
            getValue = this.apply(date);
        } else if (dateTime instanceof LocalDateTime) {
            LocalDateTime time = (LocalDateTime)dateTime;
            getValue = this.apply(time);
        } else {
            return (OlapEntity)args.onFunctionError(context, OlapErrorCode.LEVEL_DATETIME_KEYTYPE_EXPECTED, new Serializable[]{member.getLevel().getUniqueName(OlapNameContext.DEFAULT_VALUES), dateTime.getClass().getSimpleName()});
        }
        return new OlapNumericEntity((long)getValue);
    }

    protected abstract int apply(LocalDateTime var1);

    protected abstract int apply(LocalDate var1);
}

