/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.timedimension;

import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.collection.olapiterator.OlapCompactIterator;
import crazydev.iccube.enums.OlapLevelType;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.mdx.member.OlapMdxTimeNavigationFunction;
import java.io.Serializable;
import java.util.Arrays;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public abstract class OlapDatesTimeDimensionFunction
extends OlapMdxTimeNavigationFunction {
    protected static final OlapFunctionArgs ARGS_1 = new OlapFunctionArgs(1, 2);

    private OlapDatesTimeDimensionFunction(String name, OlapFunctionArgs args) {
        super("dt" + name, args);
    }

    OlapDatesTimeDimensionFunction(String name) {
        this(name, ARGS_1);
    }

    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        Predicate<OlapMember> filter;
        OlapMember member = args.toMember(context, 0, true, true);
        if (member == null || member.isMdxNull()) {
            return OlapSetFactory.empty();
        }
        boolean compact = args.toOptionalBoolean(context, 1, this.compactDefaultValue());
        OlapLevel level = member.getLevel();
        OlapLevelType levelType = level.getLevelType();
        if (level.isAll() || levelType != null && levelType.isBefore(this.getLevelChanged())) {
            if (this.errorOnLevelMismatch()) {
                return (OlapNonScalarEntity)args.onFunctionError(context, OlapErrorCode.LEVEL_DATETIME_EXPECTED_LEVEL_TYPE, new Serializable[]{level.getUniqueName(OlapNameContext.DEFAULT_VALUES), "DAY", levelType == null ? "ALL" : levelType.toString()});
            }
            return OlapSetFactory.empty();
        }
        Object[] keyType = level.getMemberKeyType();
        if (!(keyType == null || keyType.length == 1 && keyType[0].isDateType())) {
            return (OlapNonScalarEntity)args.onFunctionError(context, OlapErrorCode.LEVEL_DATETIME_KEYTYPE_EXPECTED, new Serializable[]{level.getUniqueName(OlapNameContext.DEFAULT_VALUES), Arrays.toString(keyType)});
        }
        Comparable key = member.getKeyValue();
        if (key instanceof LocalDate) {
            LocalDate date = (LocalDate)key;
            filter = this.filter(date);
        } else if (key instanceof LocalDateTime) {
            LocalDateTime time = (LocalDateTime)key;
            filter = this.filter(time);
        } else {
            return (OlapNonScalarEntity)args.onFunctionError(context, OlapErrorCode.LEVEL_DATETIME_KEYTYPE_EXPECTED, new Serializable[]{level.getUniqueName(OlapNameContext.DEFAULT_VALUES), key.getClass().getSimpleName()});
        }
        OlapMember endStartPeriodMember = this.getEndPeriodMember(member);
        if (endStartPeriodMember == null) {
            return OlapSetFactory.empty();
        }
        OlapTupleSet memberSet = endStartPeriodMember.navigateMembers(args.getMemberFilter(context), filter, this.direction());
        return compact ? OlapCompactIterator.newInstance((OlapTupleSet)memberSet, (boolean)false) : memberSet;
    }

    protected boolean errorOnLevelMismatch() {
        return false;
    }

    @Nullable
    protected OlapMember getEndPeriodMember(OlapMember member) {
        return member;
    }

    protected abstract Predicate<OlapMember> filter(LocalDateTime var1);

    protected abstract Predicate<OlapMember> filter(LocalDate var1);

    protected boolean compactDefaultValue() {
        return true;
    }

    protected boolean direction() {
        return false;
    }

    protected OlapLevelType getLevelChanged() {
        return OlapLevelType.DAY;
    }

    @NotNull
    protected OlapMember getLastExistingWeekday(OlapMember member, int firstWeekDay, int lastWeekDay) {
        block3: {
            Comparable key;
            block2: {
                key = member.getKeyValue();
                if (!(key instanceof LocalDate)) break block2;
                LocalDate date = (LocalDate)key;
                for (int i = lastWeekDay; i >= firstWeekDay; --i) {
                    OlapMember nmember = member.getLevel().lookupMemberByKeyValue((Object)date.withDayOfWeek(i));
                    if (nmember == null) continue;
                    return nmember;
                }
                break block3;
            }
            if (!(key instanceof LocalDateTime)) break block3;
            LocalDateTime time = (LocalDateTime)key;
            for (int i = lastWeekDay; i >= firstWeekDay; --i) {
                OlapMember nmember = member.getLevel().lookupMemberByKeyValue((Object)time.withDayOfWeek(i));
                if (nmember == null) continue;
                return nmember;
            }
        }
        throw new CdShouldNotBeHereProgrammingException();
    }
}

