/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.timedimension;

import crazydev.iccube.collection.olapiterator.OlapCompactIterator;
import crazydev.iccube.enums.OlapLevelType;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.scalar.OlapNonScalarEntity;
import crazydev.iccube.olap.entity.set.OlapSetFactory;
import crazydev.iccube.olap.entity.set.OlapTupleSet;
import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.mdx.member.OlapMdxTimeNavigationFunction;
import java.io.Serializable;
import java.util.function.Predicate;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;

public class OlapDatesRollingMonthsTimeDimensionFunction
extends OlapMdxTimeNavigationFunction {
    public static final String NAME = "dtRollingMonths";
    protected static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2, 3);

    public OlapDatesRollingMonthsTimeDimensionFunction() {
        super(NAME, ARGS);
    }

    public OlapNonScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        Predicate<OlapMember> filter;
        boolean direction;
        OlapMember endPeriod = args.toMember(context, 0, true, true);
        if (endPeriod == null || endPeriod.isMdxNull() || endPeriod.isAll()) {
            return OlapSetFactory.empty();
        }
        OlapLevel level = endPeriod.getLevel();
        int rollingMonths = args.toInteger(context, 1);
        boolean compact = args.toOptionalBoolean(context, 2, true);
        OlapLevelType levelType = level.getLevelType();
        if (levelType == null) {
            return (OlapNonScalarEntity)args.onFunctionError(context, OlapErrorCode.LEVEL_TYPE_TIME_EXPECTED, new Serializable[]{level.getUniqueName(OlapNameContext.DEFAULT_VALUES), "NULL"});
        }
        switch (levelType) {
            case YEAR: {
                if (rollingMonths % 12 == 0) break;
                return (OlapNonScalarEntity)this.onFunctionArgTypeMismatchError((IOlapEvaluationExceptionContext)context, 1, "value that is a multiplier of 12", "" + rollingMonths, " (it's a Year level, you can't start in the middle)");
            }
            case HALF_YEAR: {
                if (rollingMonths % 6 == 0) break;
                return (OlapNonScalarEntity)this.onFunctionArgTypeMismatchError((IOlapEvaluationExceptionContext)context, 1, "value that is a multiplier of 6", "" + rollingMonths, " (it's a Half-Year level, you can't start in the middle)");
            }
            case QUARTER: {
                if (rollingMonths % 3 == 0) break;
                return (OlapNonScalarEntity)this.onFunctionArgTypeMismatchError((IOlapEvaluationExceptionContext)context, 1, "value that is a multiplier of 3", "" + rollingMonths, " (it's a Quarter level, you can't be start the middle)");
            }
            case MONTH: 
            case WEEK: 
            case DAY: 
            case HOUR: 
            case HALF_HOUR: {
                break;
            }
            default: {
                return (OlapNonScalarEntity)args.onFunctionError(context, OlapErrorCode.LEVEL_TYPE_TIME_EXPECTED, new Serializable[]{level.getUniqueName(OlapNameContext.DEFAULT_VALUES), levelType.getName()});
            }
        }
        Comparable key = endPeriod.getKeyValue();
        boolean bl = direction = rollingMonths < 0;
        if (key instanceof LocalDate) {
            startPeriodMemberDate = ((LocalDate)key).minusMonths(rollingMonths);
            filter = olapMember -> {
                LocalDate currentDate = (LocalDate)olapMember.getKeyValue();
                return direction ? currentDate.isBefore((ReadablePartial)startPeriodMemberDate) : currentDate.isAfter((ReadablePartial)startPeriodMemberDate);
            };
        } else if (key instanceof LocalDateTime) {
            startPeriodMemberDate = ((LocalDateTime)key).minusMonths(rollingMonths);
            filter = arg_0 -> OlapDatesRollingMonthsTimeDimensionFunction.lambda$evalForCluster$1(direction, (LocalDateTime)startPeriodMemberDate, arg_0);
        } else {
            return (OlapNonScalarEntity)args.onFunctionError(context, OlapErrorCode.LEVEL_DATETIME_KEYTYPE_EXPECTED, new Serializable[]{level.getUniqueName(OlapNameContext.DEFAULT_VALUES), key.getClass().getSimpleName()});
        }
        OlapTupleSet memberSet = endPeriod.navigateMembers(args.getMemberFilter(context), filter, direction);
        return compact ? OlapCompactIterator.newInstance((OlapTupleSet)memberSet, (boolean)false) : memberSet;
    }

    private static /* synthetic */ boolean lambda$evalForCluster$1(boolean direction, LocalDateTime startPeriodMemberDate, OlapMember olapMember) {
        LocalDateTime currentDate = (LocalDateTime)olapMember.getKeyValue();
        return direction ? currentDate.isBefore((ReadablePartial)startPeriodMemberDate) : currentDate.isAfter((ReadablePartial)startPeriodMemberDate);
    }
}

