/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.stats;

import crazydev.iccube.olap.eval.exception.IOlapEvaluationExceptionContext;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFGenericApplyLambdaNode;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.mdx.numeric.OlapBaseNumericStatisticalFunction;
import crazydev.iccube.plugin.function.OlapSetCalculatorOneExpression;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import java.util.Objects;
import org.apache.commons.math3.stat.StatUtils;

public class OlapPercentileFunction
extends OlapBaseNumericStatisticalFunction {
    public static final String NAME = "Percentile";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(3){

        public boolean isLambda(int pos) {
            return pos == 1;
        }
    };

    public OlapPercentileFunction() {
        super(NAME, ARGS);
    }

    protected OlapSetCalculatorOneExpression createCalculator(final GFContext context, GFGenericApplyLambdaNode lambdaArg, GFFunctionArgs args) {
        final double percentile = args.toDouble(context, 2);
        if (percentile <= 0.0 || percentile > 100.0) {
            return (OlapSetCalculatorOneExpression)this.onFunctionArgTypeMismatchError((IOlapEvaluationExceptionContext)context, 2, "numeric between 0.0 and 100", Double.toString(percentile));
        }
        return new OlapSetCalculatorOneExpression(){
            private final DoubleArrayList values;
            {
                Objects.requireNonNull(this$0);
                this.values = new DoubleArrayList();
            }

            public void addValue(double value) {
                context.assertNotCancelling(OlapPercentileFunction.NAME);
                this.values.add(value);
            }

            public boolean isResultEmpty() {
                return this.values.isEmpty();
            }

            public double calculate() {
                return StatUtils.percentile((double[])this.values.toDoubleArray(), (double)percentile);
            }
        };
    }
}

