/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.stats;

import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFGenericApplyLambdaNode;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.mdx.numeric.OlapBaseNumericStatisticalFunction;
import crazydev.iccube.plugin.function.OlapSetCalculatorOneExpression;
import java.util.Objects;

public class OlapDistributionRankFunction
extends OlapBaseNumericStatisticalFunction {
    public static final String NAME = "DistributionRank";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1, 3){

        public boolean isLambda(int pos) {
            return pos == 1;
        }
    };

    public OlapDistributionRankFunction() {
        super(NAME, ARGS);
    }

    protected OlapSetCalculatorOneExpression createCalculator(GFContext context, GFGenericApplyLambdaNode lambdaArg, GFFunctionArgs args) {
        final double lookupValue = args.toDouble(context, 2);
        return new OlapSetCalculatorOneExpression(){
            int count;
            int countBellow;
            int countMatch;
            {
                Objects.requireNonNull(this$0);
                this.count = 0;
                this.countBellow = 0;
                this.countMatch = 0;
            }

            public void addValue(double value) {
                ++this.count;
                if (value < lookupValue) {
                    ++this.countBellow;
                } else if (value == lookupValue) {
                    ++this.countMatch;
                }
            }

            public boolean isResultEmpty() {
                return this.count == 0;
            }

            public double calculate() {
                if (this.count <= 1) {
                    return 0.0;
                }
                double value = ((double)this.countBellow + ((double)this.countMatch + 1.0) / 2.0 - 1.0) / ((double)this.count - 1.0);
                return Math.max(0.0, Math.min(value, 1.0));
            }
        };
    }
}

