/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.stats;

import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.execinstr.gf.nodes.GFGenericApplyLambdaNode;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.mdx.numeric.OlapBaseNumericStatisticalFunction;
import crazydev.iccube.plugin.function.OlapSetCalculatorOneExpression;
import java.util.Objects;

public class OlapDistributionFlatFunction
extends OlapBaseNumericStatisticalFunction {
    public static final String NAME = "DistributionFlat";
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(1, 3){

        public boolean isLambda(int pos) {
            return pos == 1;
        }
    };

    public OlapDistributionFlatFunction() {
        super(NAME, ARGS);
    }

    protected OlapSetCalculatorOneExpression createCalculator(GFContext context, GFGenericApplyLambdaNode lambdaArg, GFFunctionArgs args) {
        final double lookupValue = args.toDouble(context, 2);
        return new OlapSetCalculatorOneExpression(){
            double min;
            double max;
            {
                Objects.requireNonNull(this$0);
                this.min = Double.MAX_VALUE;
                this.max = -1.7976931348623157E308;
            }

            public void addValue(double value) {
                this.min = Math.min(this.min, value);
                this.max = Math.max(this.max, value);
            }

            public boolean isResultEmpty() {
                return this.min == Double.MAX_VALUE;
            }

            public double calculate() {
                double value = this.min == this.max ? (lookupValue < this.min ? 0.0 : (lookupValue > this.min ? 1.0 : 0.5)) : (lookupValue - this.min) / (this.max - this.min);
                return Math.max(0.0, Math.min(value, 1.0));
            }
        };
    }
}

