/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.plugin.olapfunctions.stats;

import crazydev.common.collection.CdCollections;
import crazydev.iccube.olap.entity.scalar.OlapNumericEntity;
import crazydev.iccube.olap.entity.scalar.OlapScalarEntity;
import crazydev.iccube.olap.eval.execinstr.gf.context.GFContext;
import crazydev.iccube.olap.eval.execinstr.gf.function.GFFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgs;
import crazydev.iccube.olap.eval.function.OlapFunctionArgumentType;
import crazydev.iccube.olap.eval.function.OlapScalarEntityFunction;
import java.util.ArrayList;

public abstract class OlapBaseInterpolateColorFunction
extends OlapScalarEntityFunction {
    public static final OlapFunctionArgs ARGS = new OlapFunctionArgs(2, Integer.MAX_VALUE){

        public OlapFunctionArgumentType getType(int pos) {
            switch (pos) {
                default: 
            }
            return OlapFunctionArgumentType.VALUE;
        }
    };

    public OlapBaseInterpolateColorFunction(String name) {
        super(name, ARGS);
    }

    public OlapScalarEntity evalForCluster(GFContext context, GFFunctionArgs args) {
        int color;
        double lookupPos = args.toDouble(context, 0);
        ArrayList<Integer> colors = new ArrayList<Integer>();
        for (int idx = 1; idx < args.size(); ++idx) {
            colors.add(args.toInteger(context, idx));
        }
        if (lookupPos >= 1.0 || colors.size() == 1) {
            color = (Integer)CdCollections.last(colors);
        } else if (lookupPos <= 0.0) {
            color = (Integer)CdCollections.first(colors);
        } else {
            int buckets = colors.size() - 1;
            int index = (int)(lookupPos * (double)buckets);
            int color1 = (Integer)colors.get(index);
            int color2 = (Integer)colors.get(index + 1);
            double bucketSize = 1.0 / (double)buckets;
            double perc = lookupPos / bucketSize - (double)index;
            color = this.interpolate(color1, color2, perc);
        }
        return new OlapNumericEntity((long)color);
    }

    protected abstract int interpolate(int var1, int var2, double var3);
}

